# QICore Task Rejected - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **QICore Task Rejected**

## Resource Profile: QICore Task Rejected 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-taskrejected | *Version*:7.0.2 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 4 | *Computable Name*:QICoreTaskRejected |

 
Profile of TaskRejected for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. 

"Must Have", "QI Elements" and "primary code path" are defined in the
[QI-Core Must Support section](index.md#mustsupport-flag).

**QI Elements:**
* focus: (QI) What task is acting on
* statusReason: (QI) Reason for current status
* for: (QI) Beneficiary of the Task
* executionPeriod: (QI) The time action first taken meets expectation of the rejected use case.

**Primary code path:**code

(PCPath) This element is the primary code path for this resource
[CQL Retrieve](https://cql.hl7.org/02-authorsguide.html#retrieve)

**Usage**
The Task profile defines the conformance expectations for a Task, regardless of whether it is a positive or negative statement. The TaskDone and TaskRejected profiles represent the positive and negative statements for a task.

The following example retrieves requests for `Aspirin` that have been rejected for a reason:

```
define "Aspirin Rejected for Reason":
    [MedicationRequested: Aspirin] MR
      with [TaskRejected: Fulfill] T
        such that T.focus.references(MR)
          and T.statusReason in "Negation Reason Codes"
```

For a more complete discussion of representation of negation within QICore and quality improvement artifacts, see the [Negation in QI-Core](negation.md) topic.

 See the[patterns](patterns.md)page for implementation and usage patterns. 

### Examples

 

| | |
| :--- | :--- |
| [Task rejected using a value set](Task-negation-example.md) | Medication reconciliation not done due to patient declination; indicates that none of the tasks in the given `codeOptions` value set were performed. |
| [Task rejected using a code](Task-negation-with-code-example.md) | Medication reconciliation not done due to patient declination; indicates that the specific task, by code, was not done. |
| [Fulfillment task rejecting a request](Task-rejected-with-code-example.md) | Indicates the request for Graduated compression elastic hosiery (specific code) was rejected. |
| [Fulfillment task rejecting a request](Task-rejected-example.md) | Indicates the request for Intermittent pneumatic compression devices (value set) was rejected. |

 

**Usages:**

* Examples for this Profile: [Task/negation-example](Task-negation-example.md), [Task/negation-with-code-example](Task-negation-with-code-example.md), [Task/rejected-example](Task-rejected-example.md) and [Task/rejected-with-code-example](Task-rejected-with-code-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.qicore|current/StructureDefinition/qicore-taskrejected)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-qicore-taskrejected.csv), [Excel](StructureDefinition-qicore-taskrejected.xlsx), [Schematron](StructureDefinition-qicore-taskrejected.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "qicore-taskrejected",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-primaryCodePath",
      "valueString" : "code"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isIncluded",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isRetrievable",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-label",
      "valueString" : "TaskRejected"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-taskrejected",
  "version" : "7.0.2",
  "name" : "QICoreTaskRejected",
  "title" : "QICore Task Rejected",
  "status" : "active",
  "experimental" : false,
  "date" : "2021-06-23",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Profile of TaskRejected for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Task",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Task",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Task",
        "path" : "Task",
        "mustSupport" : false
      },
      {
        "id" : "Task.status",
        "path" : "Task.status",
        "short" : "(QI) The potential performer who claimed ownership of the task has decided not to execute it prior to performing any action",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "fixedCode" : "rejected"
      },
      {
        "id" : "Task.statusReason",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Task.statusReason",
        "short" : "(QI) Reason for current status",
        "min" : 1,
        "max" : "1",
        "mustSupport" : false,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/us/qicore/ValueSet/qicore-negation-reason"
        }
      },
      {
        "id" : "Task.focus",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Task.focus",
        "short" : "(QI) What task is acting on",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Resource"]
          }
        ],
        "mustSupport" : false
      },
      {
        "id" : "Task.for",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Task.for",
        "short" : "(QI) Beneficiary of the Task",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient"
            ]
          }
        ],
        "mustSupport" : false
      },
      {
        "id" : "Task.executionPeriod",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Task.executionPeriod",
        "short" : "(QI) The time action first taken meets expectation of the rejected use case.",
        "min" : 1,
        "max" : "1"
      }
    ]
  }
}

```
