# QICore Procedure Not Done - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **QICore Procedure Not Done**

## Resource Profile: QICore Procedure Not Done 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-procedurenotdone | *Version*:7.0.2 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 4 | *Computable Name*:QICoreProcedureNotDone |

 
Negative profile of Procedure for decision support/quality metrics. Indicates that a procedure was not done for a reason. 

"Must Have", "QI Elements" and "primary code path" are defined in the
[QI-Core Must Support section](index.md#mustsupport-flag).

**Must Have:**
* subject: (QI) Who the procedure was performed on
* code: (QI) What procedure
* status: (QI) not-done

**QI Elements:**
* performed[x]: (QI) When the procedure was performed
* reasonCode: (QI) Coded reason procedure performed
* reasonReference: (QI) The justification that the procedure was performed
* basedOn: (QI) A request for this procedure
* code.extension(codeOptions): (QI) Url of a value set of candidate procedures
* statusReason: (QI) Reason for the current status
* extension(recorded): (QI) When the procedure was first captured in the subject's record

**Primary code path:**code

(PCPath) This element is the primary code path for this resource
[CQL Retrieve](https://cql.hl7.org/02-authorsguide.html#retrieve)

**Usage**
The Procedure profile defines the conformance expectations for a Procedure, regardless of whether it is a positive or negative statement. The ProcedureDone and ProcedureNotDone profiles represent the positive and negative statements for a procedure.

To create an expression indicating existence of a procedure, use the profile [QICoreProcedureDone](StructureDefinition-qicore-proceduredone.md); to specifically request information that a procedure intentionally did not occur for a medical, patient or system reason, use the profile [QICoreProcedureNotDone](StructureDefinition-qicore-procedurenotdone.md).

The following example illustrates the use of the ProcedureNotDone profile:

```
define "Intermittent Pneumatic Compression Devices Not Applied":
  [ProcedureNotDone: "Application of Intermittent Pneumatic Compression Devices (IPC)"] DeviceNotApplied
    where DeviceNotApplied.statusReason in "Medical Reason" 
      or DeviceNotApplied.statusReason in "Patient Refusal"
```

For a more complete discussion of representation of negation within QI-Core and quality improvement artifacts, see the [Negation in QI-Core](negation.md) topic.

 See the[patterns](patterns.md)page for implementation and usage patterns. 

### Examples

 

| | |
| :--- | :--- |
| [Negation Example with valuset](Procedure-negation-example.md) | Procedure not performed due to complications; indicates that none of the procedures in the given `codeOptions` value set were performed. |
| [Negation Example with code](Procedure-negation-with-code-example.md) | Procedure not performed due to complications; indicates that a specific procedure, by code, was not performed. |

 

**Usages:**

* Examples for this Profile: [Procedure/negation-example](Procedure-negation-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.qicore|current/StructureDefinition/qicore-procedurenotdone)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-qicore-procedurenotdone.csv), [Excel](StructureDefinition-qicore-procedurenotdone.xlsx), [Schematron](StructureDefinition-qicore-procedurenotdone.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "qicore-procedurenotdone",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-primaryCodePath",
      "valueString" : "code"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isIncluded",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isRetrievable",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-label",
      "valueString" : "ProcedureNotDone"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-procedurenotdone",
  "version" : "7.0.2",
  "name" : "QICoreProcedureNotDone",
  "title" : "QICore Procedure Not Done",
  "status" : "active",
  "experimental" : false,
  "date" : "2018-08-22",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Negative profile of Procedure for decision support/quality metrics. Indicates that a procedure was not done for a reason.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Procedure",
  "baseDefinition" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-procedure",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Procedure",
        "path" : "Procedure",
        "mustSupport" : false
      },
      {
        "id" : "Procedure.extension:recorded",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Procedure.extension",
        "sliceName" : "recorded",
        "short" : "(QI) When the procedure was first captured in the subject's record",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/5.0/StructureDefinition/extension-Procedure.recorded"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.status",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Procedure.status",
        "short" : "(QI) not-done",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "fixedCode" : "not-done"
      },
      {
        "id" : "Procedure.statusReason",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Procedure.statusReason",
        "short" : "(QI) Reason for the current status",
        "min" : 1,
        "max" : "1",
        "binding" : {
          "strength" : "extensible",
          "description" : "The reason the procedure was not done",
          "valueSet" : "http://hl7.org/fhir/us/qicore/ValueSet/qicore-negation-reason"
        }
      }
    ]
  }
}

```
