# QICore Organization - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **QICore Organization**

## Resource Profile: QICore Organization 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-organization | *Version*:7.0.2 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 4 | *Computable Name*:QICoreOrganization |

 
Profile of Organization for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. 

"Must Have", "QI Elements" and "primary code path" are defined in the
[QI-Core Must Support section](index.md#mustsupport-flag).

**Must Have:**
* active: Whether the organization's record is still in active use
* name: Name used for the organization

**QI Elements:**
* identifier.use: (QI) usual | official | temp | secondary | old (If known)
* identifier.value: (QI) The value that is unique
* identifier(ein): (QI) Employer Identification Number
* identifier(ccn): (QI) CMS Certification Number
* type: (QI) Kind of organization

**Primary code path:**type

(PCPath) This element is the primary code path for this resource
[CQL Retrieve](https://cql.hl7.org/02-authorsguide.html#retrieve)

**Usage**
 See the[patterns](patterns.md)page for implementation and usage patterns. 

### Examples

 

| |
| :--- |
| [HL7 Example](Organization-example.md) |

 

**Usages:**

* Refer to this Profile: [QICore CareTeam](StructureDefinition-qicore-careteam.md), [QICore Claim](StructureDefinition-qicore-claim.md), [QICore ClaimResponse](StructureDefinition-qicore-claimresponse.md), [QICore Communication](StructureDefinition-qicore-communication.md)...Show 19 more,[QICore CommunicationRequest](StructureDefinition-qicore-communicationrequest.md),[QICore Coverage](StructureDefinition-qicore-coverage.md),[QICore DiagnosticReport Profile for Laboratory Results Reporting](StructureDefinition-qicore-diagnosticreport-lab.md),[QICore DiagnosticReport Profile for Report and Note Exchange](StructureDefinition-qicore-diagnosticreport-note.md),[QICore Encounter](StructureDefinition-qicore-encounter.md),[QICore Flag](StructureDefinition-qicore-flag.md),[QICore ImagingStudy](StructureDefinition-qicore-imagingstudy.md),[QICore ImmunizationEvaluation](StructureDefinition-qicore-immunizationevaluation.md),[QICore ImmunizationRecommendation](StructureDefinition-qicore-immunizationrecommendation.md),[QICore Location](StructureDefinition-qicore-location.md),[QICore Medication](StructureDefinition-qicore-medication.md),[QICore NonPatient Observation](StructureDefinition-qicore-nonpatient-observation.md),[QICore Observation Screening Assessment](StructureDefinition-qicore-observation-screening-assessment.md),[QICore Organization](StructureDefinition-qicore-organization.md),[QICore PractitionerRole](StructureDefinition-qicore-practitionerrole.md),[QICore Procedure](StructureDefinition-qicore-procedure.md),[QICore QuestionnaireResponse](StructureDefinition-qicore-questionnaireresponse.md),[QICore ServiceRequest](StructureDefinition-qicore-servicerequest.md)and[QICore Simple Observation](StructureDefinition-qicore-simple-observation.md)
* Examples for this Profile: [Health Level Seven International](Organization-example.md) and [HENDRICKS COUNTY HOSPITAL](Organization-example1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.qicore|current/StructureDefinition/qicore-organization)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-qicore-organization.csv), [Excel](StructureDefinition-qicore-organization.xlsx), [Schematron](StructureDefinition-qicore-organization.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "qicore-organization",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-primaryCodePath",
      "valueString" : "type"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isIncluded",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isRetrievable",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-label",
      "valueString" : "Organization"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-organization",
  "version" : "7.0.2",
  "name" : "QICoreOrganization",
  "title" : "QICore Organization",
  "status" : "active",
  "experimental" : false,
  "date" : "2018-08-22",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Profile of Organization for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Organization",
  "baseDefinition" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organization",
        "path" : "Organization"
      },
      {
        "id" : "Organization.identifier:ccn",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Organization.identifier",
        "sliceName" : "ccn",
        "short" : "(QI) CMS Certification Number",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "patternIdentifier" : {
          "system" : "http://terminology.hl7.org/NamingSystem/CMSCertificationNumber"
        }
      },
      {
        "id" : "Organization.identifier:ccn.use",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Organization.identifier.use",
        "short" : "(QI) usual | official | temp | secondary | old (If known)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ]
      },
      {
        "id" : "Organization.identifier:ccn.value",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Organization.identifier.value",
        "short" : "(QI) The value that is unique",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Organization.identifier:ein",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Organization.identifier",
        "sliceName" : "ein",
        "short" : "(QI) Employer Identification Number",
        "comment" : "There is not a general Tax Identifier Numer (TIN) OID. There is an SSN, a PTIN, and an ITIN, but no TIN generally. So the only slice specified here is EIN, if consumers determine a need for an SSN, submit a comment to that effect.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "patternIdentifier" : {
          "system" : "urn:oid:2.16.840.1.113883.4.4"
        }
      },
      {
        "id" : "Organization.identifier:ein.use",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Organization.identifier.use",
        "short" : "(QI) usual | official | temp | secondary | old (If known)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ]
      },
      {
        "id" : "Organization.identifier:ein.value",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Organization.identifier.value",
        "short" : "(QI) The value that is unique",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Organization.type",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Organization.type",
        "short" : "(QI) Kind of organization",
        "binding" : {
          "strength" : "preferred",
          "description" : "Used to categorize the organization",
          "valueSet" : "http://hl7.org/fhir/ValueSet/organization-type"
        }
      },
      {
        "id" : "Organization.partOf",
        "path" : "Organization.partOf",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-organization"
            ]
          }
        ]
      },
      {
        "id" : "Organization.endpoint",
        "path" : "Organization.endpoint",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Endpoint"]
          }
        ]
      }
    ]
  }
}

```
