# QICore Observation Clinical Result - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **QICore Observation Clinical Result**

## Resource Profile: QICore Observation Clinical Result 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-observation-clinical-result | *Version*:7.0.2 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 4 | *Computable Name*:QICoreObservationClinicalResult |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | | |

 
This profile sets minimum expectations for the Observation resource to record and search non-laboratory clinical test results (e.g., radiology and other clinical observations generated from procedures). An example would be when a gastroenterologist reports the size of a polyp observed during a colonoscopy. This profile is the basis for the US Core Clinical Result Profile, which defines additional data elements to record and search laboratory test results. 

"Must Have", "QI Elements" and "primary code path" are defined in the
[QI-Core Must Support section](index.md#mustsupport-flag).

**Must Have:**
* code: (QI) Clinical Test or Procedure Name
* subject: (QI) Who and/or what the observation is about
* category: (QI) Classification of type of observation
* status: (QI) registered | prliminary | final | amended | corrected | cancelled | entered-in-error | unknown

**QI Elements:**
* value[x]: (QI) Result Value
* dataAbsentReason: (QI) Why the result is missing
* category(us-core): (QI) Classification of type of observation
* effective[x]: (QI) Clinically relevant time/time-period for observation

**Primary code path:**code

(PCPath) This element is the primary code path for this resource
[CQL Retrieve](https://cql.hl7.org/02-authorsguide.html#retrieve)

**Usage**
 See the[patterns](patterns.md)page for implementation and usage patterns. 

### Examples

 

| |
| :--- |
| [Heart rate rhythm clinical result example](Observation-clinical-result-heart-rate-rhythm.md) |

 

**Usages:**

* Refer to this Profile: [QICore DiagnosticReport Profile for Report and Note Exchange](StructureDefinition-qicore-diagnosticreport-note.md)
* Examples for this Profile: [Observation/clinical-result-heart-rate-rhythm](Observation-clinical-result-heart-rate-rhythm.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.qicore|current/StructureDefinition/qicore-observation-clinical-result)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-qicore-observation-clinical-result.csv), [Excel](StructureDefinition-qicore-observation-clinical-result.xlsx), [Schematron](StructureDefinition-qicore-observation-clinical-result.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "qicore-observation-clinical-result",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-primaryCodePath",
      "valueString" : "code"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isIncluded",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isRetrievable",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-label",
      "valueString" : "ObservationClinicalResult"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-observation-clinical-result",
  "version" : "7.0.2",
  "name" : "QICoreObservationClinicalResult",
  "title" : "QICore Observation Clinical Result",
  "status" : "active",
  "date" : "2022-04-20",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "This profile sets minimum expectations for the Observation resource to record and search non-laboratory clinical test results (e.g., radiology and other clinical observations generated from procedures). An example would be when a gastroenterologist reports the size of a polyp observed during a colonoscopy. This profile is the basis for the US Core Clinical  Result Profile, which defines additional data elements to record and search laboratory test results.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-clinical-result",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation"
      },
      {
        "id" : "Observation.status",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Observation.status",
        "short" : "(QI) registered | prliminary | final | amended | corrected | cancelled | entered-in-error | unknown"
      },
      {
        "id" : "Observation.category",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Observation.category",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "short" : "(QI) Classification of  type of observation",
        "definition" : "A code that classifies the general type of observation being made.",
        "comment" : "In addition to the required category valueset, this element allows various categorization schemes based on the owner’s definition of the category and effectively multiple categories can be used at once.  The level of granularity is defined by the category concepts in the value set.",
        "requirements" : "Used for filtering what observations are retrieved and displayed.",
        "min" : 1,
        "max" : "*",
        "base" : {
          "path" : "Observation.category",
          "min" : 0,
          "max" : "*"
        },
        "isModifier" : false,
        "isSummary" : false,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ObservationCategory"
            }
          ],
          "strength" : "preferred",
          "description" : "Codes for high level observation categories.",
          "valueSet" : "http://hl7.org/fhir/ValueSet/observation-category"
        }
      },
      {
        "id" : "Observation.category:us-core",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Observation.category",
        "sliceName" : "us-core",
        "short" : "(QI) Classification of type of observation",
        "definition" : "A code that classifies the general type of observation being made.",
        "comment" : "In addition to the required category valueset, this element allows various categorization schemes based on the owner’s definition of the category and effectively multiple categories can be used at once.  The level of granularity is defined by the category concepts in the value set.",
        "requirements" : "Used for filtering what observations are retrieved and displayed.",
        "min" : 0,
        "max" : "*",
        "base" : {
          "path" : "Observation.category",
          "min" : 0,
          "max" : "*"
        },
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "isModifier" : false,
        "isSummary" : false,
        "binding" : {
          "strength" : "required",
          "description" : "Note that other codes are permitted, see [Required Bindings When Slicing by Value Sets](http://hl7.org/fhir/us/core/general-requirements.html#required-bindings-when-slicing-by-valuesets)",
          "valueSet" : "http://hl7.org/fhir/us/core/ValueSet/us-core-clinical-result-observation-category"
        }
      },
      {
        "id" : "Observation.code",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Observation.code",
        "short" : "(QI) Clinical Test or Procedure Name",
        "isModifier" : false,
        "isSummary" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/ValueSet/observation-codes"
        }
      },
      {
        "id" : "Observation.subject",
        "path" : "Observation.subject",
        "short" : "(QI) Who and/or what the observation is about",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient",
              "http://hl7.org/fhir/StructureDefinition/Group",
              "http://hl7.org/fhir/StructureDefinition/Device",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-location"
            ]
          }
        ]
      },
      {
        "id" : "Observation.effective[x]",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Observation.effective[x]",
        "short" : "(QI) Clinically relevant time/time-period for observation",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                "valueBoolean" : true
              }
            ],
            "code" : "dateTime"
          },
          {
            "code" : "Period"
          },
          {
            "code" : "Timing"
          },
          {
            "code" : "instant"
          }
        ],
        "isModifier" : false
      },
      {
        "id" : "Observation.value[x]",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Observation.value[x]",
        "short" : "(QI) Result Value",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                "valueBoolean" : true
              }
            ],
            "code" : "Quantity"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                "valueBoolean" : true
              }
            ],
            "code" : "CodeableConcept"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                "valueBoolean" : true
              }
            ],
            "code" : "string"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                "valueBoolean" : true
              }
            ],
            "code" : "boolean"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                "valueBoolean" : true
              }
            ],
            "code" : "integer"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                "valueBoolean" : true
              }
            ],
            "code" : "Range"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                "valueBoolean" : true
              }
            ],
            "code" : "Ratio"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                "valueBoolean" : true
              }
            ],
            "code" : "SampledData"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                "valueBoolean" : true
              }
            ],
            "code" : "time"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                "valueBoolean" : true
              }
            ],
            "code" : "dateTime"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                "valueBoolean" : true
              }
            ],
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "Observation.dataAbsentReason",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Observation.dataAbsentReason",
        "short" : "(QI) Why the result is missing",
        "isModifier" : false,
        "isSummary" : false,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ObservationValueAbsentReason"
            }
          ],
          "strength" : "extensible",
          "description" : "Codes specifying why the result (`Observation.value[x]`) is missing.",
          "valueSet" : "http://hl7.org/fhir/ValueSet/data-absent-reason"
        }
      }
    ]
  }
}

```
