# QICore MedicationDispense Declined - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **QICore MedicationDispense Declined**

## Resource Profile: QICore MedicationDispense Declined 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medicationdispensedeclined | *Version*:7.0.2 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 4 | *Computable Name*:QICoreMedicationDispenseDeclined |

 
Negation profile of MedicationDispense for decision support/quality metrics. Indicates that a medication dispense was declined for a reason. 

"Must Have", "QI Elements" and "primary code path" are defined in the
[QI-Core Must Support section](index.md#mustsupport-flag).

**Must Have:**
* medication[x]: (QI) What medication was supplied
* subject: (QI) Who the dispense is for
* status: (QI) declined

**QI Elements:**
* extension(recorded): (QI) Extension
* authorizingPrescription: (QI) Medication order that authorizes the dispense
* dosageInstruction: (QI) How the medication is to be used by the patient or administered by the caregiver
* medication[x].extension(codeOptions): (QI) Url of a value set of candidate medications
* statusReason[x]: (QI) Why a dispense was not performed
* daysSupply: (QI) Amount of medication expressed as a timing amount
* whenPrepared: (QI) When product was packaged and reviewed
* quantity: (QI) Amount dispensed
* whenHandedOver: (QI) When product was given out or mailed
* type: (QI) Trial fill, partial fill, emergency fill, etc.

**Primary code path:**medication

(PCPath) This element is the primary code path for this resource
[CQL Retrieve](https://cql.hl7.org/02-authorsguide.html#retrieve)

**Usage**
The MedicationDispense profile defines the conformance expectations for a MedicationDispense event, regardless of whether it is a positive or negative statement. The MedicationDispenseDone and MedicationDispenseDeclined profiles represent the positive and negative statements for a MedicationDispense event.

To create an expression indicating existence of a MedicationDispense event, use the profile [QICoreMedicationDispenseDone](StructureDefinition-qicore-medicationdispensedone.md); to specifically request information that a MedicationDispense intentionally did not occur for a medical, patient or system reason, use the profile [QICoreMedicationDispenseDeclined](StructureDefinition-qicore-medicationdispensedeclined.md).

The following example illustrates the use of the MedicationDispenseDeclined profile:

```
define "Dementia Medication Not Dispensed":
  ["MedicationDispenseNotDone": "Dementia Medications"] MedicationDispense
    where MedicationDispense.statusReason in "Medical Reason"
      or MedicationDispense.statusReason in "Patient Refusal"
```

For a more complete discussion of representation of negation within QI-Core and quality improvement artifacts, see the [Negation in QI-Core](negation.md) topic.

 See the[patterns](patterns.md)page for implementation and usage patterns. 

### Examples

 

| | |
| :--- | :--- |
| [Negation Example with valueset](MedicationDispense-negation-example.md) | Opthalmic Antihistamines not indicated; indicates that none of the drugs in the given `codeOptions` value set were dispensed. |
| [Negation Example with code](MedicationDispense-negation-with-code-example.md) | Alcaftadine 2.5 MG/ML Opthalmic Solution not indicated; indicates that the specific drug was not dispensed. |

 

**Usages:**

* Examples for this Profile: [MedicationDispense/negation-example](MedicationDispense-negation-example.md) and [MedicationDispense/negation-with-code-example](MedicationDispense-negation-with-code-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.qicore|current/StructureDefinition/qicore-medicationdispensedeclined)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-qicore-medicationdispensedeclined.csv), [Excel](StructureDefinition-qicore-medicationdispensedeclined.xlsx), [Schematron](StructureDefinition-qicore-medicationdispensedeclined.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "qicore-medicationdispensedeclined",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-primaryCodePath",
      "valueString" : "medication"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isIncluded",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isRetrievable",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-label",
      "valueString" : "MedicationDispenseDeclined"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medicationdispensedeclined",
  "version" : "7.0.2",
  "name" : "QICoreMedicationDispenseDeclined",
  "title" : "QICore MedicationDispense Declined",
  "status" : "active",
  "experimental" : false,
  "date" : "2018-08-22",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Negation profile of MedicationDispense for decision support/quality metrics. Indicates that a medication dispense was declined for a reason.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rx-dispense-rmim",
      "uri" : "http://www.hl7.org/v3/PORX_RM020070UV",
      "name" : "V3 Pharmacy Dispense RMIM"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MedicationDispense",
  "baseDefinition" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medicationdispense",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationDispense",
        "path" : "MedicationDispense"
      },
      {
        "id" : "MedicationDispense.extension:recorded",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationDispense.extension",
        "sliceName" : "recorded",
        "short" : "(QI) Extension",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationDispense.recorded"
            ]
          }
        ]
      },
      {
        "id" : "MedicationDispense.status",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationDispense.status",
        "short" : "(QI) declined",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "fixedCode" : "declined"
      },
      {
        "id" : "MedicationDispense.statusReason[x]",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationDispense.statusReason[x]",
        "short" : "(QI) Why a dispense was not performed",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "The reason the event did not occur or was not performed",
          "valueSet" : "http://hl7.org/fhir/us/qicore/ValueSet/qicore-negation-reason"
        }
      }
    ]
  }
}

```
