# QICore Encounter - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **QICore Encounter**

## Resource Profile: QICore Encounter 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-encounter | *Version*:7.0.2 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 4 | *Computable Name*:QICoreEncounter |

 
Profile of Encounter for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. 

"Must Have", "QI Elements" and "primary code path" are defined in the
[QI-Core Must Support section](index.md#mustsupport-flag).

**Must Have:**
* status: (QI) planned | arrived | triaged | in-progress | onleave | finished | cancelled +
* subject: (QI) The patient or group present at the encounter
* class: (QI) Classification of patient encounter
* type: (QI) Specific type of encounter

**QI Elements:**
* serviceProvider: (QI) The organization (facility) responsible for this encounter
* participant: (QI) List of participants involved in the encounter
* hospitalization: (QI) Details about the admission to a healthcare service
* reasonCode: (QI) Coded reason the encounter takes place
* period: (QI) The start and end time of the encounter
* reasonReference: (QI) Reason the encounter takes place (reference)
* location: (QI) List of locations where the patient has been

**Primary code path:**type

(PCPath) This element is the primary code path for this resource
[CQL Retrieve](https://cql.hl7.org/02-authorsguide.html#retrieve)

**Usage**
The following example illustrates accessing an inpatient encounter:

```
define "Ophthalmology Encounter Codes":
  [Encounter: class in "Inpatient Encounter Classes"] InpatientEncounter
    where InpatientEncounter.type in "Ophthalmology Encounter Codes"
```

 See the[patterns](patterns.md)page for implementation and usage patterns. 

### Examples

 

| |
| :--- |
| [Inpatient Admission for Appendicitis](Encounter-example.md) |

 

**Usages:**

* Refer to this Profile: [QICore AdverseEvent](StructureDefinition-qicore-adverseevent.md), [QICore Claim](StructureDefinition-qicore-claim.md), [QICore CommunicationRequest](StructureDefinition-qicore-communicationrequest.md), [QICore Condition Encounter Diagnosis](StructureDefinition-qicore-condition-encounter-diagnosis.md)...Show 11 more,[QICore DiagnosticReport Profile for Laboratory Results Reporting](StructureDefinition-qicore-diagnosticreport-lab.md),[QICore DiagnosticReport Profile for Report and Note Exchange](StructureDefinition-qicore-diagnosticreport-note.md),[QICore Encounter](StructureDefinition-qicore-encounter.md),[QICore ImagingStudy](StructureDefinition-qicore-imagingstudy.md),[QICore Immunization](StructureDefinition-qicore-immunization.md),[QICore Immunization Not Done](StructureDefinition-qicore-immunizationnotdone.md),[QICore MedicationAdministration](StructureDefinition-qicore-medicationadministration.md),[QICore MedicationRequest](StructureDefinition-qicore-medicationrequest.md),[QICore Laboratory Result Observation](StructureDefinition-qicore-observation-lab.md),[QICore ServiceRequest](StructureDefinition-qicore-servicerequest.md)and[QICore Task](StructureDefinition-qicore-task.md)
* Examples for this Profile: [Encounter/encounter-ed-example](Encounter-encounter-ed-example.md) and [Encounter/example](Encounter-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.qicore|current/StructureDefinition/qicore-encounter)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-qicore-encounter.csv), [Excel](StructureDefinition-qicore-encounter.xlsx), [Schematron](StructureDefinition-qicore-encounter.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "qicore-encounter",
  "meta" : {
    "lastUpdated" : "2022-07-29T00:15:18.578000+00:00"
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-primaryCodePath",
      "valueString" : "type"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isIncluded",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isRetrievable",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-label",
      "valueString" : "Encounter"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-encounter",
  "version" : "7.0.2",
  "name" : "QICoreEncounter",
  "title" : "QICore Encounter",
  "status" : "active",
  "experimental" : false,
  "date" : "2018-08-22",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Profile of Encounter for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Encounter",
  "baseDefinition" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Encounter",
        "path" : "Encounter"
      },
      {
        "id" : "Encounter.status",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Encounter.status",
        "short" : "(QI) planned | arrived | triaged | in-progress | onleave | finished | cancelled +",
        "definition" : "planned | arrived | triaged | in-progress | onleave | finished | cancelled +."
      },
      {
        "id" : "Encounter.class",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Encounter.class",
        "short" : "(QI) Classification of patient encounter",
        "definition" : "Concepts representing classification of patient encounter such as ambulatory (outpatient), inpatient, emergency, home health or others due to local variations.",
        "min" : 1,
        "max" : "1",
        "base" : {
          "path" : "Encounter.class",
          "min" : 1,
          "max" : "1"
        },
        "type" : [
          {
            "code" : "Coding"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "EncounterClass"
            }
          ],
          "strength" : "extensible",
          "description" : "Classification of the encounter.",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-ActEncounterCode"
        }
      },
      {
        "id" : "Encounter.type",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Encounter.type",
        "short" : "(QI) Specific type of encounter",
        "definition" : "Specific type of encounter (e.g. e-mail consultation, surgical day-care, skilled nursing, rehabilitation)."
      },
      {
        "id" : "Encounter.subject",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Encounter.subject",
        "short" : "(QI) The patient or group present at the encounter",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.participant",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Encounter.participant",
        "short" : "(QI) List of participants involved in the encounter"
      },
      {
        "id" : "Encounter.participant.individual",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Encounter.participant.individual",
        "short" : "(QI) Persons involved in the encounter other than the patient",
        "comment" : "Should include QICore-RelatedPerson as a possible participant, but USCore-Encounter only allows USCore-Practitioner.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-practitioner",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-practitionerrole",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-relatedperson"
            ],
            "_targetProfile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                    "valueBoolean" : false
                  }
                ]
              }
            ]
          }
        ]
      },
      {
        "id" : "Encounter.period",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Encounter.period",
        "short" : "(QI) The start and end time of the encounter",
        "definition" : "The start and end time of the encounter."
      },
      {
        "id" : "Encounter.reasonCode",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Encounter.reasonCode",
        "short" : "(QI) Coded reason the encounter takes place",
        "definition" : "Reason the encounter takes place, expressed as a code. For admissions, this can be used for a coded admission diagnosis."
      },
      {
        "id" : "Encounter.reasonReference",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Encounter.reasonReference",
        "short" : "(QI) Reason the encounter takes place (reference)",
        "min" : 0,
        "max" : "*",
        "base" : {
          "path" : "Encounter.reasonReference",
          "min" : 0,
          "max" : "*"
        },
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-condition-problems-health-concerns",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-condition-encounter-diagnosis",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-procedure",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-simple-observation",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-immunizationrecommendation"
            ],
            "_targetProfile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                    "valueBoolean" : true
                  }
                ]
              }
            ]
          }
        ],
        "isModifier" : false,
        "isSummary" : true
      },
      {
        "id" : "Encounter.hospitalization",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Encounter.hospitalization",
        "short" : "(QI) Details about the admission to a healthcare service"
      },
      {
        "id" : "Encounter.hospitalization.origin",
        "path" : "Encounter.hospitalization.origin",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-location"
            ]
          }
        ],
        "mustSupport" : false
      },
      {
        "id" : "Encounter.hospitalization.destination",
        "path" : "Encounter.hospitalization.destination",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-location"
            ]
          }
        ],
        "mustSupport" : false
      },
      {
        "id" : "Encounter.hospitalization.dischargeDisposition",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Encounter.hospitalization.dischargeDisposition",
        "short" : "(QI) Category or kind of location after discharge",
        "definition" : "Category or kind of location after discharge.",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://terminology.hl7.org/ValueSet/clinical-discharge-disposition"
        }
      },
      {
        "id" : "Encounter.location",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Encounter.location",
        "short" : "(QI) List of locations where the patient has been"
      },
      {
        "id" : "Encounter.location.location",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Encounter.location.location",
        "short" : "(QI) Location the encounter takes place",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-location"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.location.period",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Encounter.location.period",
        "short" : "(QI) Time period during which the patient was present at the location"
      },
      {
        "id" : "Encounter.serviceProvider",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Encounter.serviceProvider",
        "short" : "(QI) The organization (facility) responsible for this encounter",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-organization"
            ]
          }
        ]
      },
      {
        "id" : "Encounter.partOf",
        "path" : "Encounter.partOf",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-encounter"
            ]
          }
        ],
        "mustSupport" : false
      }
    ]
  }
}

```
