# QICore DeviceRequest - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **QICore DeviceRequest**

## Resource Profile: QICore DeviceRequest 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-devicerequest | *Version*:7.0.2 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 4 | *Computable Name*:QICoreDeviceRequest |

 
Profile of DeviceRequest for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. 

"Must Have", "QI Elements" and "primary code path" are defined in the
[QI-Core Must Support section](index.md#mustsupport-flag).

**QI Elements:**
* status: (QI) draft | active | on-hold | revoked | completed | entered-in-error | unknown
* modifierExtension(doNotPerform): (QI) Extension
* authoredOn: (QI) When recorded
* intent: (QI) proposal | plan | directive | order | original-order | reflex-order | filler-order | instance-order | option
* code[x]: (QI) Device requested
* code[x].extension(codeOptions): (QI) Url of a value set of candidate devices
* subject: (QI) Focus of request
* identifier: (QI) External Request identifier

**Primary code path:**code

(PCPath) This element is the primary code path for this resource
[CQL Retrieve](https://cql.hl7.org/02-authorsguide.html#retrieve)

**Usage**
The FHIR R4 and the QI-Core DeviceRequest profile describes the request to use of a device by a patient. The device may be any pertinent device specified in the Device resource. Examples of devices that may be requested include a wheelchair, hearing aids, or an insulin pump. The request may lead to the dispensing of the device to the patient or for use by the patient. Orders or recommendations for use of a device for a patient use the ServiceRequest resource.

The following example illustrates the use of DeviceRequest:

```
define "Device Indicating Frailty":
  [DeviceRequest: "Frailty Device"] FrailtyDeviceOrder
    where FrailtyDeviceOrder.status in { 'active', 'on-hold', 'completed' }
      and FrailtyDeviceOrder.intent in { 'order', 'original-order', 'reflex-order', 'filler-order', 'instance-order' }
      and FrailtyDeviceOrder.doNotPerform is not true
```

The DeviceRequest profile defines the conformance expectations for a DeviceRequest, regardless of whether it is a positive or negative statement. The DeviceRequested and DeviceProhibited profiles derive from DeviceRequest and represent the positive and negative statements for a device request. 

To create an expression indicating existence of a request for a device use the profile [QICoreDeviceRequested](StructureDefinition-qicore-devicerequested.md); to specifically request information that a DeviceRequest intentionally did not occur for a medical, patient or system reason, use the profile [QICoreDeviceProhibited](StructureDefinition-qicore-deviceprohibited.md).

 See the[patterns](patterns.md)page for implementation and usage patterns. 

### Examples

 

| |
| :--- |
| [General DeviceRequest Example](DeviceRequest-example.md) |

 

**Usages:**

* Derived from this Profile: [QICore Device Prohibited](StructureDefinition-qicore-deviceprohibited.md) and [QICore DeviceRequested](StructureDefinition-qicore-devicerequested.md)
* Refer to this Profile: [QICore Claim](StructureDefinition-qicore-claim.md)
* Examples for this Profile: [DeviceRequest/example](DeviceRequest-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.qicore|current/StructureDefinition/qicore-devicerequest)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-qicore-devicerequest.csv), [Excel](StructureDefinition-qicore-devicerequest.xlsx), [Schematron](StructureDefinition-qicore-devicerequest.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "qicore-devicerequest",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-primaryCodePath",
      "valueString" : "code"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isIncluded",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isRetrievable",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-label",
      "valueString" : "DeviceRequest"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-devicerequest",
  "version" : "7.0.2",
  "name" : "QICoreDeviceRequest",
  "title" : "QICore DeviceRequest",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-07-11",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Profile of DeviceRequest for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "quick",
      "uri" : "http://siframework.org/cqf",
      "name" : "Quality Improvement and Clinical Knowledge (QUICK)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "DeviceRequest",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/DeviceRequest",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "DeviceRequest",
        "path" : "DeviceRequest",
        "constraint" : [
          {
            "key" : "drq-3",
            "severity" : "error",
            "human" : "to indicate what device, either at least one coding in the code or a codeOptions extension shall be provided",
            "expression" : "(code is Reference).not() implies code.extension('http://hl7.org/fhir/StructureDefinition/codeOptions').exists() xor code.coding.exists()",
            "xpath" : "exists(f:extension)"
          }
        ],
        "mustSupport" : false
      },
      {
        "id" : "DeviceRequest.modifierExtension:doNotPerform",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "DeviceRequest.modifierExtension",
        "sliceName" : "doNotPerform",
        "short" : "(QI) Extension",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/5.0/StructureDefinition/extension-DeviceRequest.doNotPerform"
            ]
          }
        ],
        "isModifier" : true,
        "isModifierReason" : "The do not perform element changes the meaning of the request from a positive to a negative statement"
      },
      {
        "id" : "DeviceRequest.identifier",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "DeviceRequest.identifier",
        "short" : "(QI) External Request identifier"
      },
      {
        "id" : "DeviceRequest.status",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "DeviceRequest.status",
        "short" : "(QI) draft | active | on-hold | revoked | completed | entered-in-error | unknown"
      },
      {
        "id" : "DeviceRequest.intent",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "DeviceRequest.intent",
        "short" : "(QI) proposal | plan | directive | order | original-order | reflex-order | filler-order | instance-order | option"
      },
      {
        "id" : "DeviceRequest.code[x]",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "DeviceRequest.code[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "short" : "(QI) Device requested",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-device"
            ]
          },
          {
            "code" : "CodeableConcept"
          }
        ],
        "condition" : ["drq-3"],
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/device-kind"
        }
      },
      {
        "id" : "DeviceRequest.code[x]:codeReference",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "DeviceRequest.code[x]",
        "sliceName" : "codeReference",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-device"
            ]
          }
        ]
      },
      {
        "id" : "DeviceRequest.code[x]:codeCodeableConcept",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "DeviceRequest.code[x]",
        "sliceName" : "codeCodeableConcept",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "DeviceRequest.code[x]:codeCodeableConcept.extension:codeOptions",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "DeviceRequest.code[x].extension",
        "sliceName" : "codeOptions",
        "short" : "(QI) Url of a value set of candidate devices",
        "definition" : "A logical reference (e.g. a reference to ValueSet.url) to a value set/version that identifies a set of possible coded values representing the device.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/codeOptions|7.0.2"]
          }
        ],
        "condition" : ["drq-3"]
      },
      {
        "id" : "DeviceRequest.subject",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "DeviceRequest.subject",
        "short" : "(QI) Focus of request",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient"
            ]
          }
        ]
      },
      {
        "id" : "DeviceRequest.authoredOn",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "DeviceRequest.authoredOn",
        "short" : "(QI) When recorded"
      }
    ]
  }
}

```
