# QICore Condition Encounter Diagnosis - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **QICore Condition Encounter Diagnosis**

## Resource Profile: QICore Condition Encounter Diagnosis 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-condition-encounter-diagnosis | *Version*:7.0.2 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 4 | *Computable Name*:QICoreConditionEncounterDiagnosis |
| **Copyright/Legal**: Used by permission of HL7 International, all rights reserved Creative Commons License | | |

 
The QI-Core Condition Encounter Diagnosis Profile is based upon the US Core Condition Encounter Diagnosis Profile. In version 5.0.0, the QI-Core Condition Profile has been split into the QI-Core Condition Encounter Diagnosis Profile and QI-Core Condition Problems and Health Concerns Profile. To promote interoperability and adoption through consistent implementation, this profile defines constraints and extensions on the Condition resource for the minimal set of data to record, search, and retrieve information about an encounter diagnosis. It defines the core set of elements and extensions for quality rule and measure authors. 

"Must Have", "QI Elements" and "primary code path" are defined in the
[QI-Core Must Support section](index.md#mustsupport-flag).

**Must Have:**
* category: (QI) category codes
* category(us-core): encounter-diagnosis
* code: (QI) Identification of the condition, problem or diagnosis
* subject: (QI) Who has the condition?

**QI Elements:**
* clinicalStatus: (QI) active | recurrence | relapse | inactive | remission | resolved
* extension(assertedDate): (QI) Date the condition was first asserted
* encounter: (QI) Encounter created as part of
* recordedDate: (QI) Date record was first recorded
* abatement[x]: (QI) When in resolution/remission
* severity: (QI) Subjective severity of condition
* onset[x]: (QI) Estimated or actual date, date-time, or age
* verificationStatus: (QI) unconfirmed | provisional | differential | confirmed | refuted | entered-in-error

**Primary code path:**code

(PCPath) This element is the primary code path for this resource
[CQL Retrieve](https://cql.hl7.org/02-authorsguide.html#retrieve)

**Usage**
```
define "Diabetes Encounter Diagnosis":
  [ConditionEncounterDiagnosis: Diabetes]
```

 See the[patterns](patterns.md)page for implementation and usage patterns. 

### Examples

 

| |
| :--- |
| [Severe Burn Example](Condition-example.md) |
| [Appendicitis Example](Condition-appendicitis-example.md) |

 

**Usages:**

* Refer to this Profile: [QICore AdverseEvent](StructureDefinition-qicore-adverseevent.md), [QICore Claim](StructureDefinition-qicore-claim.md), [QICore Encounter](StructureDefinition-qicore-encounter.md), [QICore MedicationRequest](StructureDefinition-qicore-medicationrequest.md)...Show 2 more,[QICore Procedure](StructureDefinition-qicore-procedure.md)and[QICore ServiceRequest](StructureDefinition-qicore-servicerequest.md)
* Examples for this Profile: [Condition/appendicitis-example](Condition-appendicitis-example.md) and [Condition/example](Condition-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.qicore|current/StructureDefinition/qicore-condition-encounter-diagnosis)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-qicore-condition-encounter-diagnosis.csv), [Excel](StructureDefinition-qicore-condition-encounter-diagnosis.xlsx), [Schematron](StructureDefinition-qicore-condition-encounter-diagnosis.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "qicore-condition-encounter-diagnosis",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-primaryCodePath",
      "valueString" : "code"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isIncluded",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isRetrievable",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-label",
      "valueString" : "ConditionEncounterDiagnosis"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-condition-encounter-diagnosis",
  "version" : "7.0.2",
  "name" : "QICoreConditionEncounterDiagnosis",
  "title" : "QICore Condition Encounter Diagnosis",
  "status" : "active",
  "experimental" : false,
  "date" : "2022-04-20",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "The QI-Core Condition Encounter Diagnosis Profile is based upon the US Core Condition Encounter Diagnosis Profile.   In version 5.0.0, the QI-Core Condition Profile has been split into the QI-Core Condition Encounter Diagnosis Profile and QI-Core Condition Problems and Health Concerns Profile. To promote interoperability and adoption through consistent implementation, this profile defines constraints and extensions on the Condition resource for the minimal set of data to record, search, and retrieve information about an encounter diagnosis.  It defines the core set of elements and extensions for quality rule and measure authors.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 International, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Condition",
  "baseDefinition" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Condition",
        "path" : "Condition"
      },
      {
        "id" : "Condition.extension:assertedDate",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Condition.extension",
        "sliceName" : "assertedDate",
        "short" : "(QI) Date the condition was first asserted",
        "definition" : "The date on which the existence of the Condition was first asserted or acknowledged.",
        "comment" : "The assertedDate is in the context of the recording practitioner and might not be the same as the recordedDate.",
        "min" : 0,
        "max" : "1",
        "base" : {
          "path" : "DomainResource.extension",
          "min" : 0,
          "max" : "*"
        },
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/condition-assertedDate|5.2.0-ballot"
            ]
          }
        ],
        "mustSupport" : true,
        "isModifier" : false
      },
      {
        "id" : "Condition.clinicalStatus",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Condition.clinicalStatus",
        "short" : "(QI) active | recurrence | relapse | inactive | remission | resolved",
        "definition" : "The clinical status of the condition.",
        "comment" : "The data type is CodeableConcept because clinicalStatus has some clinical judgment involved, such that there might need to be more specificity than the required FHIR value set allows. For example, a SNOMED coding might allow for additional specificity."
      },
      {
        "id" : "Condition.verificationStatus",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Condition.verificationStatus",
        "short" : "(QI) unconfirmed | provisional | differential | confirmed | refuted | entered-in-error",
        "definition" : "The verification status to support the clinical status of the condition."
      },
      {
        "id" : "Condition.category",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Condition.category",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "short" : "(QI) category codes",
        "min" : 1,
        "max" : "*",
        "base" : {
          "path" : "Condition.category",
          "min" : 0,
          "max" : "*"
        },
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ConditionCategory"
            }
          ],
          "strength" : "extensible",
          "description" : "A category assigned to the condition.",
          "valueSet" : "http://hl7.org/fhir/ValueSet/condition-category"
        }
      },
      {
        "id" : "Condition.severity",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Condition.severity",
        "short" : "(QI) Subjective severity of condition",
        "definition" : "A subjective assessment of the severity of the condition as evaluated by the clinician."
      },
      {
        "id" : "Condition.code",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Condition.code",
        "short" : "(QI) Identification of the condition, problem or diagnosis",
        "definition" : "Identification of the condition, problem or diagnosis."
      },
      {
        "id" : "Condition.subject",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Condition.subject",
        "short" : "(QI) Who has the condition?",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient",
              "http://hl7.org/fhir/StructureDefinition/Group"
            ],
            "_targetProfile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              }
            ]
          }
        ],
        "mustSupport" : true,
        "isModifier" : false,
        "isSummary" : true
      },
      {
        "id" : "Condition.encounter",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Condition.encounter",
        "short" : "(QI) Encounter created as part of",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-encounter"
            ]
          }
        ]
      },
      {
        "id" : "Condition.onset[x]",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Condition.onset[x]",
        "short" : "(QI) Estimated or actual date, date-time, or age",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                "valueBoolean" : true
              }
            ],
            "code" : "dateTime"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                "valueBoolean" : true
              }
            ],
            "code" : "Age"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                "valueBoolean" : true
              }
            ],
            "code" : "Period"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                "valueBoolean" : true
              }
            ],
            "code" : "Range"
          }
        ]
      },
      {
        "id" : "Condition.abatement[x]",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Condition.abatement[x]",
        "short" : "(QI) When in resolution/remission",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                "valueBoolean" : true
              }
            ],
            "code" : "dateTime"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                "valueBoolean" : true
              }
            ],
            "code" : "Age"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                "valueBoolean" : true
              }
            ],
            "code" : "Period"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                "valueBoolean" : true
              }
            ],
            "code" : "Range"
          }
        ]
      },
      {
        "id" : "Condition.recordedDate",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Condition.recordedDate",
        "short" : "(QI) Date record was first recorded",
        "definition" : "The recordedDate represents when this particular Condition record was created in the system, which is often a system-generated date."
      }
    ]
  }
}

```
