# QICore Claim - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **QICore Claim**

## Resource Profile: QICore Claim 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-claim | *Version*:7.0.2 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 4 | *Computable Name*:QICoreClaim |

 
Profile of Claim for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. 

"Must Have", "QI Elements" and "primary code path" are defined in the
[QI-Core Must Support section](index.md#mustsupport-flag).

**QI Elements:**
* provider: (QI) Party responsible for the claim
* patient: (QI) The recipient of the products and services
* type: (QI) category | discipline
* billablePeriod: (QI) Relevant time frame for the claim
* Claim: Claim, Pre-determination or Pre-authorization
* use: (QI) claim | preauthorization | predetermination
* diagnosis: (QI) Pertinent diagnosis information
* procedure: (QI) Clinical procedures performed
* created: (QI) Resource creation date
* prescription: (QI) Prescription authorizing services and products
* status: (QI) active

**Primary code path:**type

(PCPath) This element is the primary code path for this resource
[CQL Retrieve](https://cql.hl7.org/02-authorsguide.html#retrieve)

**Usage**
 See the[patterns](patterns.md)page for implementation and usage patterns. 

### Examples

 

| |
| :--- |
| [Simple Vision Claim](Claim-example.md) |

 

**Usages:**

* Refer to this Profile: [QICore ClaimResponse](StructureDefinition-qicore-claimresponse.md)
* Examples for this Profile: [Claim/example](Claim-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.qicore|current/StructureDefinition/qicore-claim)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-qicore-claim.csv), [Excel](StructureDefinition-qicore-claim.xlsx), [Schematron](StructureDefinition-qicore-claim.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "qicore-claim",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-primaryCodePath",
      "valueString" : "type"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isIncluded",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isRetrievable",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-label",
      "valueString" : "Claim"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-claim",
  "version" : "7.0.2",
  "name" : "QICoreClaim",
  "title" : "QICore Claim",
  "status" : "active",
  "experimental" : false,
  "date" : "2018-08-22",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Profile of Claim for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Claim",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Claim",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Claim",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Claim",
        "mustSupport" : false
      },
      {
        "id" : "Claim.status",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Claim.status",
        "short" : "(QI) active",
        "definition" : "The status of the resource instance.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "fixedCode" : "active"
      },
      {
        "id" : "Claim.type",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Claim.type",
        "short" : "(QI) category | discipline",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Claim.use",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Claim.use",
        "short" : "(QI) claim | preauthorization | predetermination",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Claim.patient",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Claim.patient",
        "short" : "(QI) The recipient of the products and services",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient"
            ]
          }
        ]
      },
      {
        "id" : "Claim.billablePeriod",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Claim.billablePeriod",
        "short" : "(QI) Relevant time frame for the claim"
      },
      {
        "id" : "Claim.created",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Claim.created",
        "short" : "(QI) Resource creation date"
      },
      {
        "id" : "Claim.provider",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Claim.provider",
        "short" : "(QI) Party responsible for the claim",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-practitioner",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-practitionerrole",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-organization"
            ]
          }
        ]
      },
      {
        "id" : "Claim.prescription",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Claim.prescription",
        "short" : "(QI) Prescription authorizing services and products",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-devicerequest",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medicationrequest",
              "http://hl7.org/fhir/StructureDefinition/VisionPrescription"
            ]
          }
        ]
      },
      {
        "id" : "Claim.payee",
        "path" : "Claim.payee",
        "mustSupport" : false
      },
      {
        "id" : "Claim.payee.party",
        "path" : "Claim.payee.party",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-practitioner",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-practitionerrole",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-organization",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-relatedperson"
            ]
          }
        ],
        "mustSupport" : false
      },
      {
        "id" : "Claim.referral",
        "path" : "Claim.referral",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-servicerequest"
            ]
          }
        ],
        "mustSupport" : false
      },
      {
        "id" : "Claim.facility",
        "path" : "Claim.facility",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-location"
            ]
          }
        ],
        "mustSupport" : false
      },
      {
        "id" : "Claim.careTeam",
        "path" : "Claim.careTeam",
        "mustSupport" : false
      },
      {
        "id" : "Claim.careTeam.provider",
        "path" : "Claim.careTeam.provider",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-practitioner",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-practitionerrole",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-organization"
            ]
          }
        ],
        "mustSupport" : false
      },
      {
        "id" : "Claim.diagnosis",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          },
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Diagnosis"
          }
        ],
        "path" : "Claim.diagnosis",
        "short" : "(QI) Pertinent diagnosis information",
        "definition" : "Information about diagnoses relevant to the claim items.",
        "requirements" : "Required for the adjudication by provided context for the services and product listed.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "workflow",
            "map" : "Request.reasonReference"
          }
        ]
      },
      {
        "id" : "Claim.diagnosis.sequence",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Claim.diagnosis.sequence",
        "short" : "(QI) Diagnosis instance identifier",
        "type" : [
          {
            "code" : "positiveInt"
          }
        ]
      },
      {
        "id" : "Claim.diagnosis.diagnosis[x]",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Claim.diagnosis.diagnosis[x]",
        "short" : "(QI) Nature of illness or problem",
        "type" : [
          {
            "code" : "CodeableConcept"
          },
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-condition-encounter-diagnosis"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ICD10"
            }
          ],
          "strength" : "example",
          "description" : "Example ICD10 Diagnostic codes.",
          "valueSet" : "http://hl7.org/fhir/ValueSet/icd-10"
        }
      },
      {
        "id" : "Claim.diagnosis.type",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Claim.diagnosis.type",
        "short" : "(QI) Timing or nature of the diagnosis",
        "definition" : "When the condition was observed or the relative ranking.",
        "comment" : "For example: admitting, primary, secondary, discharge.",
        "requirements" : "Often required to capture a particular diagnosis, for example: primary or discharge.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "DiagnosisType"
            }
          ],
          "strength" : "preferred",
          "description" : "The type of the diagnosis: admitting, principal, discharge.",
          "valueSet" : "http://hl7.org/fhir/ValueSet/ex-diagnosistype"
        }
      },
      {
        "id" : "Claim.diagnosis.onAdmission",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Claim.diagnosis.onAdmission",
        "short" : "(QI) Present on admission",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "description" : "Present on admission.",
          "valueSet" : "http://terminology.hl7.org/ValueSet/POAIndicators"
        }
      },
      {
        "id" : "Claim.procedure",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          },
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Procedure"
          }
        ],
        "path" : "Claim.procedure",
        "short" : "(QI) Clinical procedures performed",
        "definition" : "Procedures performed on the patient relevant to the billing items with the claim.",
        "requirements" : "The specific clinical invention are sometimes required to be provided to justify billing a greater than customary amount for a service.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Claim.procedure.sequence",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Claim.procedure.sequence",
        "short" : "(QI) Procedure instance identifier",
        "type" : [
          {
            "code" : "positiveInt"
          }
        ],
        "isModifier" : false,
        "isSummary" : false
      },
      {
        "id" : "Claim.procedure.type",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Claim.procedure.type",
        "short" : "(QI) Category of Procedure",
        "definition" : "When the condition was observed or the relative ranking.",
        "comment" : "For example: primary, secondary.",
        "requirements" : "Often required to capture a particular diagnosis, for example: primary or discharge.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ProcedureType"
            }
          ],
          "strength" : "example",
          "description" : "Example procedure type codes.",
          "valueSet" : "http://hl7.org/fhir/ValueSet/ex-procedure-type"
        }
      },
      {
        "id" : "Claim.procedure.procedure[x]",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Claim.procedure.procedure[x]",
        "short" : "(QI) Specific clinical procedure",
        "type" : [
          {
            "code" : "CodeableConcept"
          },
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-procedure"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ICD10_Procedures"
            }
          ],
          "strength" : "example",
          "description" : "Example ICD10 Procedure codes.",
          "valueSet" : "http://hl7.org/fhir/ValueSet/icd-10-procedures"
        }
      },
      {
        "id" : "Claim.insurance.coverage",
        "path" : "Claim.insurance.coverage",
        "short" : "Insurance information",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-coverage"
            ]
          }
        ]
      },
      {
        "id" : "Claim.item.encounter",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Claim.item.encounter",
        "short" : "(QI) Encounters related to this billed item",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-encounter"
            ]
          }
        ]
      }
    ]
  }
}

```
