# ServiceProhibited with code example - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ServiceProhibited with code example**

## Example ServiceRequest: ServiceProhibited with code example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [QICore Service Prohibited](StructureDefinition-qicore-serviceprohibited.md)

**status**: Completed

**intent**: Order

**category**: Surgical Procedure

**priority**: Urgent

**doNotPerform**: true

**code**: Graduated compression elastic hosiery (physical object)

**subject**: [Jim Chalmers Male, DoB: 1974-12-25 ( Medical record number (use: usual, period: 2001-05-06 --> (ongoing)))](Patient-example.md)

**encounter**: [Encounter: status = in-progress; class = inpatient encounter (ActCode#IMP); type = Initial hospital inpatient or observation care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 75 minutes must be met or exceeded.](Encounter-example.md)

**occurrence**: 2013-04-05

**authoredOn**: 2013-04-04

**reasonCode**: Procedure discontinued (situation)



## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "negation-example-code",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-serviceprohibited"
    ]
  },
  "status" : "completed",
  "intent" : "order",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "387713003",
          "display" : "Surgical Procedure"
        }
      ]
    }
  ],
  "priority" : "urgent",
  "doNotPerform" : true,
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "348681001",
        "display" : "Graduated compression elastic hosiery (physical object)"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "encounter" : {
    "reference" : "Encounter/example"
  },
  "occurrenceDateTime" : "2013-04-05",
  "authoredOn" : "2013-04-04",
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "416406003",
          "display" : "Procedure discontinued (situation)"
        }
      ]
    }
  ]
}

```
