# ServiceRequest elective example - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ServiceRequest elective example**

## Example ServiceRequest: ServiceRequest elective example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

**status**: Completed

**intent**: Order

**code**: Stomach Bypass

**subject**: [Jim Chalmers Male, DoB: 1974-12-25 ( Medical record number (use: usual, period: 2001-05-06 --> (ongoing)))](Patient-example.md)

**authoredOn**: 2015-03-30

**requester**: Dr. Beverly Crusher

**performer**: [Dr Cecil Surgeon](Practitioner-example.md)



## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "elective-example",
  "status" : "completed",
  "intent" : "order",
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "442338001",
        "display" : "Bypass of stomach (procedure)"
      }
    ],
    "text" : "Stomach Bypass"
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "authoredOn" : "2015-03-30",
  "requester" : {
    "display" : "Dr. Beverly Crusher"
  },
  "performer" : [
    {
      "reference" : "Practitioner/example",
      "display" : "Dr Cecil Surgeon"
    }
  ]
}

```
