# ServiceRequest appropriateness example - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ServiceRequest appropriateness example**

## Example ServiceRequest: ServiceRequest appropriateness example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

**status**: Completed

**intent**: Order

**code**: Computed tomography, head or brain; without contrast material

**subject**: [Jim Chalmers Male, DoB: 1974-12-25 ( Medical record number (use: usual, period: 2001-05-06 --> (ongoing)))](Patient-example.md)

**authoredOn**: 2015-03-30

**requester**: Dr. Beverly Crusher

**reasonCode**: Occipital headache



## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "appropriateness-example",
  "status" : "completed",
  "intent" : "order",
  "code" : {
    "coding" : [
      {
        "system" : "http://www.ama-assn.org/go/cpt",
        "code" : "70450",
        "display" : "Computed tomography, head or brain; without contrast material"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "authoredOn" : "2015-03-30",
  "requester" : {
    "display" : "Dr. Beverly Crusher"
  },
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "330007",
          "display" : "Occipital headache"
        }
      ]
    }
  ]
}

```
