# ProcedureNotDone with value set example - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ProcedureNotDone with value set example**

## Example Procedure: ProcedureNotDone with value set example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [QICore Procedure Not Done](StructureDefinition-qicore-procedurenotdone.md)

**Extension Definition for Procedure.recorded for Version 5.0**: 2013-04-05 10:30:00-0400

**status**: Not Done

**statusReason**: Complication of medical care (disorder)

**code**: Value Set: Intermittent pneumatic compression devices (IPC) (value set: [Intermittent pneumatic compression devices](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.117.1.7.1.214/expansion))

**subject**: [Jim Chalmers Male, DoB: 1974-12-25 ( Medical record number (use: usual, period: 2001-05-06 --> (ongoing)))](Patient-example.md)

**encounter**: [Encounter: status = in-progress; class = inpatient encounter (ActCode#IMP); type = Initial hospital inpatient or observation care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 75 minutes must be met or exceeded.](Encounter-example.md)

**reasonCode**: Patient requests alternative treatment



## Resource Content

```json
{
  "resourceType" : "Procedure",
  "id" : "negation-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-procedurenotdone"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-Procedure.recorded",
      "valueDateTime" : "2013-04-05T10:30:00-04:00"
    }
  ],
  "status" : "not-done",
  "statusReason" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "35688006",
        "display" : "Complication of medical care (disorder)"
      }
    ]
  },
  "code" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/codeOptions",
        "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.117.1.7.1.214"
      }
    ],
    "text" : "Value Set: Intermittent pneumatic compression devices (IPC)"
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "encounter" : {
    "reference" : "Encounter/example"
  },
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "182890002",
          "display" : "Patient requests alternative treatment"
        }
      ]
    }
  ]
}

```
