# MedicationProhibited using value set example - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MedicationProhibited using value set example**

## Example MedicationRequest: MedicationProhibited using value set example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [QICore Medication Prohibited](StructureDefinition-qicore-medicationprohibited.md)

**status**: Completed

**intent**: Order

**category**: Community

**doNotPerform**: true

**medication**: Deoxycortone

**subject**: [Jim Chalmers Male, DoB: 1974-12-25 ( Medical record number (use: usual, period: 2001-05-06 --> (ongoing)))](Patient-example.md)

**authoredOn**: 2015-03-25 19:32:52-0500

**requester**: [Practitioner Adam Careful](Practitioner-example.md)

**reasonCode**: Drug treatment not indicated (situation)



## Resource Content

```json
{
  "resourceType" : "MedicationRequest",
  "id" : "negation-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medicationprohibited"
    ]
  },
  "status" : "completed",
  "intent" : "order",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/medicationrequest-category",
          "code" : "community"
        }
      ]
    }
  ],
  "doNotPerform" : true,
  "medicationCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "1336006"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "authoredOn" : "2015-03-25T19:32:52-05:00",
  "requester" : {
    "reference" : "Practitioner/example"
  },
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "183966005",
          "display" : "Drug treatment not indicated (situation)"
        }
      ]
    }
  ]
}

```
