# MedicationAdministration positive example - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MedicationAdministration positive example**

## Example MedicationAdministration: MedicationAdministration positive example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [QICore MedicationAdministration](StructureDefinition-qicore-medicationadministration.md)

**status**: Completed

**medication**: [Medication alemtuzumab 10 MG/ML [Lemtrada]](Medication-example.md)

**subject**: [Donald Duck](Patient-example.md)

**context**: [Encounter: status = in-progress; class = inpatient encounter (ActCode#IMP); type = Initial hospital inpatient or observation care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 75 minutes must be met or exceeded.](Encounter-example.md)

**supportingInformation**: [Condition Burn of ear](Condition-example.md)

**effective**: 2015-01-15 14:30:00+0100 --> 2015-01-15 14:30:00+0100

**request**: [MedicationRequest: status = active; intent = order; medication[x] = ->Medication alemtuzumab 10 MG/ML [Lemtrada]; authoredOn = 2015-03-25 19:32:52-0500](MedicationRequest-example.md)

### Dosages

| | | |
| :--- | :--- | :--- |
| - | **Route** | **Dose** |
| * | Intravenous route (qualifier value) | 3 mg(Details: UCUM codemg = 'mg') |



## Resource Content

```json
{
  "resourceType" : "MedicationAdministration",
  "id" : "done-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medicationadministration"
    ]
  },
  "status" : "completed",
  "medicationReference" : {
    "reference" : "Medication/example"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Donald Duck"
  },
  "context" : {
    "reference" : "Encounter/example"
  },
  "supportingInformation" : [
    {
      "reference" : "Condition/example"
    }
  ],
  "effectivePeriod" : {
    "start" : "2015-01-15T14:30:00+01:00",
    "end" : "2015-01-15T14:30:00+01:00"
  },
  "request" : {
    "reference" : "MedicationRequest/example"
  },
  "dosage" : {
    "route" : {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "47625008",
          "display" : "Intravenous route (qualifier value)"
        }
      ]
    },
    "dose" : {
      "value" : 3,
      "unit" : "mg",
      "system" : "http://unitsofmeasure.org",
      "code" : "mg"
    }
  }
}

```
