# ImagingStudy example - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ImagingStudy example**

## Example ImagingStudy: ImagingStudy example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

**CT Chest. John Smith (MRN: 09236). Accession: W12342398. Performed: 2011-01-01. 3 series, 12 images.**

 **uid**: urn:oid:2.16.124.113543.6003.1154777499.30246.19789.3503430045 

 **patient**: [Patient/example](Patient-example.md) 

 **started**: 01/01/2011 

 **numberOfSeries**: 1 

 **numberOfInstances**: 1 

> **series****uid**: urn:oid:2.16.124.113543.6003.2588828330.45298.17418.2723805630**number**: 3**modality**: CT**description**: CT Surview 180**numberOfInstances**: 1**bodySite**: { SNOMED CT code '67734004' = 'Upper Trunk Structure' })
> **instance****uid**: urn:oid:2.16.124.113543.6003.189642796.63084.16748.2599092903**number**: 1**sopClass**: urn:oid:1.2.840.10008.5.1.4.1.1.2



## Resource Content

```json
{
  "resourceType" : "ImagingStudy",
  "id" : "example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-imagingstudy"
    ]
  },
  "status" : "available",
  "subject" : {
    "reference" : "Patient/example"
  },
  "started" : "2011-01-01T11:01:20+03:00",
  "numberOfSeries" : 1,
  "numberOfInstances" : 1,
  "series" : [
    {
      "uid" : "2.16.124.113543.6003.2588828330.45298.17418.2723805630",
      "number" : 3,
      "modality" : {
        "system" : "http://dicom.nema.org/resources/ontology/DCM",
        "code" : "CT"
      },
      "description" : "CT Surview 180",
      "numberOfInstances" : 1,
      "bodySite" : {
        "system" : "http://snomed.info/sct",
        "code" : "67734004",
        "display" : "Upper Trunk Structure"
      }
    }
  ]
}

```
