# DeviceRequest negation with value set example - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **DeviceRequest negation with value set example**

## Example DeviceRequest: DeviceRequest negation with value set example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [QICore Device Prohibited](StructureDefinition-qicore-deviceprohibited.md)

**Extension Definition for DeviceRequest.doNotPerform for Version 5.0**: true

**status**: Completed

**intent**: Original Order

**code**: Value Set: Venous Foot Pumps (VFP) (value set: [Venous foot pumps](https://vsac.nlm.nih.gov/valueset/2.16.840.1.113883.3.117.1.7.1.230/expansion))

**subject**: [Jim Chalmers Male, DoB: 1974-12-25 ( Medical record number (use: usual, period: 2001-05-06 --> (ongoing)))](Patient-example.md)

**authoredOn**: 2016-04-05 09:20:00-0400

**reasonCode**: Patient requests alternative treatment



## Resource Content

```json
{
  "resourceType" : "DeviceRequest",
  "id" : "negation-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-deviceprohibited"
    ]
  },
  "modifierExtension" : [
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-DeviceRequest.doNotPerform",
      "valueBoolean" : true
    }
  ],
  "status" : "completed",
  "intent" : "original-order",
  "codeCodeableConcept" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/codeOptions",
        "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.117.1.7.1.230"
      }
    ],
    "text" : "Value Set: Venous Foot Pumps (VFP)"
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "authoredOn" : "2016-04-05T09:20:00-04:00",
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "182890002",
          "display" : "Patient requests alternative treatment"
        }
      ]
    }
  ]
}

```
