# DeviceRequest general example - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **DeviceRequest general example**

## Example DeviceRequest: DeviceRequest general example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [QICore DeviceRequest](StructureDefinition-qicore-devicerequest.md)

**status**: Completed

**intent**: Original Order

**code**: [Device/example](Device-example.md)

**subject**: [Patient/example](Patient-example.md)



## Resource Content

```json
{
  "resourceType" : "DeviceRequest",
  "id" : "example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-devicerequest"
    ]
  },
  "status" : "completed",
  "intent" : "original-order",
  "codeReference" : {
    "reference" : "Device/example",
    "display" : "Device/example"
  },
  "subject" : {
    "reference" : "Patient/example",
    "display" : "Patient/example"
  }
}

```
