# Coverage example - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Coverage example**

## Example Coverage: Coverage example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [QICore Coverage](StructureDefinition-qicore-coverage.md)

**identifier**: Member Number/?ngen-9?

**status**: Active

**type**: Other Private Insurance

**policyHolder**: [Jim Chalmers Male, DoB: 1974-12-25 ( Medical record number (use: usual, period: 2001-05-06 --> (ongoing)))](Patient-example.md)

**subscriber**: [Jim Chalmers Male, DoB: 1974-12-25 ( Medical record number (use: usual, period: 2001-05-06 --> (ongoing)))](Patient-example.md)

**beneficiary**: [Jim Chalmers Male, DoB: 1974-12-25 ( Medical record number (use: usual, period: 2001-05-06 --> (ongoing)))](Patient-example.md)

**dependent**: 0

**relationship**: Self

**period**: 2011-05-23 --> 2012-05-23

**payor**: [Organization Health Level Seven International](Organization-example.md)

**order**: 9



## Resource Content

```json
{
  "resourceType" : "Coverage",
  "id" : "example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-coverage"
    ]
  },
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MB"
          }
        ]
      }
    }
  ],
  "status" : "active",
  "type" : {
    "coding" : [
      {
        "system" : "https://nahdo.org/sopt",
        "code" : "59",
        "display" : "Other Private Insurance"
      }
    ]
  },
  "policyHolder" : {
    "reference" : "Patient/example"
  },
  "subscriber" : {
    "reference" : "Patient/example"
  },
  "beneficiary" : {
    "reference" : "Patient/example"
  },
  "dependent" : "0",
  "relationship" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/subscriber-relationship",
        "code" : "self"
      }
    ]
  },
  "period" : {
    "start" : "2011-05-23",
    "end" : "2012-05-23"
  },
  "payor" : [
    {
      "reference" : "Organization/example"
    }
  ],
  "order" : 9
}

```
