# Claim example - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Claim example**

## Example Claim: Claim example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [QICore Claim](StructureDefinition-qicore-claim.md)

**identifier**: `http://example.org/claim`/6612346

**status**: Active

**type**: Vision

**use**: Claim

**patient**: [Jim Chalmers Male, DoB: 1974-12-25 ( Medical record number (use: usual, period: 2001-05-06 --> (ongoing)))](Patient-example.md)

**created**: 2014-08-16

**insurer**: [Organization Health Level Seven International](Organization-example.md)

**provider**: [Practitioner Adam Careful](Practitioner-example.md)

**priority**: Normal

**prescription**: [MedicationRequest: status = active; intent = order; medication[x] = ->Medication alemtuzumab 10 MG/ML [Lemtrada]; authoredOn = 2015-03-25 19:32:52-0500](MedicationRequest-example.md)

### Payees

| | | |
| :--- | :--- | :--- |
| - | **Type** | **Party** |
| * | Provider | [Practitioner Adam Careful](Practitioner-example.md) |

### CareTeams

| | | |
| :--- | :--- | :--- |
| - | **Sequence** | **Provider** |
| * | 1 | [Practitioner Adam Careful](Practitioner-example.md) |

### Diagnoses

| | | |
| :--- | :--- | :--- |
| - | **Sequence** | **Diagnosis[x]** |
| * | 1 | Degenerative myopia, bilateral |

### Insurances

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Sequence** | **Focal** | **Coverage** |
| * | 1 | true | [Coverage: identifier = Member Number; status = active; type = Other Private Insurance; dependent = 0; relationship = Self; period = 2011-05-23 --> 2012-05-23; order = 9](Coverage-example.md) |

> **item****sequence**: 1**careTeamSequence**: 1**productOrService**:glasses**serviced**: 2014-08-16

### UnitPrices

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 214.00 | United States dollar |

> **detail****sequence**: 1**productOrService**:frame

### UnitPrices

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 100.00 | United States dollar |

### Nets

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 100.00 | United States dollar |


> **detail****sequence**: 2**productOrService**:lens**quantity**: 2

### UnitPrices

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 50.00 | United States dollar |

### Nets

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 100.00 | United States dollar |


> **detail****sequence**: 3**productOrService**:fst

### UnitPrices

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 200.00 | United States dollar |

**factor**: 0.07

### Nets

| | | |
| :--- | :--- | :--- |
| - | **Value** | **Currency** |
| * | 14.00 | United States dollar |





## Resource Content

```json
{
  "resourceType" : "Claim",
  "id" : "example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-claim"
    ]
  },
  "identifier" : [
    {
      "system" : "http://example.org/claim",
      "value" : "6612346"
    }
  ],
  "status" : "active",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/claim-type",
        "code" : "vision"
      }
    ]
  },
  "use" : "claim",
  "patient" : {
    "reference" : "Patient/example"
  },
  "created" : "2014-08-16",
  "insurer" : {
    "reference" : "Organization/example"
  },
  "provider" : {
    "reference" : "Practitioner/example"
  },
  "priority" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/processpriority",
        "code" : "normal"
      }
    ]
  },
  "prescription" : {
    "reference" : "MedicationRequest/example"
  },
  "payee" : {
    "type" : {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/payeetype",
          "code" : "provider"
        }
      ]
    },
    "party" : {
      "reference" : "Practitioner/example"
    }
  },
  "careTeam" : [
    {
      "sequence" : 1,
      "provider" : {
        "reference" : "Practitioner/example"
      }
    }
  ],
  "diagnosis" : [
    {
      "sequence" : 1,
      "diagnosisCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/sid/icd-10-cm",
            "code" : "H44.23"
          }
        ]
      }
    }
  ],
  "insurance" : [
    {
      "sequence" : 1,
      "focal" : true,
      "coverage" : {
        "reference" : "Coverage/example"
      }
    }
  ],
  "item" : [
    {
      "sequence" : 1,
      "careTeamSequence" : [1],
      "productOrService" : {
        "coding" : [
          {
            "system" : "http://example.org/fhir/CodeSystem/ex-visionservice",
            "code" : "glasses"
          }
        ]
      },
      "servicedDate" : "2014-08-16",
      "unitPrice" : {
        "value" : 214.00,
        "currency" : "USD"
      },
      "detail" : [
        {
          "sequence" : 1,
          "productOrService" : {
            "coding" : [
              {
                "system" : "http://example.org/fhir/CodeSystem/ex-visionservice",
                "code" : "frame"
              }
            ]
          },
          "unitPrice" : {
            "value" : 100.00,
            "currency" : "USD"
          },
          "net" : {
            "value" : 100.00,
            "currency" : "USD"
          }
        },
        {
          "sequence" : 2,
          "productOrService" : {
            "coding" : [
              {
                "system" : "http://example.org/fhir/CodeSystem/ex-visionservice",
                "code" : "lens"
              }
            ]
          },
          "quantity" : {
            "value" : 2
          },
          "unitPrice" : {
            "value" : 50.00,
            "currency" : "USD"
          },
          "net" : {
            "value" : 100.00,
            "currency" : "USD"
          }
        },
        {
          "sequence" : 3,
          "productOrService" : {
            "coding" : [
              {
                "system" : "http://example.org/fhir/CodeSystem/ex-visionservice",
                "code" : "fst"
              }
            ]
          },
          "unitPrice" : {
            "value" : 200.00,
            "currency" : "USD"
          },
          "factor" : 0.07,
          "net" : {
            "value" : 14.00,
            "currency" : "USD"
          }
        }
      ]
    }
  ]
}

```
