# CarePlan example - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CarePlan example**

## Example CarePlan: CarePlan example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

**instantiatesCanonical**: `http://example.org/guides/who/anc-cds/PlanDefinition/anc-contact-schedule`

**status**: Active

**intent**: Plan

**category**: Assessment and Plan of Treatment

**subject**: Eve Everywoman

**period**: 2019-05-24 --> 2020-02-24

**careTeam**: [CareTeam: status = active](CareTeam-example.md)

**addresses**: pregnancy

**goal**: pregnancy goal

> **activity****outcomeReference**: First contact, occurred at about 12 weeks based on gestational age from LMP of 2019-03-01

### Details

| | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Kind** | **InstantiatesCanonical** | **Code** | **Status** | **Performer** | **Description** |
| * | ServiceRequest | `http://example.org/guides/who/anc-cds/PlanDefinition/anc-contact` | Antenatal care | In Progress | Mabel Midwife | First antenatal care contact |


> **activity**

### Details

| | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Kind** | **InstantiatesCanonical** | **Code** | **Status** | **Scheduled[x]** | **Performer** | **Description** |
| * | ServiceRequest | `http://example.org/guides/who/anc-cds/PlanDefinition/anc-contact` | Antenatal care | Scheduled | 2019-07-26 --> (ongoing) | Mabel Midwife | Second contact to occur at 20 weeks of gestational age |


> **activity**

### Details

| | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Kind** | **InstantiatesCanonical** | **Code** | **Status** | **Scheduled[x]** | **Performer** | **Description** |
| * | ServiceRequest | `http://example.org/guides/who/anc-cds/PlanDefinition/anc-contact` | Antenatal care | Not Started | 2019-09-06 --> (ongoing) | Mabel Midwife | Third contact to occur at 26 weeks of gestational age |


> **activity**

### Details

| | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Kind** | **InstantiatesCanonical** | **Code** | **Status** | **Scheduled[x]** | **Performer** | **Description** |
| * | ServiceRequest | `http://example.org/guides/who/anc-cds/PlanDefinition/anc-contact` | Antenatal care | Not Started | 2019-10-04 --> (ongoing) | Mabel Midwife | Fourth contact to occur at 30 weeks of gestational age |


> **activity**

### Details

| | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Kind** | **InstantiatesCanonical** | **Code** | **Status** | **Scheduled[x]** | **Performer** | **Description** |
| * | ServiceRequest | `http://example.org/guides/who/anc-cds/PlanDefinition/anc-contact` | Antenatal care | Not Started | 2019-11-01 --> (ongoing) | Mabel Midwife | Fifth contact to occur at 34 weeks of gestational age |


> **activity**

### Details

| | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Kind** | **InstantiatesCanonical** | **Code** | **Status** | **Scheduled[x]** | **Performer** | **Description** |
| * | ServiceRequest | `http://example.org/guides/who/anc-cds/PlanDefinition/anc-contact` | Antenatal care | Not Started | 2019-11-15 --> (ongoing) | Mabel Midwife | Sixth contact to occur at 36 weeks of gestational age |


> **activity**

### Details

| | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Kind** | **InstantiatesCanonical** | **Code** | **Status** | **Scheduled[x]** | **Performer** | **Description** |
| * | ServiceRequest | `http://example.org/guides/who/anc-cds/PlanDefinition/anc-contact` | Antenatal care | Not Started | 2019-11-29 --> (ongoing) | Mabel Midwife | Seventh contact to occur at 38 weeks of gestational age |


> **activity**

### Details

| | | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Kind** | **InstantiatesCanonical** | **Code** | **Status** | **Scheduled[x]** | **Performer** | **Description** |
| * | ServiceRequest | `http://example.org/guides/who/anc-cds/PlanDefinition/anc-contact` | Antenatal care | Not Started | 2019-12-13 --> (ongoing) | Mabel Midwife | Eighth contact to occur at 40 weeks of gestational age |


> **activity**

### Details

| | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Kind** | **Code** | **Status** | **Scheduled[x]** | **Performer** | **Description** |
| * | ServiceRequest | Delivery procedure | Not Started | 2019-12-13 --> 2019-12-27 | Mabel Midwife | Delivery |




## Resource Content

```json
{
  "resourceType" : "CarePlan",
  "id" : "example",
  "instantiatesCanonical" : [
    "http://example.org/guides/who/anc-cds/PlanDefinition/anc-contact-schedule"
  ],
  "status" : "active",
  "intent" : "plan",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/core/CodeSystem/careplan-category",
          "code" : "assess-plan",
          "display" : "Assessment and Plan of Treatment"
        }
      ]
    }
  ],
  "subject" : {
    "display" : "Eve Everywoman"
  },
  "period" : {
    "start" : "2019-05-24",
    "end" : "2020-02-24"
  },
  "careTeam" : [
    {
      "reference" : "CareTeam/example"
    }
  ],
  "addresses" : [
    {
      "display" : "pregnancy"
    }
  ],
  "goal" : [
    {
      "display" : "pregnancy goal"
    }
  ],
  "activity" : [
    {
      "outcomeReference" : [
        {
          "display" : "First contact, occurred at about 12 weeks based on gestational age from LMP of 2019-03-01"
        }
      ],
      "detail" : {
        "kind" : "ServiceRequest",
        "instantiatesCanonical" : [
          "http://example.org/guides/who/anc-cds/PlanDefinition/anc-contact"
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "424525001",
              "display" : "Antenatal care (regime/therapy)"
            }
          ],
          "text" : "Antenatal care"
        },
        "status" : "in-progress",
        "performer" : [
          {
            "display" : "Mabel Midwife"
          }
        ],
        "description" : "First antenatal care contact"
      }
    },
    {
      "detail" : {
        "kind" : "ServiceRequest",
        "instantiatesCanonical" : [
          "http://example.org/guides/who/anc-cds/PlanDefinition/anc-contact"
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "424525001",
              "display" : "Antenatal care (regime/therapy)"
            }
          ],
          "text" : "Antenatal care"
        },
        "status" : "scheduled",
        "scheduledPeriod" : {
          "start" : "2019-07-26"
        },
        "performer" : [
          {
            "display" : "Mabel Midwife"
          }
        ],
        "description" : "Second contact to occur at 20 weeks of gestational age"
      }
    },
    {
      "detail" : {
        "kind" : "ServiceRequest",
        "instantiatesCanonical" : [
          "http://example.org/guides/who/anc-cds/PlanDefinition/anc-contact"
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "424525001",
              "display" : "Antenatal care (regime/therapy)"
            }
          ],
          "text" : "Antenatal care"
        },
        "status" : "not-started",
        "scheduledPeriod" : {
          "start" : "2019-09-06"
        },
        "performer" : [
          {
            "display" : "Mabel Midwife"
          }
        ],
        "description" : "Third contact to occur at 26 weeks of gestational age"
      }
    },
    {
      "detail" : {
        "kind" : "ServiceRequest",
        "instantiatesCanonical" : [
          "http://example.org/guides/who/anc-cds/PlanDefinition/anc-contact"
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "424525001",
              "display" : "Antenatal care (regime/therapy)"
            }
          ],
          "text" : "Antenatal care"
        },
        "status" : "not-started",
        "scheduledPeriod" : {
          "start" : "2019-10-04"
        },
        "performer" : [
          {
            "display" : "Mabel Midwife"
          }
        ],
        "description" : "Fourth contact to occur at 30 weeks of gestational age"
      }
    },
    {
      "detail" : {
        "kind" : "ServiceRequest",
        "instantiatesCanonical" : [
          "http://example.org/guides/who/anc-cds/PlanDefinition/anc-contact"
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "424525001",
              "display" : "Antenatal care (regime/therapy)"
            }
          ],
          "text" : "Antenatal care"
        },
        "status" : "not-started",
        "scheduledPeriod" : {
          "start" : "2019-11-01"
        },
        "performer" : [
          {
            "display" : "Mabel Midwife"
          }
        ],
        "description" : "Fifth contact to occur at 34 weeks of gestational age"
      }
    },
    {
      "detail" : {
        "kind" : "ServiceRequest",
        "instantiatesCanonical" : [
          "http://example.org/guides/who/anc-cds/PlanDefinition/anc-contact"
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "424525001",
              "display" : "Antenatal care (regime/therapy)"
            }
          ],
          "text" : "Antenatal care"
        },
        "status" : "not-started",
        "scheduledPeriod" : {
          "start" : "2019-11-15"
        },
        "performer" : [
          {
            "display" : "Mabel Midwife"
          }
        ],
        "description" : "Sixth contact to occur at 36 weeks of gestational age"
      }
    },
    {
      "detail" : {
        "kind" : "ServiceRequest",
        "instantiatesCanonical" : [
          "http://example.org/guides/who/anc-cds/PlanDefinition/anc-contact"
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "424525001",
              "display" : "Antenatal care (regime/therapy)"
            }
          ],
          "text" : "Antenatal care"
        },
        "status" : "not-started",
        "scheduledPeriod" : {
          "start" : "2019-11-29"
        },
        "performer" : [
          {
            "display" : "Mabel Midwife"
          }
        ],
        "description" : "Seventh contact to occur at 38 weeks of gestational age"
      }
    },
    {
      "detail" : {
        "kind" : "ServiceRequest",
        "instantiatesCanonical" : [
          "http://example.org/guides/who/anc-cds/PlanDefinition/anc-contact"
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "424525001",
              "display" : "Antenatal care (regime/therapy)"
            }
          ],
          "text" : "Antenatal care"
        },
        "status" : "not-started",
        "scheduledPeriod" : {
          "start" : "2019-12-13"
        },
        "performer" : [
          {
            "display" : "Mabel Midwife"
          }
        ],
        "description" : "Eighth contact to occur at 40 weeks of gestational age"
      }
    },
    {
      "detail" : {
        "kind" : "ServiceRequest",
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "236973005",
              "display" : "Delivery procedure (procedure)"
            }
          ],
          "text" : "Delivery procedure"
        },
        "status" : "not-started",
        "scheduledPeriod" : {
          "start" : "2019-12-13",
          "end" : "2019-12-27"
        },
        "performer" : [
          {
            "display" : "Mabel Midwife"
          }
        ],
        "description" : "Delivery"
      }
    }
  ]
}

```
