# Quality Improvement Core (QI-Core) Implementation Guide - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* **Quality Improvement Core (QI-Core) Implementation Guide**

## Quality Improvement Core (QI-Core) Implementation Guide

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/qicore/ImplementationGuide/hl7.fhir.us.qicore | *Version*:7.0.2 | |
| *IG Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 4 | *Computable Name*:QICore |

> This STU 7 update to the QI-Core profiles aligns with US-Core STU v7. For a complete list of changes in this version, please refer to the version history.

### Summary

The QI-Core Implementation Guide defines a set of FHIR profiles with extensions and bindings needed to create interoperable, quality-focused applications. The profiles in this implementation guide derive from and extend the base FHIR resources and US Core profiles to provide a common foundation for building, sharing, and evaluating knowledge artifacts across quality improvement efforts in the US Realm.

As an HL7 FHIR Implementation Guide, changes to this specification are managed by the sponsoring workgroup, [Clinical Quality Information](http://www.hl7.org/Special/committees/cqi/index.cfm), and incorporated as part of the standard balloting process. The current roadmap follows closely behind the base FHIR roadmap, and the US Core Implementation Guide.

### Contents

This guide is divided into pages which are listed at the top of each page in the menu bar:

* **[Home](index.md)**: The home page provides summary and background information
* **Profiles** 
* **[QI-Core Profiles](profiles.md)**: The profiles page provides a complete listing of all the profiles defined in or used by QI-Core
* **[QI Elements](qi-elements.md)**: The QI Elements page provides a complete listing of all the QI Elements in each profile used by QI-Core
 
* **[QI-Core Negation](negation.md)**: The negations page describes QI-Core Negation
* **[Patterns](patterns.md)**: The patterns page describes patterns of usage for QI-Core applications
* **[Model Info](modelinfo.md)**: The model info page provides the QI-Core model information to support implementation
* **[Extensions](extensions.md)**: The extensions page lists all the extensions defined as part of QI-Core
* **[Terminology](terminology.md)**: The terminology page lists all terminology defined as part of QI-Core
* **[Examples](examples.md)**: The examples page provides an index of all the examples defined as part of QI-Core
* **[Downloads](downloads.md)**: Downloads for definitions, examples, as well as the entire IG
* **[QDM-to-QI-Core Mapping](qdm-to-qicore.md)**: This page provides a detailed description of mapping from QDM to QI-Core

### Background

This Implementation Guide originated as a US Realm Specification with support from the Clinical Quality Framework (CQF) initiative [(that concluded in 2017)](https://oncprojectracking.healthit.gov/wiki/display/TechLabSC/CQF+Home), which was a public-private partnership sponsored by the Centers for Medicare & Medicaid Services (CMS) and the U.S. Office of the National Coordinator (ONC) to harmonize standards for clinical decision support and electronic clinical quality measurement. The [Clinical Quality Framework](https://confluence.hl7.org/display/CQIWC/Clinical+Quality+Framework) effort transitioned to HL7's Clinical Quality Information (CQI) and Clinical Decision Support (CDS) Work Groups in 2016. The HL7 CQI Work Group maintains this Implementation Guide, co-sponsored by the Clinical Decision Support (CDS) HL7 Work Group to inform electronic clinical quality improvement (i.e., measurement and decision support). This Quality Improvement Core (QI-Core) Implementation Guide is intended to be usable for multiple use cases across domains, and much of the content is likely to be usable outside the US Realm.

Understanding QI-Core and its use in quality applications requires an understanding of the role of common reference models. Electronic Health Records (EHRs) are stored in many different local formats. Exchanging data between EHRs requires mapping between local data formats. It is well understood that standards can reduce the number of data maps each data provider must create. In a similar manner, to share quality measures and clinical decision support artifacts, the measures and artifacts must refer to data in a standardized way.

In the US Realm, the common reference model for electronic clinical quality measures (eCQMs) is the [Quality Data Model (QDM)](https://ecqi.healthit.gov/qdm). For clinical decision support, a common reference model is the [HL7 Virtual Medical Record for Clinical Decision Support (vMR)](http://www.hl7.org/implement/standards/product_brief.cfm?product_id=342). Decision support and quality measures are closely related, and can be viewed as "two sides of the same coin". Specifically, decision support provides guidance for clinical best practices, and quality measures assess whether clinical best practices have been followed. It therefore makes intuitive sense to use the same common reference model for both types of applications.

This initiative began in 2013 with the creation of the [Quality Improvement Domain Analysis Model (QIDAM)](http://www.hl7.org/implement/standards/product_brief.cfm?product_id=378), which drew on the vMR and QDM as sources of requirements. The result, Quality Improvement Core (QI-Core) profiles consist of objects, attributes, and relationships as a common model for quality and interoperability that leverages US Core and other FHIR-related efforts and Clinical Document Architecture (CDA) on FHIR. The QI-Core versions have evolved with FHIR-specific tooling to include views showing differential from base FHIR resources or US Core profiles including US Core defined Must Support elements and Key Element Table specifying elements spcifically significanty for each respective QI-Core profile.

### Relevance of QI-Core Profiles to Authors

QI-Core classes and attributes are the most relevant to the broader QI community, lying in the intersection of clinical quality measures (CQM) and CDS, thus providing a common foundation for reusability. QI-Core derives content from US Core profiles and extensions to the extent possible. The CQI Workgroup expects that QI-Core will continue to grow in concert with US Core by incorporating needed extensions with broad applicability. To the extent possible, CQM and CDS authors should incorporate published domain-specific profiles to express content as much as possible rather than duplicating such concepts in QI-Core (e.g., minimum Common Oncology Data Elements (mCode)). The CQI and CDS Work Groups coordinate with HL7 Work Groups that manage specific FHIR resources to align definitions and value sets including concepts required for CDS and retrospective CQM use cases. Additional classes and attributes needed for specific quality applications can be added through FHIR's extension mechanism. This QI-Core STU 7.0 uses FHIR extensions promoted from the previous Clinical Quality Framework (CQF) extensions to improve shareablility. QI-Core will evolve to include more of the extensional content when the community identifies a common need, and the additional content has been validated.

QI-Core profile authoring provides a relatively facile method for creating CQM and CDS artifacts with CQL that expand to full FHIR representation for implementation through CQL-to-ELM conversion.

### Scope

The QI-Core FHIR Implementation Guide provides requirements and guidance for using FHIR in quality measurement and decision support. The profiles in this implementation guide will be used to meet QI-Core project objectives of:

* Encouraging consistent access and use of data for clinical quality applications across organizations and between healthcare systems,
* Providing guidance for consistent use of vocabularies and value sets, and
* Standardizing the requirements for data servers and data consumers (clients) that exchange quality-related clinical data needed for calculation of quality measures and decision support.

This IG is focused on representation of clinical data and is limited in breadth to the profiles currently included in QI-Core. Not all FHIR resources are profiled, especially those that do not have clinical value in the context of quality improvement, or do not map to QIDAM. Additional extensions may be added to the current set of profiles, and additional profiles may be added later. QI-Core represents a subset of the semantics covered in QIDAM, vMR, and QDM. The parts of the latter specifications that are not in the QI-Core profiles could be handled with additional profiles, if the DSTU period reveals the need for such additions. Keeping the QI-Core profiles in line with FHIR and FHIR's "80%" rule is one way to make sure that the quality artifacts produced from QI-Core are computable, based on commonly collected clinical data. The current set of profiles will evolve to reflect changes to the underlying FHIR resources.

The following topics are explicitly out of scope for this implementation guide:

* Representing knowledge artifacts, analogous to Health Quality Measures Format (HQMF) or Clinical Decision Support (CDS) Knowledge Artifact Specification (KAS)
* Representation of patient-data documents, analogous to Quality Reporting Document Architecture (QRDA) Cat I
* Representation of documents containing results of quality measures, analogous to QRDA Cat III
* Specifying implementation architectures and platforms for QI-Core
* User extensions to the QI-Core profiles

Some of the above topics are under active investigation and will be topics of future standards efforts. Specifically, the FHIR [Clinical Reasoning](http://hl7.org/fhir/R4/clinicalreasoning-module.html) module provides resources and guidance representing and evaluating quality improvement artifacts within FHIR.

Consistent with changes in QI-Core STU 6.0, this STU 7.0 includes simplification to reduce the number of must support elements and further constraints on US Core content. The approach in previous QI-Core versions listed as [key elements](https://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#model-views) all metadata that might be relevant to clinical quality measurement and clinical decision support use cases. QI-Core STU 7.0 advances the concept that measurement and decision support real-world use cases should drive content for the IG. Thus, the profile key element tables are more concise, including only those elements necessary due to the base resource or relevant US Core profile and those elements used by tested and implemented use cases.

### Privacy, Security, and Consent

Quality applications may make use of patient-specific information. For this reason, all transactions must be appropriately secured, limiting access to authorized individuals and protecting data while in transit (as laid out in the [FHIR Implementer's Safety Check List](http://hl7.org/fhir/R4/safety.html#7.10.1)). These considerations relate to any FHIR implementation, including authentication, authorization, access control consistent with patient consent, transaction logging, and following best practices. QI-Core security conformance rules are as follows:

* Systems **SHOULD** use OAuth or an equivalent mechanism to provide necessary authentication (user or system-level).
* Systems **SHOULD** use either IHE's ATNA standard for audit logging or an equivalent using the AuditEvent resource.

The server (data provider) is responsible for ensuring that any necessary consent records exist and are reviewed prior to each exchange of patient-identifiable healthcare information. This verification should be logged in the same manner as other transactions, as discussed above under General Security Considerations.

### Provenance

QI-Core addresses provenance at a data element level. We address data element provenance as defined by each respective FHIR resource. Each FHIR resource has its own way to address provenance (author, performer, author or issued date, occurrence date, etc.). Therefore, we assure QI-Core can handle provenance based on the resource modeling. The US domain Quality Data Model handles provenance in the same way and the mapping tables from QDM attributes to QI-Core/FHIR resource elements occurs at that level. There are some instances for which QI-Core creates extensions to ensure it captures the resource-specific data provenance. Decisions to create such extensions are intentionally consistent with each resource owner's future FHIR version direction and with discussions with the HL7 Work Groups responsible for the respective resource. QI-Core closely follows US Core and will address future US Core versions that enhance its approach to provenance.

### Relationship to Other Initiatives

QI-Core has been harmonized with other FHIR-based initiatives, particularly, the [Data Access Framework (DAF)](https://oncprojectracking.healthit.gov/wiki/display/TechLabSC/DAF+Home). [US Core](http://hl7.org/fhir/us/core/STU7) is a US Realm Implementation Guide, developed under the DAF initiative, that maps ONC Common Clinical Data Set elements to FHIR resources. The data elements in US Core are also in QI-Core, and whenever possible, profiles defined in QI-Core are derived from the profiles in US Core. As a result, conforming to US Core automatically satisfies a significant subset of the conformance requirements of QI-Core. QI-Core conformance involves supporting certain additional data elements not required by US Core, because they are needed for quality measures or clinical decision support.

Because QI-Core profiles derive from US Core profiles where possible, wherever US Core defines a binding, the QI-Core profiles inherit that binding. QI-Core may specify additional constraints, such as requiring a binding that is only preferred in the US Core base profile, but in general, the QI-Core profiles use the same bindings as US Core. This means that QI-Core is currently a US Realm specification. To support applications outside the US Realm, additional binding analysis and effort would be required.

QI-Core (Quality Improvement Core) is based on US Core because it helps improve healthcare quality using common standards that make it easier to share and understand health information. QI-Core builds on US Core to ensure that information about healthcare quality can be shared smoothly between different organizations, allowing better tracking and reporting. Many programs that improve quality are linked to government regulations. US Core addresses [United States Core Data for Interoperability](https://www.hl7.org/fhir/us/core/uscdi.html#uscdi). US Core updates with annual versions provide detail about sharing data defined in USCDI. Assistant Secretary for Technology Policy/Office of the National Coordinator for Health IT (ASTP/ONC) also publishes U.S. Core Data for Interoperability Plus [USCDI+](https://uscdiplus.healthit.gov/uscdiplus), to address data needs for specific "domains". These domains include: Maternal Health, Public Health, Quality, Cancer, and Behavioral Health. ASTP published a [USCDI+Quality Draft v1](https://uscdiplus.healthit.gov/uscdiplus?id=uscdi_record&table=x_g_sshh_uscdi_domain&sys_id=7ddf78228745b95098e5edb90cbb3525&view=sp) in August 2024; a final publication is pending at the time of this QI-Core publication. QI-Core supports the data elements proposed in the USCDI+Quality Draft v1 and further guidance should be available at the time of a future publication of USCDI+Quality.

This IG contains only one QI-Core-specific extension "QI-Core Key Element Extension" to enable entry of (QI) references to specific profile elements. Otherwise, this IG uses only FHIR or US Core extensions. Other initiatives that the QI-Core effort is aligning with include the [Clinical Information Modeling Initiative (CIMI)](https://confluence.hl7.org/display/CIMI/Mission%2C+Charter%2C+Work+Products%2C+HL7+Working+Group+Relationships) and [Graphite Health](https://www.graphitehealth.io/).

In addition, the QI-Core effort **continues** to update the mapping from QDM to QI-Core such that a CQL-based artifact written with QDM as the model would be executable against a QI-Core compliant FHIR endpoint.

### Naming Conventions

QI-Core profiles are indicated by the prefix "QICore". For example, the QI-Core profile of Patient is named QICorePatient.

### Extensions and Mappings

QI-Core adds a variety of [extensions](extensions.md) to core FHIR classes. These extensions derive from two primary sources: the Quality Improvement Domain Analysis Model (QIDAM), and the Quality Data Model (QDM). Profile pages contain definitions of extensions and mappings to QDM as an aid for current users of QDM.

### MustSupport Flag

QI-Core inherits Must Support references from US Core and so the [requirements on "MustSupport" defined in US Core](http://hl7.org/fhir/us/core/STU7/must-support.html) must be respected; QI-Core does not add any Must Support elements.

QI-Core flags elements that the quality improvement community has identified as significant to express the full intent of measures and CDS artifacts or those that are used in established measures or CDS support services. Implementers are only required to support these additional elements when they are used in the measures or CDS artifacts implemented on or otherwise supported by the system. Since not all artifacts use each of these additional elements, QI-Core does not use the “MustSupport” flag to indicate these elements. Instead, “(QI)” is prepended to the element’s short description found in the Description & Constraints column of the Key Elements Table, and the computable [QI-Core Key Element Extension](StructureDefinition-qicore-keyelement.md) is added to each element definition. This approach allows IGs that extend QI-Core, such as those representing data requirements for specific measures or supporting CDS, to avoid inheriting requirements for those QI-Core-flagged elements that they do not use. This is inspired by the way that [US Core communicates USCDI requirements](http://hl7.org/fhir/us/core/STU7/must-support.html#uscdi-requirements) and allows IGs that extend QI-Core, such as those representing data requirements for specific measures or supporting CDS, to avoid inheriting requirements for those QI-Core-flagged elements that they do not use. Software should not be expected to test conformance to all of QI-Core. Rather, the systems should be conformant for all data elements required by a specific set of measures or CDS artifacts constructed with QI-Core elements needed to report the specific measure set criteria. QI-Core provides consistency and standardization for measure developers and CDS artifact developers to express the data elements they need to address their intended outcomes.

In addition to (QI) Key Element extensions, each QI-Core profile identifies a primary code path. The primary code path provides the default filtering for a CQL expression. See [using-modelinfo section](https://hl7.org/fhir/uv/cql/using-modelinfo.html#modelinfo-settings.html) in Using CQL with FHIR.

Quality improvement artifacts communicate the elements they reference using the DataRequirement structure in FHIR. This structure allows the base resource type and profile to be specified, as well as a MustSupport element that indicates which elements of the resource and profile are reference by the logic. Implementers can use this information directly from the effective data requirements to determine which elements must be provided to achieve a successful evaluation of the artifact. In addition, repositories and publishers may make use of this information to define artifact-specific profiles using the effective data requirements provided by the artifact.

The primary code path provides the default filtering for a CQL expression. See [using-modelinfo section](https://hl7.org/fhir/uv/cql/using-modelinfo.html#modelinfo-settings.html) in Using CQL with FHIR.

### Modifying Attributes

Within FHIR resources, some elements are considered [Modifying Elements](http://hl7.org/fhir/R4/conformance-rules.html#isModifier), indicating that the value of that element may change the interpretation of the resource. Examples of modifying elements include status (in many resources), negations (e.g. Immunization.wasNotGiven), and certainty qualifications (e.g. Observation.reliability). Decision support and quality implementations MUST always check the values of modifying elements. For example, in processing an Immunization resource, the application must inspect the "wasNotGiven" element to determine whether the immunization was given or was not given to the patient. For this reason, applications that make use of resources must make sure they handle modifier elements appropriately.

### Identifying Occupational Data for Health

The profile inherited from US Core Observation Occupation Profile is based upon the core FHIR Observation Resource and implements the US Core Data for Interoperability (USCDI) Occupation and Occupation Industry requirements. That profile's Example Usage Scenarios include:

* Query for a patient’s work history
* [Record or update](https://www.hl7.org/fhir/us/core/future-of-US-core.html#future-candidate-requirements-under-consideration) past or present jobs belonging to a patient

To obtain information regarding other Occupational Data for Health (ODH)-specific concepts as indicated in the ODH version STU 1.3 [Artifacts Summary](https://hl7.org/fhir/us/odh/STU1.3/artifacts.html) use the QI-Core SimpleObservation profile Observation.code element to reference the exact LOINC code referenced by the specific ODH element of interest (e.g., 74165-2 for History of employment status NIOSH; 11341-5 for History of Occupation, 87510-4 Date of Retirement, etc.).

### Negation in QI-Core

QI-Core’s concept of negation follows the informative publication established by HL7.[1](#fn:1) QI-Core constrains these concepts in the following way:

1. Absence of dataThe measure or CDS artifact uses CQL to determine that an expected record artifact does not exist
1. Documented absence of data with a valid reasonThe measure or CDS artifact uses specifically designed QI-Core profiles to indicate that an activity intentionally did not occur for a valid reason.

When there is a need to document evidence that an expected activity was not done due to patient intent and/or specific criteria, systems should use one of the ten QI-Core specific **negation** **rationale** patterns that align with existing profiles representing the expected actions. [**QI-Core Negation**](negation.md) provides detailed descriptions and guidance.

### Terminology Bindings

Uniformity in vocabularies and value sets enhances the interoperability of knowledge artifacts, but also forces data owners to translate local data into the required vocabulary. As a US Realm product, QI-Core requires value sets and vocabularies referenced in the ONC Common Clinical Data Set (CCDS) and the US Core Data for Interoperability. Because QI-Core is expected to be applied outside the US Realm, and in clinical settings where local terminologies exist, US Realm bindings could be accompanied by alternative codes as translation codes in the QI-Core profiles. In the case that the US Core Data for Interoperability adopts QI-Core and CQL, policy should be created to mandate the preferred bindings given in the standard.

Note that quality improvement artifact authors should pay close attention to binding parameters specified in the profiles to determine whether the value set defined in the binding is exemplar or should be constrained to a specific value set when used. For example, the code element of the MedicationRequest profile is bound to the complete value set for the RxNorm code system, indicating that all MedicationRequest instances **SHALL** use codes from the RxNorm code system, but within any given artifact, instances will typically use a restricted value set.

QI-Core aligns with US Core to address terminology bindings. The FHIR rules for extensible bindings state that all conceptual overlaps, including free text, should be mapped to the coded values in the bindings. QI-Core (similar to US Core) adopts the [additional binding](http://hl7.org/fhir/R5/terminologies.html#binding) concept from FHIR R5 for more flexibility in exchanging legacy and text-only data. See [QI-Core ServiceProhibited profile](StructureDefinition-qicore-serviceprohibited.md).

### Resource References and "Any"

FHIR resources frequently contain references (pointers) to other FHIR resources. For example, Encounter.patient is a reference to a Patient resource. In QI-Core, most references are constrained to QICore-profiled resources. For example, QICore-Encounter.patient must point to a Patient resource that conforms to the QICore-Patient profile. Consequently, any extensions or bindings expected to exist in QICore-Patient are also present in the resource pointed to by Encounter.patient. References to QI-Core extensions accessed through references are guaranteed to be valid. References to resources that do not currently have QI-Core profiles are not constrained, and as such, only the core FHIR properties and bindings are guaranteed to exist.

A particular problem occurs when a resource reference permits any type of resource, such as Encounter.indication. When dealing with "Any" references, the current method of specifying profiles does not allow the profile author to specify something to the effect of "a QI-Core resource when there is one, and a FHIR core resource if there isn't." In QI-Core, the resources in "Any" references SHALL conform to QI-Core profiles if the base resource has been profiled.

### Summary of Conformance Requirements

Conformance to this QI-Core Implementation Guide requires the following (in addition to adherence to core FHIR requirements):

* Implementations **SHALL** support all profile types in the QI-Core set (listed in the [profiles](profiles.md) page) for resources they exchange
* This IG does not define the capability statements as it does not address accessing patient level data directly via API calls; however, server implementations **SHALL** declare their support of the QI-Core profiles in a FHIR CapabilityStatement.
* Conformant servers will at minimum support FHIR's read and search operations
* Servers **SHALL** supply the MustSupport data elements whenever that data is available
* Quality improvement applications **SHALL** recognize and process all MustSupport elements in QI-Core
* Modifying attributes **SHALL** be treated as MustSupport, even if not explicitly declared
* The resources in "Any" references **SHALL** conform to QI-Core profiles if the base resource has a QI-Core profile
* Applications **SHALL NOT** process resource instances that include unknown modifying attributes
* Applications **SHOULD** use the preferred value sets
* In the US Realm, applications **SHALL** be simultaneously compliant with QI-Core profiles and US Core profiles. As such, the more restrictive bindings between US Core and QI-Core **SHALL** be adhered to. For example, all value sets that are required in US Core **SHALL** be required by QI-Core, regardless of the binding strength in QI-Core.

### Author Information

| | | |
| :--- | :--- | :--- |
| Abdullah Rafiqi | ICF | Editor |
| Anne Smith | NCQA | Contributor |
| Ben Hamlin | IPRO | Contributor |
| Bryn Rhodes | Smile Digital Health | Editor |
| Chris Moesel | The MITRE Corporation | Contributor |
| Claude Nanjo | University of Utah | Originator |
| Claudia Hall |   | Contributor |
| Floyd Eisenberg | iParsimony, LLC | Primary |
| James Bradley | The MITRE Corporation | Contributor |
| Jason Walonoski | The MITRE Corporation | Contributor |
| Jen Seeman | ICF | Editor |
| Juliet Rubini | ICF | Contributor |
| Karl Naden | The MITRE Corporation | Contributor |
| Linda Michaelsen | Optum | Contributor |
| Mark Kramer | The MITRE Corporation | Originator |
| Jason Mathews | The MITRE Corporation | Originator |
| Lisa Anderson | Mathematica | Contributor |
| Lloyd McKenzie | Gevity Consulting | Contributor |
| Marc Hadley | The MITRE Corporation | Contributor |
| Paul Denning | The MITRE Corporation | Contributor |
| Peter Muir | ICF, Inc. | Contributor |
| Raman Srinivasan | IBM Watson Health | Contributor |
| Robert Samples |   | Contributor |
| Sam Sayer | The MITRE Corporation | Contributor |
| Stan Rankins | Telligen | Contributor |
| Yan Heras | Optimum eHealth, LLC | Contributor |
| Yanyan Hu | The Joint Commission | Contributor |

1. For further information about representing negatives in HL7 standards, see: HL7 Cross Paradigm Specification: Representing Negatives, Release I. April 2022. Available at:[http://www.hl7.org/implement/standards/product_brief.cfm?product_id=592](http://www.hl7.org/implement/standards/product_brief.cfm?product_id=592). Retrieved 31 December 2023. [↩](#fnref:1)



## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "hl7.fhir.us.qicore",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfoSettings",
      "valueReference" : {
        "reference" : "Parameters/qicore-modelinfosettings"
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/hl7.fhir.us.qicore",
  "version" : "7.0.2",
  "name" : "QICore",
  "title" : "QI-Core Implementation Guide",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-10T06:13:53+00:00",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "The QICore Implementation Guide defines a set of FHIR profiles with extensions and bindings needed to create interoperable, quality-focused applications. The profiles in this implementation guide derive from and extend the [US Core](http://hl7.org/fhir/us/core) profiles to provide a common foundation for building, sharing, and evaluating knowledge artifacts across quality improvement efforts in the US Realm.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "packageId" : "hl7.fhir.us.qicore",
  "license" : "CC0-1.0",
  "fhirVersion" : ["4.0.1"],
  "dependsOn" : [
    {
      "id" : "uscore",
      "uri" : "http://hl7.org/fhir/us/core/ImplementationGuide/hl7.fhir.us.core",
      "packageId" : "hl7.fhir.us.core",
      "version" : "7.0.0"
    },
    {
      "id" : "dicom",
      "uri" : "http://fhir.org/packages/fhir.dicom/ImplementationGuide/fhir.dicom",
      "packageId" : "fhir.dicom",
      "version" : "2025.2.20250411"
    },
    {
      "id" : "terminology",
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r4",
      "version" : "6.5.0"
    },
    {
      "id" : "extensions",
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r4",
      "version" : "5.2.0"
    },
    {
      "id" : "cql",
      "uri" : "http://hl7.org/fhir/uv/cql/ImplementationGuide/hl7.fhir.uv.cql",
      "packageId" : "hl7.fhir.uv.cql",
      "version" : "2.0.0"
    }
  ],
  "global" : [
    {
      "type" : "Patient",
      "profile" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient"
    },
    {
      "type" : "Encounter",
      "profile" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-encounter"
    },
    {
      "type" : "Practitioner",
      "profile" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-practitioner"
    },
    {
      "type" : "PractitionerRole",
      "profile" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-practitionerrole"
    },
    {
      "type" : "Immunization",
      "profile" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-immunization"
    },
    {
      "type" : "Observation",
      "profile" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-simple-observation"
    },
    {
      "type" : "Organization",
      "profile" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-organization"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "STU 7"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2019+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "templates\\liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-expansion-params"
          },
          {
            "url" : "value",
            "valueString" : "_resources/exp-params.json"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "generate"
          },
          {
            "url" : "value",
            "valueString" : "xml"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "generate"
          },
          {
            "url" : "value",
            "valueString" : "JSON"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/StructureDefinition/codeOptions"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "pin-canonicals"
          },
          {
            "url" : "value",
            "valueString" : "pin-multiples"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/us/qicore/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/expansion-parameters",
        "valueReference" : {
          "reference" : "Parameters/expansion-parameters"
        }
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r4#0.8.0"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "STU 7"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2019+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "templates\\liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-expansion-params"
          },
          {
            "url" : "value",
            "valueString" : "_resources/exp-params.json"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "generate"
          },
          {
            "url" : "value",
            "valueString" : "xml"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "generate"
          },
          {
            "url" : "value",
            "valueString" : "JSON"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/StructureDefinition/codeOptions"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "pin-canonicals"
          },
          {
            "url" : "value",
            "valueString" : "pin-multiples"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/us/qicore/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "AdverseEvent"
          }
        ],
        "reference" : {
          "reference" : "AdverseEvent/example"
        },
        "name" : "AdverseEvent example",
        "description" : "Example of an allergic reaction adverse event",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "AllergyIntolerance"
          }
        ],
        "reference" : {
          "reference" : "AllergyIntolerance/example"
        },
        "name" : "AllergyIntolerance example",
        "description" : "Example of a clinical assessment record of an allergy",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "AllergyIntolerance"
          }
        ],
        "reference" : {
          "reference" : "AllergyIntolerance/example-refuted"
        },
        "name" : "AllergyIntolerance refuted example",
        "description" : "Example of a clinical assessment record of an allergy that has been refuted",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "BodyStructure"
          }
        ],
        "reference" : {
          "reference" : "BodyStructure/example"
        },
        "name" : "BodyStructure example",
        "description" : "Example of a BodyStructure resource to identify a mass in the spleen",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CarePlan"
          }
        ],
        "reference" : {
          "reference" : "CarePlan/example"
        },
        "name" : "CarePlan example",
        "description" : "Example of an assessment and care plan for a pregnancy",
        "exampleCanonical" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-careplan"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CareTeam"
          }
        ],
        "reference" : {
          "reference" : "CareTeam/example"
        },
        "name" : "CareTeam example",
        "description" : "Example of a CareTeam involved in the delivery of care for a pregnancy",
        "exampleCanonical" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-careteam"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Claim"
          }
        ],
        "reference" : {
          "reference" : "Claim/example"
        },
        "name" : "Claim example",
        "description" : "Example of a vision claim",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ClaimResponse"
          }
        ],
        "reference" : {
          "reference" : "ClaimResponse/example"
        },
        "name" : "ClaimResponse example",
        "description" : "Example of a vision claim response",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Communication"
          }
        ],
        "reference" : {
          "reference" : "Communication/example"
        },
        "name" : "Communication example",
        "description" : "Example of a notification sent to a patient about an abnormal test result (using the General Communication profile)",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Communication"
          }
        ],
        "reference" : {
          "reference" : "Communication/done-example"
        },
        "name" : "CommunicationDone example",
        "description" : "Example of a notification sent to a patient about an abnormal test result (using the Positive Communication profile)",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Communication"
          }
        ],
        "reference" : {
          "reference" : "Communication/negation-example"
        },
        "name" : "Communication negation example",
        "description" : "Example of a notification that was not sent to a patient and reason why",
        "exampleCanonical" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-communicationnotdone"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CommunicationRequest"
          }
        ],
        "reference" : {
          "reference" : "CommunicationRequest/example"
        },
        "name" : "CommunicationRequest example",
        "description" : "Example of a request to provide additional information for a claim",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/example"
        },
        "name" : "Condition Encounter Diagnosis example",
        "description" : "Example of a condition encounter diagnosis resource used to record information about a burn of the left ear",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/health-concern-example"
        },
        "name" : "Condition Problems Health Concerns example",
        "description" : "Example of a patient with a condition encounter health concern regarding obesity",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Condition"
          }
        ],
        "reference" : {
          "reference" : "Condition/appendicitis-example"
        },
        "name" : "Condition example - appendicitis",
        "description" : "Example of a condition resource used to record information about an appendicitis",
        "exampleCanonical" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-condition-encounter-diagnosis"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Coverage"
          }
        ],
        "reference" : {
          "reference" : "Coverage/example"
        },
        "name" : "Coverage example",
        "description" : "Example of a coverage resource used to provide information about an individual's specific plan",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Coverage"
          }
        ],
        "reference" : {
          "reference" : "Coverage/example-new"
        },
        "name" : "Coverage example - Subscriber ID",
        "description" : "Example of a coverage resource used to provide information about an individual's specific plan with a Subscriber Id",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Device"
          }
        ],
        "reference" : {
          "reference" : "Device/example"
        },
        "name" : "Device example",
        "description" : "Device example for an ECG",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DeviceRequest"
          }
        ],
        "reference" : {
          "reference" : "DeviceRequest/example"
        },
        "name" : "DeviceRequest general example",
        "description" : "Request to employ a medical device (using the General Profile)",
        "exampleCanonical" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-devicerequest"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DeviceRequest"
          }
        ],
        "reference" : {
          "reference" : "DeviceRequest/negation-example"
        },
        "name" : "DeviceRequest negation with value set example",
        "description" : "Example of a request not to employ any of a class of medical devices",
        "exampleCanonical" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-deviceprohibited"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DeviceRequest"
          }
        ],
        "reference" : {
          "reference" : "DeviceRequest/negation-with-code-example"
        },
        "name" : "DeviceRequest negation with code example",
        "description" : "Example of a request not to employ a specific medical device",
        "exampleCanonical" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-deviceprohibited"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DeviceRequest"
          }
        ],
        "reference" : {
          "reference" : "DeviceRequest/requested-example"
        },
        "name" : "DeviceRequest positive example",
        "description" : "Example of a request to employ a medical device (using the Positive Profile)",
        "exampleCanonical" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-devicerequested"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DeviceUseStatement"
          }
        ],
        "reference" : {
          "reference" : "DeviceUseStatement/example"
        },
        "name" : "DeviceUseStatement example",
        "description" : "Example of a record of device use by a patient",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DiagnosticReport"
          }
        ],
        "reference" : {
          "reference" : "DiagnosticReport/example"
        },
        "name" : "DiagnosticReportLab example",
        "description" : "Example of the findings and interpretation of a laboratory diagnostic test",
        "exampleCanonical" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-diagnosticreport-lab"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DiagnosticReport"
          }
        ],
        "reference" : {
          "reference" : "DiagnosticReport/note-example"
        },
        "name" : "DiagnosticReportNote example",
        "description" : "Example of a DiagnosticReport Note",
        "exampleCanonical" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-diagnosticreport-note"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/example"
        },
        "name" : "Encounter example",
        "description" : "Example of an Encounter",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "FamilyMemberHistory"
          }
        ],
        "reference" : {
          "reference" : "FamilyMemberHistory/example"
        },
        "name" : "FamilyMemberHistory example",
        "description" : "Example of Family Member History for a patient",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Flag"
          }
        ],
        "reference" : {
          "reference" : "Flag/example"
        },
        "name" : "Flag example",
        "description" : "Warning/Notification when providing care example",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Goal"
          }
        ],
        "reference" : {
          "reference" : "Goal/example"
        },
        "name" : "Goal example",
        "description" : "Example of weight loss goal/objective for a patient",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ImagingStudy"
          }
        ],
        "reference" : {
          "reference" : "ImagingStudy/example"
        },
        "name" : "ImagingStudy example",
        "description" : "Example of ImagingStudy based on CT imaging study",
        "exampleCanonical" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-imagingstudy"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Immunization"
          }
        ],
        "reference" : {
          "reference" : "Immunization/example"
        },
        "name" : "Immunization general example",
        "description" : "Immunization example (using the General Profile)",
        "exampleCanonical" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-immunization"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Immunization"
          }
        ],
        "reference" : {
          "reference" : "Immunization/done-example"
        },
        "name" : "Immunization positive example",
        "description" : "Immunization example (using the Positive Profile)",
        "exampleCanonical" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-immunizationdone"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Immunization"
          }
        ],
        "reference" : {
          "reference" : "Immunization/negation-example"
        },
        "name" : "Immunization negation with value set example",
        "description" : "Example of immunization that was refused/failed to be administered using value set",
        "exampleCanonical" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-immunizationnotdone"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Immunization"
          }
        ],
        "reference" : {
          "reference" : "Immunization/negation-example-code"
        },
        "name" : "Immunization negation with code example",
        "description" : "Example of immunization that was refused/failed to be administered using code",
        "exampleCanonical" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-immunizationnotdone"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ImmunizationEvaluation"
          }
        ],
        "reference" : {
          "reference" : "ImmunizationEvaluation/example"
        },
        "name" : "ImmunizationEvaluaion example",
        "description" : "Example of ImmunizationEvaluation",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ImmunizationRecommendation"
          }
        ],
        "reference" : {
          "reference" : "ImmunizationRecommendation/example"
        },
        "name" : "ImmunizationRecommendation example",
        "description" : "Example of ImmunizationRecommendation for Hepatitis A vaccine",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Location"
          }
        ],
        "reference" : {
          "reference" : "Location/example"
        },
        "name" : "Location example",
        "description" : "Example of Location of a provider - south wing of Mean Joe Greene University Medical Center",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/example"
        },
        "name" : "Medication example",
        "description" : "Example of Alemtuzumab Medication",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationAdministration"
          }
        ],
        "reference" : {
          "reference" : "MedicationAdministration/example"
        },
        "name" : "MedicationAdministration general example",
        "description" : "Intravenous example of MedicationAdministration (using the General Profile)",
        "exampleCanonical" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medicationadministration"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationAdministration"
          }
        ],
        "reference" : {
          "reference" : "MedicationAdministration/done-example"
        },
        "name" : "MedicationAdministration positive example",
        "description" : "Intravenous example of MedicationAdministration (using the Positive Profile)",
        "exampleCanonical" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medicationadministrationdone"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationAdministration"
          }
        ],
        "reference" : {
          "reference" : "MedicationAdministration/cmd-example"
        },
        "name" : "MedicationAdministration Cumulative Duration example",
        "description" : "Cumulative Medication example of MedicationAdministration",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationAdministration"
          }
        ],
        "reference" : {
          "reference" : "MedicationAdministration/negation-example"
        },
        "name" : "MedicationAdministration negation with value set example",
        "description" : "Example of medication not administered using a value set to indicate what was not administered",
        "exampleCanonical" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medicationadministrationnotdone"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationAdministration"
          }
        ],
        "reference" : {
          "reference" : "MedicationAdministration/negation-with-code-example"
        },
        "name" : "MedicationAdministration negation with code example",
        "description" : "Example of medication not administered using a code to indicate that a particular medication was not administered",
        "exampleCanonical" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medicationadministrationnotdone"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/example"
        },
        "name" : "MedicationDispense general example",
        "description" : "Penicillin MedicationDispense Example (using the General Profile)",
        "exampleCanonical" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medicationdispense"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/done-example"
        },
        "name" : "MedicationDispense positive example",
        "description" : "Penicillin MedicationDispense Example (using the Positive Profile)",
        "exampleCanonical" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medicationdispensedone"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/cmd-example"
        },
        "name" : "MedicationDispense cumulative dose example",
        "description" : "Cumulative Medication Dispense Example",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/negation-example"
        },
        "name" : "MedicationDispense negation with value set example",
        "description" : "Example of medication not dispensed using a value set to indicate the reason",
        "exampleCanonical" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medicationdispensedeclined"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationDispense"
          }
        ],
        "reference" : {
          "reference" : "MedicationDispense/negation-with-code-example"
        },
        "name" : "MedicationDispense negation with code example",
        "description" : "Example of medication not dispensed using a code to indicate the reason",
        "exampleCanonical" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medicationdispensedeclined"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/cmd-example"
        },
        "name" : "MedicationRequest Cumulative Duration",
        "description" : "Cumulative Medication Duration Example",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/example"
        },
        "name" : "MedicationRequest general example",
        "description" : "Penicillin MedicationRequest Example (using the General Profile)",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/requested-example"
        },
        "name" : "MedicationRequest positive example",
        "description" : "Penicillin MedicationRequest Example (using the Positive Profile)",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/patient-reported-example"
        },
        "name" : "MedicationRequest Patient Reported Example",
        "description" : "Patient Reported Example",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/patient-requester-example"
        },
        "name" : "MedicationRequest Patient Requester Example",
        "description" : "Patient Requester Example",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/practitioner-ordered-example"
        },
        "name" : "MedicationRequest Practitioner Ordered Example",
        "description" : "Practitioner Ordered Example",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/negation-example"
        },
        "name" : "MedicationProhibited using value set example",
        "description" : "Example of request not to provide a medication using a value set",
        "exampleCanonical" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medicationprohibited"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationRequest"
          }
        ],
        "reference" : {
          "reference" : "MedicationRequest/negation-example-code"
        },
        "name" : "MedicationProhibited using code example",
        "description" : "Example of request not to provide a medication using a code",
        "exampleCanonical" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medicationprohibited"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/example"
        },
        "name" : "MedicationStatment example",
        "description" : "Penicillin MedicationStatement Example",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "NutritionOrder"
          }
        ],
        "reference" : {
          "reference" : "NutritionOrder/example"
        },
        "name" : "NutrientOrder example",
        "description" : "Example of NutrientOrder for diabetic diet",
        "exampleCanonical" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-nutritionorder"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/example"
        },
        "name" : "Observation example",
        "description" : "Example of Decreased Hemoglobin Observation",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/example-odh"
        },
        "name" : "ODH Observation example",
        "description" : "Example of occupational data added to observation measure",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/example-frailty"
        },
        "name" : "Frailty observation example",
        "description" : "Example of a frailty observation measure",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/example-gestation"
        },
        "name" : "Gestation age at birth observation example",
        "description" : "Example of a gestation age at birth observation",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/example-obstetric-delivery"
        },
        "name" : "Date and time of obstetric delivery example",
        "description" : "Example of a obstetric delivery datetime Observation",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/example-delivery-date-estimate"
        },
        "name" : "Delivery date estimated example",
        "description" : "Example of a delivery date estimate Observation",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/example-preterm-births"
        },
        "name" : "Number of preterm births obeservation example",
        "description" : "Example number of preterm births Observation",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/example-births"
        },
        "name" : "Number of full-term births obeservation example",
        "description" : "Example number of full-term births Observation",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/example-parity"
        },
        "name" : "Number of parity obeservation example",
        "description" : "Example number of parity Observation",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/example-pregnancies"
        },
        "name" : "Number of pregnancies obeservation example",
        "description" : "Example number of pregnancies Observation",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/clinical-result-heart-rate-rhythm"
        },
        "name" : "Heart rate rhythm clinical result observation example",
        "description" : "Example of a Heart rate rhythm clinical result observation",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/example-screening-assessment-10-minute-apgar-heart-rate"
        },
        "name" : "10 minute Apgar Heart Rate Observation Screening Assessment Example",
        "description" : "Example of a 10 minute Apgar Heart Rate Observation Screening Assessment",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/laboratory-result-observation-example-blood-glucose"
        },
        "name" : "Glucose Laboratory Result Observation Example",
        "description" : "Example of a glucose laboratory result observation",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/example-nonpatient-mechanical-ventilator"
        },
        "name" : "Mechanical Ventilator Availability (physical object) Observation Example",
        "description" : "Example of mechanical ventilator availability nonpatient observation",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/example-nonpatient-hospital-bed"
        },
        "name" : "Hospital Bed Availability (physical object) Observation Example",
        "description" : "Example of hospital bed availability nonpatient observation",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/example-nonpatient-hemodialysis-machine"
        },
        "name" : "Hemodialysis Machine Availability (physical object) Observation Example",
        "description" : "Example of hempdialysis machine availability nonpatient observation",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/example"
        },
        "name" : "Organization example",
        "description" : "HL7 Organization example",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/example1"
        },
        "name" : "Hospital Organization example",
        "description" : "Hendricks County Hospital example",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Parameters"
          }
        ],
        "reference" : {
          "reference" : "Parameters/qicore-modelinfosettings"
        },
        "name" : "QICore ModelInfo Settings example",
        "description" : "QICore ModelInfo Settings Example",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/example"
        },
        "name" : "Patient example",
        "description" : "Basic Patient example",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/example-2"
        },
        "name" : "65+ Female patient example",
        "description" : "65+ Female patient example",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/infant-example"
        },
        "name" : "Infant patient example",
        "description" : "Infant patient example",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/example"
        },
        "name" : "Practitioner example",
        "description" : "Referring Practitioner example",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/example"
        },
        "name" : "PractitionerRole example",
        "description" : "PractitionerRole example",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Procedure"
          }
        ],
        "reference" : {
          "reference" : "Procedure/example"
        },
        "name" : "Procedure general example",
        "description" : "Appendectomy Procedure example (using the General Profile)",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Procedure"
          }
        ],
        "reference" : {
          "reference" : "Procedure/done-example"
        },
        "name" : "Procedure positive example",
        "description" : "Appendectomy Procedure example (using the Positive Profile)",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Procedure"
          }
        ],
        "reference" : {
          "reference" : "Procedure/negation-example"
        },
        "name" : "ProcedureNotDone with value set example",
        "description" : "Example of procedure not done using a value set",
        "exampleCanonical" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-procedurenotdone"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Procedure"
          }
        ],
        "reference" : {
          "reference" : "Procedure/negation-with-code-example"
        },
        "name" : "ProcedureNotDone with code example",
        "description" : "Example of procedure not done using a code",
        "exampleCanonical" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-procedurenotdone"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "QuestionnaireResponse"
          }
        ],
        "reference" : {
          "reference" : "QuestionnaireResponse/PHQ-9-example"
        },
        "name" : "PHQ-9 QuestionnaireResponse Example",
        "description" : "Example of a PHQ-9 Questionnaire Response",
        "exampleCanonical" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-questionnaireresponse"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ServiceRequest"
          }
        ],
        "reference" : {
          "reference" : "ServiceRequest/example"
        },
        "name" : "ServiceRequest general example",
        "description" : "Request for Appendectomy ServiceRequest example (using the General Profile)",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ServiceRequest"
          }
        ],
        "reference" : {
          "reference" : "ServiceRequest/proposal-example"
        },
        "name" : "ServiceRequest positive example with a value set",
        "description" : "Request for Intermittent pneumatic compression devices using a value set example (using the Positive Profile)",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ServiceRequest"
          }
        ],
        "reference" : {
          "reference" : "ServiceRequest/proposal-example-code"
        },
        "name" : "ServiceRequest positive example with a code",
        "description" : "Request for Graduated compression elastic hosiery using a code example (using the Positive Profile)",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ServiceRequest"
          }
        ],
        "reference" : {
          "reference" : "ServiceRequest/appropriateness-example"
        },
        "name" : "ServiceRequest appropriateness example",
        "description" : "ServiceRequest appropriateness example",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ServiceRequest"
          }
        ],
        "reference" : {
          "reference" : "ServiceRequest/negation-example"
        },
        "name" : "ServiceProhibited with value set example",
        "description" : "Example of request not to provide a service using a value set",
        "exampleCanonical" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-serviceprohibited"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ServiceRequest"
          }
        ],
        "reference" : {
          "reference" : "ServiceRequest/negation-example-code"
        },
        "name" : "ServiceProhibited with code example",
        "description" : "Example of request not to provide a service using a code",
        "exampleCanonical" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-serviceprohibited"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ServiceRequest"
          }
        ],
        "reference" : {
          "reference" : "ServiceRequest/myringotomy-example"
        },
        "name" : "ServiceRequest Myringotomy Procedure example",
        "description" : "ServiceRequest for Myringotomy Procedure example",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ServiceRequest"
          }
        ],
        "reference" : {
          "reference" : "ServiceRequest/elective-example"
        },
        "name" : "ServiceRequest elective example",
        "description" : "Elective procedure ServiceRequest example",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ServiceRequest"
          }
        ],
        "reference" : {
          "reference" : "ServiceRequest/servicerequested-example"
        },
        "name" : "ServiceRequested appendix example",
        "description" : "Appendectomy ServiceRequested example",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "RelatedPerson"
          }
        ],
        "reference" : {
          "reference" : "RelatedPerson/example"
        },
        "name" : "RelatedPerson example",
        "description" : "Emergency contact example",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Substance"
          }
        ],
        "reference" : {
          "reference" : "Substance/example"
        },
        "name" : "Substance example",
        "description" : "Honey Bee venom (apitoxin) Substance example",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Task"
          }
        ],
        "reference" : {
          "reference" : "Task/example"
        },
        "name" : "Task general example",
        "description" : "Task example (using the General Profile)",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Task"
          }
        ],
        "reference" : {
          "reference" : "Task/done-example"
        },
        "name" : "Task positive example",
        "description" : "Task example (using the Positive Profile)",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Task"
          }
        ],
        "reference" : {
          "reference" : "Task/negation-example"
        },
        "name" : "TaskRejected with value set example",
        "description" : "Example of task not done using a value set",
        "exampleCanonical" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-taskrejected"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Task"
          }
        ],
        "reference" : {
          "reference" : "Task/negation-with-code-example"
        },
        "name" : "TaskRejected with code example",
        "description" : "Example of task not done using a code",
        "exampleCanonical" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-taskrejected"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Task"
          }
        ],
        "reference" : {
          "reference" : "Task/rejected-example"
        },
        "name" : "TaskRejected example rejecting a proposal using a value set",
        "description" : "Example of a task rejecting a proposal that identifies the requested activity with a value set",
        "exampleCanonical" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-taskrejected"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Task"
          }
        ],
        "reference" : {
          "reference" : "Task/rejected-with-code-example"
        },
        "name" : "TaskRejected example rejecting a proposal using a code",
        "description" : "Example of a task rejecting a proposal that identifies the requested activity with a code",
        "exampleCanonical" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-taskrejected"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Encounter"
          }
        ],
        "reference" : {
          "reference" : "Encounter/encounter-ed-example"
        },
        "name" : "Encounter example of emergency visit that escalated into inpatient patient",
        "description" : "Encounter example of emergency visit that escalated into inpatient patient",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/qicore-medication-dose-type"
        },
        "name" : "QICore SNOMED CT Dosage Codes",
        "description" : "This value set includes all the \"Dosages\" SNOMED CT codes (i.e. codes with an is-a relationship with 277406006: Dosages).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/qicore-negation-reason"
        },
        "name" : "QICore Negation Reason Codes",
        "description" : "This value set defines the set of codes that can be used to indicate the reason an action was not taken",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/qicore-observation-body-position"
        },
        "name" : "QICore Observation Body Position",
        "description" : "SNOMED CT code system values descending from the following:'body position finding' 9851009",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/qicore-present-on-admission"
        },
        "name" : "QICore Present On Admission Codes",
        "description" : "Value Set for QICore Present On Admission.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-adverseevent"
        },
        "name" : "QICore AdverseEvent",
        "description" : "Actual or potential/avoided event causing unintended physical injury resulting from or contributed to by medical care, a research study or other healthcare setting factors that requires additional monitoring, treatment, or hospitalization, or that results in death."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-allergyintolerance"
        },
        "name" : "QICore AllergyIntolerance",
        "description" : "Profile of AllergyIntolerance for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-bodystructure"
        },
        "name" : "QICore BodyStructure",
        "description" : "Profile of BodyStructure for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-careplan"
        },
        "name" : "QICore CarePlan",
        "description" : "The QI-Core CarePlan is based upon the US Core CarePlan Profile which is based upon the core FHIR CarePlan Resource and created to meet the 2015 Edition Common Clinical Data Set 'Assessment and Plan of Treatment requirements. Defines constraints and extensions on the CarePlan resource for the minimal set of data to query and retrieve a patient's Care Plan."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-careteam"
        },
        "name" : "QICore CareTeam",
        "description" : "Profile of CareTeam for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-claim"
        },
        "name" : "QICore Claim",
        "description" : "Profile of Claim for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-claimresponse"
        },
        "name" : "QICore ClaimResponse",
        "description" : "The QI-Core ClaimResponse profile is used to provide the results of the adjudication and/or authorization of a set of healthcare-related products and services for a patient against the patient's insurance coverages, or to respond with what the adjudication would be for a supplied set of products or services should they be actually supplied to the patient. It identifies the mandatory core elements, extensions, vocabularies and value sets which **SHALL** be present in the ClaimResponse resource when using this profile"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-communication"
        },
        "name" : "QICore Communication",
        "description" : "Profile of Communication for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-communicationdone"
        },
        "name" : "QICore CommunicationDone",
        "description" : "Positive profile of Communication for decision support/quality metrics. Indicates that the communication was performed (as opposed to the not done profile)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-communicationnotdone"
        },
        "name" : "QICore Communication Not Done",
        "description" : "Negation profile of Communication for decision support/quality metrics. Indicates that the communication was not performed for a reason."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-communicationrequest"
        },
        "name" : "QICore CommunicationRequest",
        "description" : "Profile of CommunicationRequest for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-condition-encounter-diagnosis"
        },
        "name" : "QICore Condition Encounter Diagnosis",
        "description" : "The QI-Core Condition Encounter Diagnosis Profile is based upon the US Core Condition Encounter Diagnosis Profile.   In version 5.0.0, the QI-Core Condition Profile has been split into the QI-Core Condition Encounter Diagnosis Profile and QI-Core Condition Problems and Health Concerns Profile. To promote interoperability and adoption through consistent implementation, this profile defines constraints and extensions on the Condition resource for the minimal set of data to record, search, and retrieve information about an encounter diagnosis.  It defines the core set of elements and extensions for quality rule and measure authors."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-condition-problems-health-concerns"
        },
        "name" : "QICore Condition Problems Health Concerns",
        "description" : "Profile of Condition for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-device"
        },
        "name" : "QICore Device",
        "description" : "Profile of Device for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-deviceprohibited"
        },
        "name" : "QICore Device Prohibited",
        "description" : "Negation profile of DeviceRequest for decision support/quality metrics. Indicates a proposal, plan, or order not to provide a device."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-devicerequest"
        },
        "name" : "QICore DeviceRequest",
        "description" : "Profile of DeviceRequest for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-devicerequested"
        },
        "name" : "QICore DeviceRequested",
        "description" : "Positive profile of DeviceRequest for decision support/quality metrics. Indicates a proposal, plan, or order for a device."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-deviceusestatement"
        },
        "name" : "QICore DeviceUseStatement",
        "description" : "Profile of DeviceUseStatement for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-diagnosticreport-lab"
        },
        "name" : "QICore DiagnosticReport Profile for Laboratory Results Reporting",
        "description" : "Profile of DiagnosticReport for laboratory results for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-diagnosticreport-note"
        },
        "name" : "QICore DiagnosticReport Profile for Report and Note Exchange",
        "description" : "Profile of DiagnosticReport for Note exchange for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-encounter"
        },
        "name" : "QICore Encounter",
        "description" : "Profile of Encounter for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-familymemberhistory"
        },
        "name" : "QICore FamilyMemberHistory",
        "description" : "Profile of Family Member History for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-flag"
        },
        "name" : "QICore Flag",
        "description" : "Profile of Flag for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-goal"
        },
        "name" : "QICore Goal",
        "description" : "Profile of Goal for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-imagingstudy"
        },
        "name" : "QICore ImagingStudy",
        "description" : "Profile of ImagingStudy for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-immunization"
        },
        "name" : "QICore Immunization",
        "description" : "Profile of Immunization for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-immunizationdone"
        },
        "name" : "QICore Immunization Done",
        "description" : "Positive profile of Immunization for decision support/quality metrics. Indicates that the immunization is being or was performed (as opposed to the not done profile)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-immunizationevaluation"
        },
        "name" : "QICore ImmunizationEvaluation",
        "description" : "Defines constraints and extensions on the ImmunizationEvaluation resource for the minimal set of data to query and retrieve a patient's Immunization Evaluation."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-immunizationnotdone"
        },
        "name" : "QICore Immunization Not Done",
        "description" : "Negation profile of Communication for decision support/quality metrics. Indicates that the communication was not performed for a reason."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-immunizationrecommendation"
        },
        "name" : "QICore ImmunizationRecommendation",
        "description" : "Profile of ImmunizationRecommendation for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-observation-lab"
        },
        "name" : "QICore Laboratory Result Observation",
        "description" : "The QI-Core Laboratory Result Observation Profile is based upon the US Laboratory Result Observation Resource.  Defines the core set of elements and extensions for quality rule and measure authors."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-location"
        },
        "name" : "QICore Location",
        "description" : "Profile of Location for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-medication"
        },
        "name" : "QICore Medication",
        "description" : "Profile of Medication for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-medicationadministration"
        },
        "name" : "QICore MedicationAdministration",
        "description" : "Profile of MedicationAdministration for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-medicationadministrationdone"
        },
        "name" : "QICore MedicationAdministration Done",
        "description" : "Positive profile of MedicationAdministration for decision support/quality metrics. Indicates that a medication administration is being or was performed (as opposed to the negative profile)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-medicationadministrationnotdone"
        },
        "name" : "QICore MedicationAdministration Not Done",
        "description" : "Negation profile of MedicationAdministration for decision support/quality metrics. Indicates that a medication was not administered for a reason."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-medicationdispense"
        },
        "name" : "QICore MedicationDispense",
        "description" : "Profile of MedicationDispense for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-medicationdispensedeclined"
        },
        "name" : "QICore MedicationDispense Declined",
        "description" : "Negation profile of MedicationDispense for decision support/quality metrics. Indicates that a medication dispense was declined for a reason."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-medicationdispensedone"
        },
        "name" : "QICore MedicationDispense Done",
        "description" : "Positive profile of MedicationDispense for decision support/quality metrics. Indicates that a medication is being or was dispensed"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-medicationprohibited"
        },
        "name" : "QICore Medication Prohibited",
        "description" : "Negation profile of MedicationRequest for decision support/quality metrics. Indicates a proposal, plan, or order not to provide a medication."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-medicationrequest"
        },
        "name" : "QICore MedicationRequest",
        "description" : "Profile of MedicationRequest for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-medicationrequested"
        },
        "name" : "QICore MedicationRequested",
        "description" : "Positive profile of MedicationRequest for decision support/quality metrics. Indicates that a medication was proposed, planned, or ordered."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-medicationstatement"
        },
        "name" : "QICore MedicationStatement",
        "description" : "Profile of MedicationStatement for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-nonpatient-observation"
        },
        "name" : "QICore NonPatient Observation",
        "description" : "Profile of NonPatient Observation for decision support/quality metrics evaluating resource use and availability rather than focusing on patients. Defines the core set of elements and extensions for quality rule and measure authors."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-nutritionorder"
        },
        "name" : "QICore NutritionOrder",
        "description" : "Defines constraints and extensions on the NutritionOrder resource for the minimal set of data to query and retrieve a patient's Nutrition Order."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-observation-clinical-result"
        },
        "name" : "QICore Observation Clinical Result",
        "description" : "This profile sets minimum expectations for the Observation resource to record and search non-laboratory clinical test results (e.g., radiology and other clinical observations generated from procedures). An example would be when a gastroenterologist reports the size of a polyp observed during a colonoscopy. This profile is the basis for the US Core Clinical  Result Profile, which defines additional data elements to record and search laboratory test results."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-observation-screening-assessment"
        },
        "name" : "QICore Observation Screening Assessment",
        "description" : "The QI-Core Observation Screening Assessment Profile is based upon the US Core Observation Screening Assessment Profile which can be used to represent individual responses, panels of multi-question surveys, and multi-select responses to “check all that apply” questions. The QI-Core Observation Survey Profile sets minimum expectations for the Observation Resource to record, search, and fetch retrieve observations that represent the questions and responses to form/survey and defines the core set of elements and extensions for quality rule and measure authors."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-organization"
        },
        "name" : "QICore Organization",
        "description" : "Profile of Organization for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-patient"
        },
        "name" : "QICore Patient",
        "description" : "Profile of Patient for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-practitioner"
        },
        "name" : "QICore Practitioner",
        "description" : "Profile of Practitioner for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-practitionerrole"
        },
        "name" : "QICore PractitionerRole",
        "description" : "Profile of PractitionerRole for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-procedure"
        },
        "name" : "QICore Procedure",
        "description" : "Profile of Procedure for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-proceduredone"
        },
        "name" : "QICore Procedure Done",
        "description" : "Positive profile of Procedure for decision support/quality metrics. Indicates that a procedure is being or was performed."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-procedurenotdone"
        },
        "name" : "QICore Procedure Not Done",
        "description" : "Negative profile of Procedure for decision support/quality metrics. Indicates that a procedure was not done for a reason."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-questionnaireresponse"
        },
        "name" : "QICore QuestionnaireResponse",
        "description" : "The QI-Core QuestionnaireResponse Profile is based upon the US Core QuestionnaireResponse Profile and sets minimum expectations for the QuestionnaireResponse resource to record, search, and fetch retrieve captures the responses to form/survey and defines the core set of elements and extensions for quality rule and measure authors."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-relatedperson"
        },
        "name" : "QICore RelatedPerson",
        "description" : "Profile of RelatedPerson for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-serviceprohibited"
        },
        "name" : "QICore Service Prohibited",
        "description" : "Negation profile of ServiceRequest for decision support/quality metrics. Indicates a request not to provide a service"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-servicerequest"
        },
        "name" : "QICore ServiceRequest",
        "description" : "Profile of ServiceRequest for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-servicerequested"
        },
        "name" : "QICore ServiceRequested",
        "description" : "Positive profile of ServiceRequest for decision support/quality metrics. Indicates that a service is proposed, planned, or ordered."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-simple-observation"
        },
        "name" : "QICore Simple Observation",
        "description" : "Profile of Simple Observation for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-substance"
        },
        "name" : "QICore Substance",
        "description" : "Profile of Substance for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-task"
        },
        "name" : "QICore Task",
        "description" : "Profile of Task for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-taskdone"
        },
        "name" : "QICore Task Done",
        "description" : "Positive profile of Task for decision support/quality metrics. Indicates a task that with a positive status"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-taskrejected"
        },
        "name" : "QICore Task Rejected",
        "description" : "Profile of TaskRejected for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-coverage"
        },
        "name" : "QICore Coverage",
        "description" : "Profile of Coverage for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/codeOptions"
        },
        "name" : "Code Options",
        "description" : "A logical reference (i.e. a reference to ValueSet.url) to a value set/version that identifies a set of possible coded values used to convey a higher level concept that encompasses a list of candidate specializations when there is no formal code defined for that purpose. For example, the concept of COVID preventative medications can be expressed as a value set because there is no specific code representing that concept."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:extension"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/qicore-keyelement"
        },
        "name" : "QI-Core Key Element Extension",
        "description" : "**This extension is only used in the QI-Core Implementation Guide's Profile StructureDefinition elements.** It flags elements that the quality improvement community has identified as significant to express the full intent of measures or decision support artifacts. See the [MustSupport Flag](index.html#mustsupport-flag) section in this IG for more information."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Library"
          }
        ],
        "reference" : {
          "reference" : "Library/QICore-ModelInfo"
        },
        "name" : "QICore Model Definition",
        "description" : "Model definition for the QI-Core IG Model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/qicore-positive-event-status"
        },
        "name" : "Positive Event Status",
        "description" : "This value set defines the set of codes that indicate a positive event status (i.e. codes that indicate an event is in preparation, progress, on-hold, stopped, or has completed)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/qicore-positive-medication-admin-status"
        },
        "name" : "Positive MedicationAdministration Status",
        "description" : "This value set defines the set of codes that indicate a positive medication administration status (i.e. codes that indicate at least some medication is being or was administered)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/qicore-positive-medicationdispense-status"
        },
        "name" : "Positive MedicationDispense Status",
        "description" : "This value set defines the set of codes that indicate a positive medication dispense status (i.e. codes that indicate at least some medication was dispensed)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/qicore-positive-medicationrequest-status"
        },
        "name" : "Positive MedicationRequest Status",
        "description" : "This value set defines the set of codes that indicate a positive medication request status (i.e. codes that a medication is proposed, planned, or ordered)"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/qicore-positive-request-status"
        },
        "name" : "Positive Request Status",
        "description" : "This value set defines the set of codes that indicate a positive request status (i.e. codes that indicate an activity is proposed, planned, or ordered)."
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/qicore-positive-task-status"
        },
        "name" : "Positive Task Status",
        "description" : "This value set defines the set of codes that indicate a positive task status"
      }
    ],
    "page" : {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
          "valueCode" : "informative"
        },
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
          "valueUrl" : "index.html"
        }
      ],
      "nameUrl" : "index.html",
      "title" : "Quality Improvement Core (QI-Core) Implementation Guide",
      "generation" : "markdown",
      "page" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "profiles.html"
            }
          ],
          "nameUrl" : "profiles.html",
          "title" : "QI-Core Profiles",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "negation.html"
            }
          ],
          "nameUrl" : "negation.html",
          "title" : "QI-Core Negation",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "patterns.html"
            }
          ],
          "nameUrl" : "patterns.html",
          "title" : "QI-Core Patterns",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "modelinfo.html"
            }
          ],
          "nameUrl" : "modelinfo.html",
          "title" : "Model Info",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "extensions.html"
            }
          ],
          "nameUrl" : "extensions.html",
          "title" : "QI-Core Extensions",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "terminology.html"
            }
          ],
          "nameUrl" : "terminology.html",
          "title" : "QI-Core Terminology",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "examples.html"
            }
          ],
          "nameUrl" : "examples.html",
          "title" : "QI-Core Examples",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "downloads.html"
            }
          ],
          "nameUrl" : "downloads.html",
          "title" : "QI-Core Downloads",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "qdm-to-qicore.html"
            }
          ],
          "nameUrl" : "qdm-to-qicore.html",
          "title" : "Quality Data Model (QDM)v5.6 to QI-Core R7 Mapping",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "qi-elements.html"
            }
          ],
          "nameUrl" : "qi-elements.html",
          "title" : "QI Key Elements",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "changes.html"
            }
          ],
          "nameUrl" : "changes.html",
          "title" : "Changes",
          "generation" : "markdown"
        }
      ]
    },
    "parameter" : [
      {
        "code" : "path-resource",
        "value" : "resources"
      },
      {
        "code" : "path-resource",
        "value" : "input/capabilities"
      },
      {
        "code" : "path-resource",
        "value" : "input/examples"
      },
      {
        "code" : "path-resource",
        "value" : "input/extensions"
      },
      {
        "code" : "path-resource",
        "value" : "input/models"
      },
      {
        "code" : "path-resource",
        "value" : "input/operations"
      },
      {
        "code" : "path-resource",
        "value" : "input/profiles"
      },
      {
        "code" : "path-resource",
        "value" : "input/resources"
      },
      {
        "code" : "path-resource",
        "value" : "input/vocabulary"
      },
      {
        "code" : "path-resource",
        "value" : "input/testing"
      },
      {
        "code" : "path-resource",
        "value" : "input/history"
      },
      {
        "code" : "path-resource",
        "value" : "fsh-generated/resources"
      },
      {
        "code" : "path-pages",
        "value" : "template/config"
      },
      {
        "code" : "path-pages",
        "value" : "input/images"
      },
      {
        "code" : "path-tx-cache",
        "value" : "input-cache/txcache"
      }
    ]
  }
}

```
