# QI-Core Downloads - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* **QI-Core Downloads**

## QI-Core Downloads

### Full Implementation Guide

The following file contains the complete, downloadable implementation guide:

* [Full IG](full-ig.zip)

### IG Package

The following file is the FHIR IG Package [NPM Subset](https://confluence.hl7.org/display/FHIR/NPM+Package+Specification)

* [package.tgz](package.tgz)

### Definitions

In addition to the above, we have provided format-specific **definitions**:

* [XML](definitions.xml.zip)
* [JSON](definitions.json.zip)
* [TTL](definitions.ttl.zip)

These files should be the first choice whenever generating any implementation artifacts since they contain all of the rules about what makes these US Core profiles valid. Implementers will still need to be familiar with the content of the specification and profiles that apply in order to make a conformant implementation. See the overview on [validating FHIR profiles and resources](http://hl7.org/fhir/validation.html) for more information about validating profiles and how to use these artifacts.

### Examples

All examples used in this Implementation Guide:

* [XML](examples.xml.zip)
* [JSON](examples.json.zip)
* [TTL](examples.ttl.zip)

### Dependencies






### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (hl7.fhir.us.qicore.r4)](package.r4.tgz) and [R4B (hl7.fhir.us.qicore.r4b)](package.r4b.tgz) are available.

### Global Profiles

Global Profiles:

* **Type**: [Encounter](http://hl7.org/fhir/R4/encounter.html)
  * **Source**: 
  * **Profile**: [QICore Encounter](StructureDefinition-qicore-encounter.md)
* **Type**: [Immunization](http://hl7.org/fhir/R4/immunization.html)
  * **Source**: 
  * **Profile**: [QICore Immunization](StructureDefinition-qicore-immunization.md)
* **Type**: [Observation](http://hl7.org/fhir/R4/observation.html)
  * **Source**: 
  * **Profile**: [QICore Simple Observation](StructureDefinition-qicore-simple-observation.md)
* **Type**: [Organization](http://hl7.org/fhir/R4/organization.html)
  * **Source**: 
  * **Profile**: [QICore Organization](StructureDefinition-qicore-organization.md)
* **Type**: [Patient](http://hl7.org/fhir/R4/patient.html)
  * **Source**: 
  * **Profile**: [QICore Patient](StructureDefinition-qicore-patient.md)
* **Type**: [Practitioner](http://hl7.org/fhir/R4/practitioner.html)
  * **Source**: 
  * **Profile**: [QICore Practitioner](StructureDefinition-qicore-practitioner.md)
* **Type**: [PractitionerRole](http://hl7.org/fhir/R4/practitionerrole.html)
  * **Source**: 
  * **Profile**: [QICore PractitionerRole](StructureDefinition-qicore-practitionerrole.md)

All resources of these types must conform to these profiles.

### IP Statements

This publication includes IP covered under the following statements.

* © Copyright 2022 American Medical Association

* [NUCC Provider Taxonomy](http://tx.fhir.org/r4/ValueSet/nucc-provider-taxonomy): [PractitionerRole/example](PractitionerRole-example.md) and [QICorePractitionerRole](StructureDefinition-qicore-practitionerrole.md)


* HL7 International.

* [Financial Resource Status Codes](http://hl7.org/fhir/R4/codesystem-fm-status.html): [QICoreClaimResponse](StructureDefinition-qicore-claimresponse.md)


* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.5.0/CodeSystem-ISO3166Part1.html): [CodeOptions](StructureDefinition-codeOptions.md), [NegationReasonCodes](ValueSet-qicore-negation-reason.md)...Show 76 more,[PositiveEventStatus](ValueSet-qicore-positive-event-status.md),[PositiveMedicationAdministrationStatus](ValueSet-qicore-positive-medication-admin-status.md),[PositiveMedicationDispenseStatus](ValueSet-qicore-positive-medicationdispense-status.md),[PositiveMedicationRequestStatus](ValueSet-qicore-positive-medicationrequest-status.md),[PositiveRequestStatus](ValueSet-qicore-positive-request-status.md),[PositiveTaskStatus](ValueSet-qicore-positive-task-status.md),[QICORE_KeyElement](StructureDefinition-qicore-keyelement.md),[QICore](Library-QICore-ModelInfo.md),[QICoreAdverseEvent](StructureDefinition-qicore-adverseevent.md),[QICoreAllergyIntolerance](StructureDefinition-qicore-allergyintolerance.md),[QICoreBodyStructure](StructureDefinition-qicore-bodystructure.md),[QICoreCarePlan](StructureDefinition-qicore-careplan.md),[QICoreCareTeam](StructureDefinition-qicore-careteam.md),[QICoreClaim](StructureDefinition-qicore-claim.md),[QICoreClaimResponse](StructureDefinition-qicore-claimresponse.md),[QICoreCommunication](StructureDefinition-qicore-communication.md),[QICoreCommunicationDone](StructureDefinition-qicore-communicationdone.md),[QICoreCommunicationNotDone](StructureDefinition-qicore-communicationnotdone.md),[QICoreCommunicationRequest](StructureDefinition-qicore-communicationrequest.md),[QICoreConditionEncounterDiagnosis](StructureDefinition-qicore-condition-encounter-diagnosis.md),[QICoreConditionProblemsHealthConcerns](StructureDefinition-qicore-condition-problems-health-concerns.md),[QICoreCoverage](StructureDefinition-qicore-coverage.md),[QICoreDevice](StructureDefinition-qicore-device.md),[QICoreDeviceProhibited](StructureDefinition-qicore-deviceprohibited.md),[QICoreDeviceRequest](StructureDefinition-qicore-devicerequest.md),[QICoreDeviceRequested](StructureDefinition-qicore-devicerequested.md),[QICoreDeviceUseStatement](StructureDefinition-qicore-deviceusestatement.md),[QICoreDiagnosticReportLab](StructureDefinition-qicore-diagnosticreport-lab.md),[QICoreDiagnosticReportNote](StructureDefinition-qicore-diagnosticreport-note.md),[QICoreEncounter](StructureDefinition-qicore-encounter.md),[QICoreFamilyMemberHistory](StructureDefinition-qicore-familymemberhistory.md),[QICoreFlag](StructureDefinition-qicore-flag.md),[QICoreGoal](StructureDefinition-qicore-goal.md),[QICoreImagingStudy](StructureDefinition-qicore-imagingstudy.md),[QICoreImmunization](StructureDefinition-qicore-immunization.md),[QICoreImmunizationDone](StructureDefinition-qicore-immunizationdone.md),[QICoreImmunizationEvaluation](StructureDefinition-qicore-immunizationevaluation.md),[QICoreImmunizationNotDone](StructureDefinition-qicore-immunizationnotdone.md),[QICoreImmunizationRecommendation](StructureDefinition-qicore-immunizationrecommendation.md),[QICoreLaboratoryResultObservation](StructureDefinition-qicore-observation-lab.md),[QICoreLocation](StructureDefinition-qicore-location.md),[QICoreMedication](StructureDefinition-qicore-medication.md),[QICoreMedicationAdministration](StructureDefinition-qicore-medicationadministration.md),[QICoreMedicationAdministrationDone](StructureDefinition-qicore-medicationadministrationdone.md),[QICoreMedicationAdministrationNotDone](StructureDefinition-qicore-medicationadministrationnotdone.md),[QICoreMedicationDispense](StructureDefinition-qicore-medicationdispense.md),[QICoreMedicationDispenseDeclined](StructureDefinition-qicore-medicationdispensedeclined.md),[QICoreMedicationDispenseDone](StructureDefinition-qicore-medicationdispensedone.md),[QICoreMedicationDoseType](ValueSet-qicore-medication-dose-type.md),[QICoreMedicationProhibited](StructureDefinition-qicore-medicationprohibited.md),[QICoreMedicationRequest](StructureDefinition-qicore-medicationrequest.md),[QICoreMedicationRequested](StructureDefinition-qicore-medicationrequested.md),[QICoreMedicationStatement](StructureDefinition-qicore-medicationstatement.md),[QICoreNonPatientObservation](StructureDefinition-qicore-nonpatient-observation.md),[QICoreNutritionOrder](StructureDefinition-qicore-nutritionorder.md),[QICoreObservationBodyPosition](ValueSet-qicore-observation-body-position.md),[QICoreObservationClinicalResult](StructureDefinition-qicore-observation-clinical-result.md),[QICoreObservationScreeningAssessment](StructureDefinition-qicore-observation-screening-assessment.md),[QICoreOrganization](StructureDefinition-qicore-organization.md),[QICorePatient](StructureDefinition-qicore-patient.md),[QICorePractitioner](StructureDefinition-qicore-practitioner.md),[QICorePractitionerRole](StructureDefinition-qicore-practitionerrole.md),[QICorePresentOnAdmission](ValueSet-qicore-present-on-admission.md),[QICoreProcedure](StructureDefinition-qicore-procedure.md),[QICoreProcedureDone](StructureDefinition-qicore-proceduredone.md),[QICoreProcedureNotDone](StructureDefinition-qicore-procedurenotdone.md),[QICoreQuestionnaireResponse](StructureDefinition-qicore-questionnaireresponse.md),[QICoreRelatedPerson](StructureDefinition-qicore-relatedperson.md),[QICoreServiceProhibited](StructureDefinition-qicore-serviceprohibited.md),[QICoreServiceRequest](StructureDefinition-qicore-servicerequest.md),[QICoreServiceRequested](StructureDefinition-qicore-servicerequested.md),[QICoreSimpleObservation](StructureDefinition-qicore-simple-observation.md),[QICoreSubstance](StructureDefinition-qicore-substance.md),[QICoreTask](StructureDefinition-qicore-task.md),[QICoreTaskDone](StructureDefinition-qicore-taskdone.md)and[QICoreTaskRejected](StructureDefinition-qicore-taskrejected.md)


* Most of the information on the CDC and ATSDR websites is not subject to copyright, is in the public domain, and may be freely used or reproduced without obtaining copyright permission. For information and exceptions regarding use of CDC material please see [[https://www.cdc.gov/other/agencymaterials.html](https://www.cdc.gov/other/agencymaterials.html)](https://www.cdc.gov/other/agencymaterials.html) 

* [Vaccine Administered Code Set (CVX)](http://terminology.hl7.org/6.5.0/CodeSystem-CVX.html): [Immunization/negation-example-code](Immunization-negation-example-code.md) and [QICoreImmunizationRecommendation](StructureDefinition-qicore-immunizationrecommendation.md)


* The POA Indicator Codes are in the public domain and are free to use without restriction.

* [CMS Present on Admission (POA) Indicator](http://terminology.hl7.org/6.5.0/CodeSystem-presentOnAdmission.html): [QICoreClaim](StructureDefinition-qicore-claim.md) and [QICorePresentOnAdmission](ValueSet-qicore-present-on-admission.md)


* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ucum.html): [Goal/example](Goal-example.md), [Immunization/done-example](Immunization-done-example.md)...Show 23 more,[Immunization/example](Immunization-example.md),[Medication/example](Medication-example.md),[MedicationAdministration/cmd-example](MedicationAdministration-cmd-example.md),[MedicationAdministration/done-example](MedicationAdministration-done-example.md),[MedicationAdministration/example](MedicationAdministration-example.md),[MedicationAdministration/negation-example](MedicationAdministration-negation-example.md),[MedicationAdministration/negation-with-code-example](MedicationAdministration-negation-with-code-example.md),[MedicationDispense/cmd-example](MedicationDispense-cmd-example.md),[MedicationDispense/done-example](MedicationDispense-done-example.md),[MedicationDispense/example](MedicationDispense-example.md),[MedicationDispense/negation-example](MedicationDispense-negation-example.md),[MedicationDispense/negation-with-code-example](MedicationDispense-negation-with-code-example.md),[MedicationRequest/cmd-example](MedicationRequest-cmd-example.md),[MedicationRequest/example](MedicationRequest-example.md),[MedicationRequest/patient-reported-example](MedicationRequest-patient-reported-example.md),[MedicationRequest/patient-requester-example](MedicationRequest-patient-requester-example.md),[MedicationRequest/practitioner-ordered-example](MedicationRequest-practitioner-ordered-example.md),[MedicationRequest/requested-example](MedicationRequest-requested-example.md),[MedicationStatement/example](MedicationStatement-example.md),[NutritionOrder/example](NutritionOrder-example.md),[Observation/example](Observation-example.md),[Observation/example-gestation](Observation-example-gestation.md)and[Observation/laboratory-result-observation-example-blood-glucose](Observation-laboratory-result-observation-example-blood-glucose.md)


* These codes are excerpted from Digital Imaging and Communications in Medicine (DICOM) Standard, Part 16: Content Mapping Resource, Copyright Â© 2011 by the National Electrical Manufacturers Association.

* [DICOM Controlled Terminology Definitions](http://dicom.nema.org/resources/ontology/DCM): [ImagingStudy/example](ImagingStudy-example.md)


* This is an example set.

* [ICD-10 Procedure Codes](http://hl7.org/fhir/R4/codesystem-icd-10-procedures.html): [QICoreClaim](StructureDefinition-qicore-claim.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.5.0/CodeSystem-v3-loinc.html): [DiagnosticReport/example](DiagnosticReport-example.md), [DiagnosticReport/note-example](DiagnosticReport-note-example.md)...Show 22 more,[Goal/example](Goal-example.md),[ImmunizationRecommendation/example](ImmunizationRecommendation-example.md),[Observation/clinical-result-heart-rate-rhythm](Observation-clinical-result-heart-rate-rhythm.md),[Observation/example](Observation-example.md),[Observation/example-births](Observation-example-births.md),[Observation/example-delivery-date-estimate](Observation-example-delivery-date-estimate.md),[Observation/example-frailty](Observation-example-frailty.md),[Observation/example-gestation](Observation-example-gestation.md),[Observation/example-obstetric-delivery](Observation-example-obstetric-delivery.md),[Observation/example-odh](Observation-example-odh.md),[Observation/example-parity](Observation-example-parity.md),[Observation/example-pregnancies](Observation-example-pregnancies.md),[Observation/example-preterm-births](Observation-example-preterm-births.md),[Observation/example-screening-assessment-10-minute-apgar-heart-rate](Observation-example-screening-assessment-10-minute-apgar-heart-rate.md),[Observation/laboratory-result-observation-example-blood-glucose](Observation-laboratory-result-observation-example-blood-glucose.md),[QICoreDiagnosticReportLab](StructureDefinition-qicore-diagnosticreport-lab.md),[QICoreDiagnosticReportNote](StructureDefinition-qicore-diagnosticreport-note.md),[QICoreLaboratoryResultObservation](StructureDefinition-qicore-observation-lab.md),[QICoreNonPatientObservation](StructureDefinition-qicore-nonpatient-observation.md),[QICoreObservationClinicalResult](StructureDefinition-qicore-observation-clinical-result.md),[QICoreObservationScreeningAssessment](StructureDefinition-qicore-observation-screening-assessment.md)and[QICoreSimpleObservation](StructureDefinition-qicore-simple-observation.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://tx.fhir.org/r4/ValueSet/snomedct): [AdverseEvent/example](AdverseEvent-example.md), [AllergyIntolerance/example](AllergyIntolerance-example.md)...Show 80 more,[AllergyIntolerance/example-refuted](AllergyIntolerance-example-refuted.md),[BodyStructure/example](BodyStructure-example.md),[CarePlan/example](CarePlan-example.md),[Communication/negation-example](Communication-negation-example.md),[Condition/appendicitis-example](Condition-appendicitis-example.md),[Condition/example](Condition-example.md),[Condition/health-concern-example](Condition-health-concern-example.md),[Device/example](Device-example.md),[DeviceRequest/negation-example](DeviceRequest-negation-example.md),[DeviceRequest/negation-with-code-example](DeviceRequest-negation-with-code-example.md),[FamilyMemberHistory/example](FamilyMemberHistory-example.md),[Flag/example](Flag-example.md),[ImagingStudy/example](ImagingStudy-example.md),[Immunization/done-example](Immunization-done-example.md),[Immunization/example](Immunization-example.md),[Immunization/negation-example](Immunization-negation-example.md),[Immunization/negation-example-code](Immunization-negation-example-code.md),[ImmunizationEvaluation/example](ImmunizationEvaluation-example.md),[ImmunizationRecommendation/example](ImmunizationRecommendation-example.md),[Medication/example](Medication-example.md),[MedicationAdministration/cmd-example](MedicationAdministration-cmd-example.md),[MedicationAdministration/done-example](MedicationAdministration-done-example.md),[MedicationAdministration/example](MedicationAdministration-example.md),[MedicationAdministration/negation-example](MedicationAdministration-negation-example.md),[MedicationAdministration/negation-with-code-example](MedicationAdministration-negation-with-code-example.md),[MedicationDispense/cmd-example](MedicationDispense-cmd-example.md),[MedicationDispense/done-example](MedicationDispense-done-example.md),[MedicationDispense/example](MedicationDispense-example.md),[MedicationDispense/negation-example](MedicationDispense-negation-example.md),[MedicationDispense/negation-with-code-example](MedicationDispense-negation-with-code-example.md),[MedicationRequest/cmd-example](MedicationRequest-cmd-example.md),[MedicationRequest/example](MedicationRequest-example.md),[MedicationRequest/negation-example](MedicationRequest-negation-example.md),[MedicationRequest/negation-example-code](MedicationRequest-negation-example-code.md),[MedicationRequest/patient-reported-example](MedicationRequest-patient-reported-example.md),[MedicationRequest/patient-requester-example](MedicationRequest-patient-requester-example.md),[MedicationRequest/practitioner-ordered-example](MedicationRequest-practitioner-ordered-example.md),[MedicationRequest/requested-example](MedicationRequest-requested-example.md),[MedicationStatement/example](MedicationStatement-example.md),[NutritionOrder/example](NutritionOrder-example.md),[Observation/example](Observation-example.md),[Observation/example-frailty](Observation-example-frailty.md),[Observation/example-nonpatient-hemodialysis-machine](Observation-example-nonpatient-hemodialysis-machine.md),[Observation/example-nonpatient-hospital-bed](Observation-example-nonpatient-hospital-bed.md),[Observation/example-nonpatient-mechanical-ventilator](Observation-example-nonpatient-mechanical-ventilator.md),[Procedure/done-example](Procedure-done-example.md),[Procedure/example](Procedure-example.md),[Procedure/negation-example](Procedure-negation-example.md),[Procedure/negation-with-code-example](Procedure-negation-with-code-example.md),[QICoreAdverseEvent](StructureDefinition-qicore-adverseevent.md),[QICoreBodyStructure](StructureDefinition-qicore-bodystructure.md),[QICoreCarePlan](StructureDefinition-qicore-careplan.md),[QICoreCareTeam](StructureDefinition-qicore-careteam.md),[QICoreDeviceRequest](StructureDefinition-qicore-devicerequest.md),[QICoreDeviceUseStatement](StructureDefinition-qicore-deviceusestatement.md),[QICoreFamilyMemberHistory](StructureDefinition-qicore-familymemberhistory.md),[QICoreFlag](StructureDefinition-qicore-flag.md),[QICoreGoal](StructureDefinition-qicore-goal.md),[QICoreImmunization](StructureDefinition-qicore-immunization.md),[QICoreImmunizationEvaluation](StructureDefinition-qicore-immunizationevaluation.md),[QICoreMedicationAdministration](StructureDefinition-qicore-medicationadministration.md),[QICoreMedicationDoseType](ValueSet-qicore-medication-dose-type.md),[QICoreMedicationStatement](StructureDefinition-qicore-medicationstatement.md),[QICoreObservationBodyPosition](ValueSet-qicore-observation-body-position.md),[QICorePractitionerRole](StructureDefinition-qicore-practitionerrole.md),[QICoreServiceProhibited](StructureDefinition-qicore-serviceprohibited.md),[QICoreSubstance](StructureDefinition-qicore-substance.md),[ServiceRequest/appropriateness-example](ServiceRequest-appropriateness-example.md),[ServiceRequest/elective-example](ServiceRequest-elective-example.md),[ServiceRequest/example](ServiceRequest-example.md),[ServiceRequest/myringotomy-example](ServiceRequest-myringotomy-example.md),[ServiceRequest/negation-example](ServiceRequest-negation-example.md),[ServiceRequest/negation-example-code](ServiceRequest-negation-example-code.md),[ServiceRequest/proposal-example](ServiceRequest-proposal-example.md),[ServiceRequest/proposal-example-code](ServiceRequest-proposal-example-code.md),[ServiceRequest/servicerequested-example](ServiceRequest-servicerequested-example.md),[Task/negation-example](Task-negation-example.md),[Task/negation-with-code-example](Task-negation-with-code-example.md),[Task/rejected-example](Task-rejected-example.md)and[Task/rejected-with-code-example](Task-rejected-with-code-example.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [Adjudication Value Codes](http://terminology.hl7.org/6.5.0/CodeSystem-adjudication.html): [ClaimResponse/example](ClaimResponse-example.md) and [QICoreClaimResponse](StructureDefinition-qicore-claimresponse.md)
* [AdverseEventSeriousness](http://terminology.hl7.org/6.5.0/CodeSystem-adverse-event-seriousness.html): [AdverseEvent/example](AdverseEvent-example.md) and [QICoreAdverseEvent](StructureDefinition-qicore-adverseevent.md)
* [AdverseEventSeverity](http://terminology.hl7.org/6.5.0/CodeSystem-adverse-event-severity.html): [QICoreAdverseEvent](StructureDefinition-qicore-adverseevent.md)
* [AllergyIntolerance Clinical Status Codes](http://terminology.hl7.org/6.5.0/CodeSystem-allergyintolerance-clinical.html): [AllergyIntolerance/example](AllergyIntolerance-example.md) and [AllergyIntolerance/example-refuted](AllergyIntolerance-example-refuted.md)
* [AllergyIntolerance Verification Status](http://terminology.hl7.org/6.5.0/CodeSystem-allergyintolerance-verification.html): [AllergyIntolerance/example](AllergyIntolerance-example.md), [AllergyIntolerance/example-refuted](AllergyIntolerance-example-refuted.md) and [QICoreAllergyIntolerance](StructureDefinition-qicore-allergyintolerance.md)
* [Claim Type Codes](http://terminology.hl7.org/6.5.0/CodeSystem-claim-type.html): [Claim/example](Claim-example.md), [ClaimResponse/example](ClaimResponse-example.md) and [QICoreClaimResponse](StructureDefinition-qicore-claimresponse.md)
* [CommunicationCategory](http://terminology.hl7.org/6.5.0/CodeSystem-communication-category.html): [Communication/done-example](Communication-done-example.md), [Communication/example](Communication-example.md), [Communication/negation-example](Communication-negation-example.md), [CommunicationRequest/example](CommunicationRequest-example.md) and [QICoreCommunicationRequest](StructureDefinition-qicore-communicationrequest.md)
* [CommunicationNotDoneReason](http://terminology.hl7.org/6.5.0/CodeSystem-communication-not-done-reason.html): [Communication/done-example](Communication-done-example.md) and [Communication/example](Communication-example.md)
* [CommunicationTopic](http://terminology.hl7.org/6.5.0/CodeSystem-communication-topic.html): [Communication/negation-example](Communication-negation-example.md) and [QICoreCommunication](StructureDefinition-qicore-communication.md)
* [Condition Category Codes](http://terminology.hl7.org/6.5.0/CodeSystem-condition-category.html): [Condition/appendicitis-example](Condition-appendicitis-example.md), [Condition/example](Condition-example.md), [QICoreConditionEncounterDiagnosis](StructureDefinition-qicore-condition-encounter-diagnosis.md) and [QICoreConditionProblemsHealthConcerns](StructureDefinition-qicore-condition-problems-health-concerns.md)
* [Condition Clinical Status Codes](http://terminology.hl7.org/6.5.0/CodeSystem-condition-clinical.html): [Condition/appendicitis-example](Condition-appendicitis-example.md), [Condition/example](Condition-example.md) and [Condition/health-concern-example](Condition-health-concern-example.md)
* [ConditionVerificationStatus](http://terminology.hl7.org/6.5.0/CodeSystem-condition-ver-status.html): [Condition/appendicitis-example](Condition-appendicitis-example.md), [Condition/example](Condition-example.md) and [Condition/health-concern-example](Condition-health-concern-example.md)
* [Coverage Class Codes](http://terminology.hl7.org/6.5.0/CodeSystem-coverage-class.html): [QICoreCoverage](StructureDefinition-qicore-coverage.md)
* [DataAbsentReason](http://terminology.hl7.org/6.5.0/CodeSystem-data-absent-reason.html): [QICoreObservationClinicalResult](StructureDefinition-qicore-observation-clinical-result.md) and [QICoreObservationScreeningAssessment](StructureDefinition-qicore-observation-screening-assessment.md)
* [Diet](http://terminology.hl7.org/6.5.0/CodeSystem-diet.html): [NutritionOrder/example](NutritionOrder-example.md)
* [Discharge disposition](http://terminology.hl7.org/6.5.0/CodeSystem-discharge-disposition.html): [QICoreEncounter](StructureDefinition-qicore-encounter.md)
* [DoseAndRateType](http://terminology.hl7.org/6.5.0/CodeSystem-dose-rate-type.html): [MedicationDispense/cmd-example](MedicationDispense-cmd-example.md), [MedicationDispense/done-example](MedicationDispense-done-example.md)...Show 9 more,[MedicationDispense/example](MedicationDispense-example.md),[MedicationDispense/negation-example](MedicationDispense-negation-example.md),[MedicationDispense/negation-with-code-example](MedicationDispense-negation-with-code-example.md),[MedicationRequest/cmd-example](MedicationRequest-cmd-example.md),[MedicationRequest/example](MedicationRequest-example.md),[MedicationRequest/patient-reported-example](MedicationRequest-patient-reported-example.md),[MedicationRequest/patient-requester-example](MedicationRequest-patient-requester-example.md),[MedicationRequest/practitioner-ordered-example](MedicationRequest-practitioner-ordered-example.md)and[MedicationRequest/requested-example](MedicationRequest-requested-example.md)
* [Example Diagnosis Type Codes](http://terminology.hl7.org/6.5.0/CodeSystem-ex-diagnosistype.html): [QICoreClaim](StructureDefinition-qicore-claim.md)
* [Example Procedure Type Codes](http://terminology.hl7.org/6.5.0/CodeSystem-ex-procedure-type.html): [QICoreClaim](StructureDefinition-qicore-claim.md)
* [Flag Category](http://terminology.hl7.org/6.5.0/CodeSystem-flag-category.html): [Flag/example](Flag-example.md) and [QICoreFlag](StructureDefinition-qicore-flag.md)
* [Goal category](http://terminology.hl7.org/6.5.0/CodeSystem-goal-category.html): [Goal/example](Goal-example.md)
* [Goal priority](http://terminology.hl7.org/6.5.0/CodeSystem-goal-priority.html): [Goal/example](Goal-example.md)
* [Immunization Evaluation Dose Status codes](http://terminology.hl7.org/6.5.0/CodeSystem-immunization-evaluation-dose-status.html): [ImmunizationEvaluation/example](ImmunizationEvaluation-example.md) and [QICoreImmunizationEvaluation](StructureDefinition-qicore-immunizationevaluation.md)
* [LibraryType](http://terminology.hl7.org/6.5.0/CodeSystem-library-type.html): [QICore](Library-QICore-ModelInfo.md)
* [Location type](http://terminology.hl7.org/6.5.0/CodeSystem-location-physical-type.html): [South Wing, second floor](Location-example.md)
* [MedicationRequest Category Codes](http://terminology.hl7.org/6.5.0/CodeSystem-medicationrequest-category.html): [MedicationRequest/negation-example](MedicationRequest-negation-example.md), [MedicationRequest/negation-example-code](MedicationRequest-negation-example-code.md) and [QICoreMedicationRequested](StructureDefinition-qicore-medicationrequested.md)
* [Observation Category Codes](http://terminology.hl7.org/6.5.0/CodeSystem-observation-category.html): [Observation/clinical-result-heart-rate-rhythm](Observation-clinical-result-heart-rate-rhythm.md), [Observation/example](Observation-example.md)...Show 14 more,[Observation/example-births](Observation-example-births.md),[Observation/example-delivery-date-estimate](Observation-example-delivery-date-estimate.md),[Observation/example-frailty](Observation-example-frailty.md),[Observation/example-gestation](Observation-example-gestation.md),[Observation/example-obstetric-delivery](Observation-example-obstetric-delivery.md),[Observation/example-odh](Observation-example-odh.md),[Observation/example-parity](Observation-example-parity.md),[Observation/example-pregnancies](Observation-example-pregnancies.md),[Observation/example-preterm-births](Observation-example-preterm-births.md),[Observation/example-screening-assessment-10-minute-apgar-heart-rate](Observation-example-screening-assessment-10-minute-apgar-heart-rate.md),[Observation/laboratory-result-observation-example-blood-glucose](Observation-laboratory-result-observation-example-blood-glucose.md),[QICoreLaboratoryResultObservation](StructureDefinition-qicore-observation-lab.md),[QICoreObservationClinicalResult](StructureDefinition-qicore-observation-clinical-result.md)and[QICoreObservationScreeningAssessment](StructureDefinition-qicore-observation-screening-assessment.md)
* [Organization type](http://terminology.hl7.org/6.5.0/CodeSystem-organization-type.html): [HENDRICKS COUNTY HOSPITAL](Organization-example1.md), [Health Level Seven International](Organization-example.md) and [QICoreOrganization](StructureDefinition-qicore-organization.md)
* [Payee Type Codes](http://terminology.hl7.org/6.5.0/CodeSystem-payeetype.html): [Claim/example](Claim-example.md)
* [Process Priority Codes](http://terminology.hl7.org/6.5.0/CodeSystem-processpriority.html): [Claim/example](Claim-example.md)
* [Observation Reference Range Meaning Codes](http://terminology.hl7.org/6.5.0/CodeSystem-referencerange-meaning.html): [Observation/laboratory-result-observation-example-blood-glucose](Observation-laboratory-result-observation-example-blood-glucose.md)
* [SubscriberPolicyholder Relationship Codes](http://terminology.hl7.org/6.5.0/CodeSystem-subscriber-relationship.html): [Coverage/example](Coverage-example.md) and [Coverage/example-new](Coverage-example-new.md)
* [Substance Category Codes](http://terminology.hl7.org/6.5.0/CodeSystem-substance-category.html): [Substance/example](Substance-example.md)
* [diagnosticServiceSectionId](http://terminology.hl7.org/6.5.0/CodeSystem-v2-0074.html): [DiagnosticReport/example](DiagnosticReport-example.md) and [QICoreDiagnosticReportLab](StructureDefinition-qicore-diagnosticreport-lab.md)
* [contactRole2](http://terminology.hl7.org/6.5.0/CodeSystem-v2-0131.html): [Patient/example](Patient-example.md), [Patient/example-2](Patient-example-2.md) and [RelatedPerson/example](RelatedPerson-example.md)
* [identifierType](http://terminology.hl7.org/6.5.0/CodeSystem-v2-0203.html): [Coverage/example](Coverage-example.md), [Coverage/example-new](Coverage-example-new.md)...Show 5 more,[Device/example](Device-example.md),[Patient/example](Patient-example.md),[Patient/example-2](Patient-example-2.md),[Patient/infant-example](Patient-infant-example.md)and[QICoreCoverage](StructureDefinition-qicore-coverage.md)
* [degreeLicenseCertificate](http://terminology.hl7.org/6.5.0/CodeSystem-v2-0360.html): [Practitioner/example](Practitioner-example.md)
* [providerRole](http://terminology.hl7.org/6.5.0/CodeSystem-v2-0443.html): [Immunization/done-example](Immunization-done-example.md) and [Immunization/example](Immunization-example.md)
* [ActCode](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActCode.html): [Encounter/encounter-ed-example](Encounter-encounter-ed-example.md), [Encounter/example](Encounter-example.md), [QICoreEncounter](StructureDefinition-qicore-encounter.md) and [QICoreMedicationDispense](StructureDefinition-qicore-medicationdispense.md)
* [ActReason](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActReason.html): [QICoreImmunization](StructureDefinition-qicore-immunization.md)
* [ActSite](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ActSite.html): [Immunization/done-example](Immunization-done-example.md) and [Immunization/example](Immunization-example.md)
* [ObservationInterpretation](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ObservationInterpretation.html): [QICoreLaboratoryResultObservation](StructureDefinition-qicore-observation-lab.md), [QICoreNonPatientObservation](StructureDefinition-qicore-nonpatient-observation.md), [QICoreObservationScreeningAssessment](StructureDefinition-qicore-observation-screening-assessment.md) and [QICoreSimpleObservation](StructureDefinition-qicore-simple-observation.md)
* [ParticipationFunction](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ParticipationFunction.html): [CareTeam/example](CareTeam-example.md), [QICoreCareTeam](StructureDefinition-qicore-careteam.md) and [QICorePractitionerRole](StructureDefinition-qicore-practitionerrole.md)
* [ParticipationMode](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ParticipationMode.html): [Communication/done-example](Communication-done-example.md), [Communication/example](Communication-example.md), [Communication/negation-example](Communication-negation-example.md) and [CommunicationRequest/example](CommunicationRequest-example.md)
* [RoleCode](http://terminology.hl7.org/6.5.0/CodeSystem-v3-RoleCode.html): [FamilyMemberHistory/example](FamilyMemberHistory-example.md), [QICoreFamilyMemberHistory](StructureDefinition-qicore-familymemberhistory.md) and [South Wing, second floor](Location-example.md)
* [RouteOfAdministration](http://terminology.hl7.org/6.5.0/CodeSystem-v3-RouteOfAdministration.html): [Immunization/done-example](Immunization-done-example.md) and [Immunization/example](Immunization-example.md)
* [Substance Admin Substitution](http://terminology.hl7.org/6.5.0/CodeSystem-v3-substanceAdminSubstitution.html): [MedicationDispense/done-example](MedicationDispense-done-example.md) and [MedicationDispense/example](MedicationDispense-example.md)


* Used by permission of HL7 International, all rights reserved Creative Commons License

* [US Core CarePlan Category Extension Codes](http://hl7.org/fhir/us/core/STU7/CodeSystem-careplan-category.html): [CarePlan/example](CarePlan-example.md) and [QICoreCarePlan](StructureDefinition-qicore-careplan.md)
* [US Core Condition Category Extension Codes](http://hl7.org/fhir/us/core/STU7/CodeSystem-condition-category.html): [Condition/health-concern-example](Condition-health-concern-example.md)
* [US Core Category](http://hl7.org/fhir/us/core/STU7/CodeSystem-us-core-category.html): [QICoreObservationScreeningAssessment](StructureDefinition-qicore-observation-screening-assessment.md)


* Using RxNorm codes of type SAB=RXNORM as this specification describes does not require a UMLS license. Access to the full set of RxNorm definitions, and/or additional use of other RxNorm structures and information requires a UMLS license. The use of RxNorm in this specification is pursuant to HL7's status as a licensee of the NLM UMLS. HL7's license does not convey the right to use RxNorm to any users of this specification; implementers must acquire a license to use RxNorm in their own right.

* [RxNorm](http://terminology.hl7.org/6.5.0/CodeSystem-v3-rxNorm.html): [AllergyIntolerance/example](AllergyIntolerance-example.md), [Medication/example](Medication-example.md)...Show 6 more,[MedicationAdministration/negation-with-code-example](MedicationAdministration-negation-with-code-example.md),[MedicationDispense/negation-with-code-example](MedicationDispense-negation-with-code-example.md),[QICoreMedicationAdministration](StructureDefinition-qicore-medicationadministration.md),[QICoreMedicationDispense](StructureDefinition-qicore-medicationdispense.md),[QICoreMedicationRequest](StructureDefinition-qicore-medicationrequest.md)and[QICoreMedicationStatement](StructureDefinition-qicore-medicationstatement.md)


