# Positive Request Status - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Positive Request Status**

## ValueSet: Positive Request Status 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/qicore/ValueSet/qicore-positive-request-status | *Version*:7.0.2 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 4 | *Computable Name*:PositiveRequestStatus |

 
This value set defines the set of codes that indicate a positive request status (i.e. codes that indicate an activity is proposed, planned, or ordered). 

 
This value set was defined to support the set of request statuses in FHIR that indicate a positive status (i.e. all the codes from the http://hl7.org/fhir/request-status code system that indicate an activity is proposed, planned, or ordered). 

 **References** 

* [QICore Service Prohibited](StructureDefinition-qicore-serviceprohibited.md)
* [QICore ServiceRequested](StructureDefinition-qicore-servicerequested.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "qicore-positive-request-status",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/ValueSet/qicore-positive-request-status",
  "version" : "7.0.2",
  "name" : "PositiveRequestStatus",
  "title" : "Positive Request Status",
  "status" : "active",
  "experimental" : false,
  "date" : "2018-12-05T00:00:00+00:00",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "This value set defines the set of codes that indicate a positive request status (i.e. codes that indicate an activity is proposed, planned, or ordered).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "purpose" : "This value set was defined to support the set of request statuses in FHIR that indicate a positive status (i.e. all the codes from the http://hl7.org/fhir/request-status code system that indicate an activity is proposed, planned, or ordered).",
  "compose" : {
    "include" : [
      {
        "system" : "http://hl7.org/fhir/request-status",
        "concept" : [
          {
            "code" : "draft",
            "display" : "Draft"
          },
          {
            "code" : "active",
            "display" : "Active"
          },
          {
            "code" : "on-hold",
            "display" : "On Hold"
          },
          {
            "code" : "revoked",
            "display" : "Revoked"
          },
          {
            "code" : "completed",
            "display" : "Completed"
          }
        ]
      }
    ]
  }
}

```
