# QICore Negation Reason Codes - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **QICore Negation Reason Codes**

## ValueSet: QICore Negation Reason Codes 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/qicore/ValueSet/qicore-negation-reason | *Version*:7.0.2 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 4 | *Computable Name*:NegationReasonCodes |

 
This value set defines the set of codes that can be used to indicate the reason an action was not taken 

 
This value set was defined to support identifying any of the possible negation reason codes as part of QICore profiles. The value set is composed of the codes from[Medical Reason Not Done SCT](http://cts.nlm.nih.gov/fhir/2.16.840.1.113883.3.526.3.1007),[Patient Reason Not Done SCT](http://cts.nlm.nih.gov/fhir/2.16.840.1.113883.3.526.3.1008), and[System Reason](http://cts.nlm.nih.gov/fhir/2.16.840.1.113883.3.526.3.1009)as defined and available in the Value Set Authority Center. This value set was defined to support identifying any of the possible negation reason codes as part of QICore profiles. The value set exists to support measure developers need to reference medical, patient, and system reasons for processes not performed and it is a grouping of VSAC value sets. Therefore, retain binding to the QI-Core value set in the profiles that use the extension. It only exists to support bindings to capture a reason for negative. 

 **References** 

* [QICore Communication Not Done](StructureDefinition-qicore-communicationnotdone.md)
* [QICore Device Prohibited](StructureDefinition-qicore-deviceprohibited.md)
* [QICore Immunization Not Done](StructureDefinition-qicore-immunizationnotdone.md)
* [QICore MedicationAdministration Not Done](StructureDefinition-qicore-medicationadministrationnotdone.md)
* [QICore MedicationDispense Declined](StructureDefinition-qicore-medicationdispensedeclined.md)
* [QICore Medication Prohibited](StructureDefinition-qicore-medicationprohibited.md)
* [QICore Procedure Not Done](StructureDefinition-qicore-procedurenotdone.md)
* [QICore Task Rejected](StructureDefinition-qicore-taskrejected.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "qicore-negation-reason",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/ValueSet/qicore-negation-reason",
  "version" : "7.0.2",
  "name" : "NegationReasonCodes",
  "title" : "QICore Negation Reason Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2018-12-05",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "This value set defines the set of codes that can be used to indicate the reason an action was not taken",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "purpose" : "This value set was defined to support identifying any of the possible negation reason codes as part of QICore profiles. The value set is composed of the codes from [Medical Reason Not Done SCT](http://cts.nlm.nih.gov/fhir/2.16.840.1.113883.3.526.3.1007), [Patient Reason Not Done SCT](http://cts.nlm.nih.gov/fhir/2.16.840.1.113883.3.526.3.1008), and [System Reason](http://cts.nlm.nih.gov/fhir/2.16.840.1.113883.3.526.3.1009) as defined and available in the Value Set Authority Center. This value set was defined to support identifying any of the possible negation reason codes as part of QICore profiles. The value set exists to support measure developers need to reference medical, patient, and system reasons for processes not performed and it is a grouping of VSAC value sets.  Therefore, retain binding to the QI-Core value set in the profiles that use the extension.  It only exists to support bindings to capture a reason for negative.",
  "compose" : {
    "include" : [
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.526.3.1007"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.526.3.1008"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.526.3.1009"
        ]
      }
    ]
  }
}

```
