# QICore Task - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **QICore Task**

## Resource Profile: QICore Task 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-task | *Version*:7.0.2 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 4 | *Computable Name*:QICoreTask |

 
Profile of Task for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. 

"Must Have", "QI Elements" and "primary code path" are defined in the
[QI-Core Must Support section](index.md#mustsupport-flag).

**QI Elements:**
* basedOn: (QI) Request fulfilled by this task
* executionPeriod: (QI) Start and end time of execution
* focus: (QI) What task is acting on
* intent: (QI) unknown | proposal | plan | order | original-order | reflex-order | filler-order | instance
* status: (QI) draft​ | requested​ | received​ | accepted​ | rejected | ready​ | cancelled​ | in-progress​ | on-hold​ | failed​ | completed | entered-in-error
* code: (QI) Task Type
* encounter: (QI) Healthcare event during which this task originated
* for: (QI) Beneficiary of the Task
* priority: (QI) routine | urgent | asap | stat

**Primary code path:**code

(PCPath) This element is the primary code path for this resource
[CQL Retrieve](https://cql.hl7.org/02-authorsguide.html#retrieve)

**Usage**
The Task profile defines the conformance expectations for a Task, regardless of whether it is a positive or negative statement. The TaskDone and TaskRejected profiles represent the positive and negative statements for a task.

 See the[patterns](patterns.md)page for implementation and usage patterns. 

### Examples

 

| |
| :--- |
| [Task Example](Task-example.md) |

 

**Usages:**

* Derived from this Profile: [QICore Task Done](StructureDefinition-qicore-taskdone.md)
* Examples for this Profile: [Task/example](Task-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.qicore|current/StructureDefinition/qicore-task)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-qicore-task.csv), [Excel](StructureDefinition-qicore-task.xlsx), [Schematron](StructureDefinition-qicore-task.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "qicore-task",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-primaryCodePath",
      "valueString" : "code"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isIncluded",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isRetrievable",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-label",
      "valueString" : "Task"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-task",
  "version" : "7.0.2",
  "name" : "QICoreTask",
  "title" : "QICore Task",
  "status" : "active",
  "experimental" : false,
  "date" : "2018-08-22",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Profile of Task for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Task",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Task",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Task",
        "path" : "Task",
        "constraint" : [
          {
            "key" : "tsk-1",
            "severity" : "error",
            "human" : "to indicate what, either at least one coding in the code or a codeOptions extension shall be provided",
            "expression" : "code.extension('http://hl7.org/fhir/StructureDefinition/codeOptions').exists() xor code.coding.exists()",
            "xpath" : "exists(f:extension)"
          }
        ],
        "mustSupport" : false
      },
      {
        "id" : "Task.basedOn",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Task.basedOn",
        "short" : "(QI) Request fulfilled by this task"
      },
      {
        "id" : "Task.status",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Task.status",
        "short" : "(QI) draft​ | requested​ | received​ | accepted​ | rejected | ready​ | cancelled​ | in-progress​ | on-hold​ | failed​ | completed | entered-in-error"
      },
      {
        "id" : "Task.intent",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Task.intent",
        "short" : "(QI) unknown | proposal | plan | order | original-order | reflex-order | filler-order | instance"
      },
      {
        "id" : "Task.priority",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Task.priority",
        "short" : "(QI) routine | urgent | asap | stat",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Task.code",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Task.code",
        "short" : "(QI) Task Type",
        "min" : 1,
        "max" : "1",
        "condition" : ["tsk-1"],
        "binding" : {
          "strength" : "preferred",
          "description" : "Codes to identify what the task involves. These will typically be specific to a particular workflow",
          "valueSet" : "http://hl7.org/fhir/ValueSet/task-code"
        }
      },
      {
        "id" : "Task.code.extension:codeOptions",
        "path" : "Task.code.extension",
        "sliceName" : "codeOptions",
        "short" : "(QI) Url of a value set of candidate tasks",
        "definition" : "A logical reference (e.g. a reference to ValueSet.url) to a value set/version that identifies a set of possible coded values representing the task.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/codeOptions|7.0.2"]
          }
        ],
        "condition" : ["tsk-1"]
      },
      {
        "id" : "Task.focus",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Task.focus",
        "short" : "(QI) What task is acting on",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Resource"]
          }
        ],
        "mustSupport" : false
      },
      {
        "id" : "Task.for",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Task.for",
        "short" : "(QI) Beneficiary of the Task",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient"
            ]
          }
        ],
        "mustSupport" : false
      },
      {
        "id" : "Task.encounter",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Task.encounter",
        "short" : "(QI) Healthcare event during which this task originated",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-encounter"
            ]
          }
        ],
        "mustSupport" : false
      },
      {
        "id" : "Task.executionPeriod",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Task.executionPeriod",
        "short" : "(QI) Start and end time of execution",
        "min" : 1,
        "max" : "1",
        "mustSupport" : false
      },
      {
        "id" : "Task.reasonCode",
        "path" : "Task.reasonCode",
        "mustSupport" : false
      }
    ]
  }
}

```
