# QICore Simple Observation - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **QICore Simple Observation**

## Resource Profile: QICore Simple Observation 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-simple-observation | *Version*:7.0.2 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 4 | *Computable Name*:QICoreSimpleObservation |

 
Profile of Simple Observation for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. 

"Must Have", "QI Elements" and "primary code path" are defined in the
[QI-Core Must Support section](index.md#mustsupport-flag).

**Must Have:**
* subject: (QI) Who and/or what the observation is about
* category: (QI) Classification of type of observation
* code: (QI) Type of observation (code / type)
* status: (QI) registered | prliminary | final | amended | corrected | cancelled | entered-in-error | unknown

**QI Elements:**
* performer: (QI) Who is responsible for the observation
* derivedFrom: (QI) US Core Profiles or other resource the observation is made from
* value[x]: (QI) Actual result
* effective[x]: (QI) Clinically relevant time/time-period for observation
* interpretation: (QI) High, low, normal, etc.

**Primary code path:**code

(PCPath) This element is the primary code path for this resource
[CQL Retrieve](https://cql.hl7.org/02-authorsguide.html#retrieve)

**Usage**
Note: US-Core and QI-Core define precise profiles for specific observations, as well as a general profile for LOINC-code laboratory result observations. QI-Core inherits these US Core specific profiles directly and individually profiles others. When creating expressions for eCQMs or CDS artifacts with QI-Core for the following clinical data, use the applicable profile directly rather than the generic QICore Observation profile:
* [US Core Pediatric Head Occipital-frontal Circumference Percentile Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-head-occipital-frontal-circumference-percentile.html)
* [US Core Blood Pressure Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-blood-pressure.html)
* [US Core Average Blood Pressure Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-average-blood-pressure.html)
* [US Core BMI Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-bmi.html)
* [US Core Body Height Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-body-height.html)
* [US Core Care Experience Preference](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-care-experience-preference.html)
* [US Core Body Temperature Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-body-temperature.html)
* [US Core Body Weight Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-body-weight.html)
* [US Core Head Circumference Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-head-circumference.html)
* [US Core Heart Rate Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-heart-rate.html)
* [US Core Pediatric BMI for Age Observation Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-pediatric-bmi-for-age.html)
* [US Core Pediatric Weight for Height Observation Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-pediatric-weight-for-height.html)
* [US Core Pulse Oximetry Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-pulse-oximetry.html)
* [US Core Respiratory Rate Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-respiratory-rate.html)
* [US Core Smoking Status Observation Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-smokingstatus.html)
* [US Core Observation Sexual Orientation Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-observation-sexual-orientation.html)
* [US Core Observation Pregnancy Intent Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-observation-pregnancyintent.html)
* [US Core Observation Pregnancy Status Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-observation-pregnancystatus.html)
* [QICore Observation Clinical Result](StructureDefinition-qicore-observation-clinical-result.md)
* [QICore Laboratory Result Observation](StructureDefinition-qicore-observation-lab.md)
* [QICore Observation Screening Assessment](StructureDefinition-qicore-observation-screening-assessment.md)
* [US Core Treatment Intervention Preference Profile](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-treatment-intervention-preference.html)

 As stated in the Home Page, QI-Core derives from US Core and so the requirements on “MustSupport” defined in US Core must be respected. QI-Core further [describes and constrains the “MustSupport” functionality](index.md#mustsupport-flag).

The following example illustrates the use of the observation profile.

```
define "Pap Test with Results":
  [Observation: "Pap Test"] PapTest
    where PapTest.value is not null
      and PapTest.status in { 'final', 'amended', 'corrected', 'preliminary' }

```

 See the[patterns](patterns.md)page for implementation and usage patterns. 

### Examples

 

| |
| :--- |
| [Example of a Frailty Observation](Observation-example-frailty.md) |
| [Example of a Gestation Age at Birth Observation](Observation-example-gestation.md) |
| [Example of a Date and time of obstetric delivery observation](Observation-example-obstetric-delivery.md) |
| [Example of an estimated delivery date observation](Observation-example-delivery-date-estimate.md) |
| [Example of a number of preterm births observation](Observation-example-preterm-births.md) |
| [Example of a number of term births observation](Observation-example-births.md) |
| [Example of a number of parity observation](Observation-example-parity.md) |
| [Example of a number of pregnancies observation](Observation-example-pregnancies.md) |

 

**Usages:**

* Refer to this Profile: [QICore AdverseEvent](StructureDefinition-qicore-adverseevent.md), [QICore Encounter](StructureDefinition-qicore-encounter.md), [QICore ImagingStudy](StructureDefinition-qicore-imagingstudy.md), [QICore ImmunizationRecommendation](StructureDefinition-qicore-immunizationrecommendation.md)...Show 4 more,[QICore MedicationRequest](StructureDefinition-qicore-medicationrequest.md),[QICore NonPatient Observation](StructureDefinition-qicore-nonpatient-observation.md),[QICore ServiceRequest](StructureDefinition-qicore-servicerequest.md)and[QICore Simple Observation](StructureDefinition-qicore-simple-observation.md)
* Examples for this Profile: [Observation/example-births](Observation-example-births.md), [Observation/example-delivery-date-estimate](Observation-example-delivery-date-estimate.md), [Observation/example-frailty](Observation-example-frailty.md), [Observation/example-gestation](Observation-example-gestation.md)...Show 6 more,[Observation/example-obstetric-delivery](Observation-example-obstetric-delivery.md),[Observation/example-odh](Observation-example-odh.md),[Observation/example-parity](Observation-example-parity.md),[Observation/example-pregnancies](Observation-example-pregnancies.md),[Observation/example-preterm-births](Observation-example-preterm-births.md)and[Observation/example](Observation-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.qicore|current/StructureDefinition/qicore-simple-observation)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-qicore-simple-observation.csv), [Excel](StructureDefinition-qicore-simple-observation.xlsx), [Schematron](StructureDefinition-qicore-simple-observation.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "qicore-simple-observation",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-primaryCodePath",
      "valueString" : "code"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isIncluded",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isRetrievable",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-label",
      "valueString" : "SimpleObservation"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-simple-observation",
  "version" : "7.0.2",
  "name" : "QICoreSimpleObservation",
  "title" : "QICore Simple Observation",
  "status" : "active",
  "experimental" : false,
  "date" : "2018-08-22",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Profile of Simple Observation for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-simple-observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "alias" : ["Vital Signs", "Measurement", "Results", "Tests"],
        "mustSupport" : false
      },
      {
        "id" : "Observation.implicitRules",
        "path" : "Observation.implicitRules",
        "short" : "A set of rules under which this content was created",
        "definition" : "A reference to a set of rules that were followed when the resource was constructed, and which must be understood when processing the content. Often, this is a reference to an implementation guide that defines the special rules along with other profiles etc.",
        "comment" : "Asserting this rule set restricts the content to be only understood by a limited set of trading partners. This inherently limits the usefulness of the data in the long term. However, the existing health eco-system is highly fractured, and not yet ready to define, collect, and exchange data in a generally computable sense. Wherever possible, implementers and/or specification writers should avoid using this element. Often, when used, the URL is a reference to an implementation guide that defines these special rules as part of it's narrative along with other profiles, value sets, etc.",
        "isModifier" : true,
        "isModifierReason" : "This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies it's meaning or interpretation",
        "isSummary" : true
      },
      {
        "id" : "Observation.modifierExtension",
        "path" : "Observation.modifierExtension",
        "short" : "Extensions that cannot be ignored",
        "definition" : "May be used to represent additional information that is not part of the basic definition of the resource and that modifies the understanding of the element that contains it and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer is allowed to define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions.\n\nModifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).",
        "comment" : "There can be no stigma associated with the use of extensions by any application, project, or standard - regardless of the institution or jurisdiction that uses or defines the extensions.  The use of extensions is what allows the FHIR specification to retain a core level of simplicity for everyone.",
        "requirements" : "Modifier extensions allow for extensions that *cannot* be safely ignored to be clearly distinguished from the vast majority of extensions which can be safely ignored.  This promotes interoperability by eliminating the need for implementers to prohibit the presence of extensions. For further information, see the [definition of modifier extensions](http://hl7.org/fhir/R4/extensibility.html#modifierExtension).",
        "alias" : ["extensions", "user content"],
        "min" : 0,
        "max" : "*",
        "base" : {
          "path" : "DomainResource.modifierExtension",
          "min" : 0,
          "max" : "*"
        },
        "type" : [
          {
            "code" : "Extension"
          }
        ],
        "isModifier" : true,
        "isModifierReason" : "Modifier extensions are expected to modify the meaning or interpretation of the resource that contains them",
        "isSummary" : false
      },
      {
        "id" : "Observation.partOf",
        "path" : "Observation.partOf",
        "short" : "Part of referenced event"
      },
      {
        "id" : "Observation.status",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Observation.status",
        "short" : "(QI) registered | prliminary | final | amended | corrected | cancelled | entered-in-error | unknown"
      },
      {
        "id" : "Observation.category",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Observation.category",
        "short" : "(QI) Classification of type of observation",
        "min" : 1,
        "max" : "*"
      },
      {
        "id" : "Observation.code",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Observation.code",
        "short" : "(QI) Type of observation (code / type)",
        "binding" : {
          "strength" : "preferred",
          "description" : "This value set specifies the type of observation",
          "valueSet" : "http://hl7.org/fhir/ValueSet/observation-codes"
        }
      },
      {
        "id" : "Observation.subject",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Observation.subject",
        "short" : "(QI) Who and/or what the observation is about",
        "definition" : "The patient, or group of patients, location, or device this observation is about and into whose record the observation is placed. If the actual focus of the observation is different from the subject (or a sample of, part, or region of the subject), the `focus` element or the `code` itself specifies the actual focus of the observation.",
        "comment" : "One would expect this element to be a cardinality of 1..1. The only circumstance in which the subject can be missing is when the observation is made by a device that does not know the patient. In this case, the observation SHALL be matched to a patient through some context/channel matching technique, and at this point, the observation should be updated.",
        "requirements" : "Observations have no value if you don't know who or what they're about.",
        "min" : 1,
        "max" : "1",
        "base" : {
          "path" : "Observation.subject",
          "min" : 0,
          "max" : "1"
        },
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient"
            ]
          }
        ],
        "isModifier" : false,
        "isSummary" : true
      },
      {
        "id" : "Observation.effective[x]",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Observation.effective[x]",
        "short" : "(QI) Clinically relevant time/time-period for observation",
        "definition" : "The time or time-period the observed value is asserted as being true. For biological subjects - e.g. human patients - this is usually called the \"physiologically relevant time\". This is usually either the time of the procedure or of specimen collection, but very often the source of the date/time is not known, only the date/time itself.",
        "comment" : "At least a date should be present unless this observation is a historical report.  For recording imprecise or \"fuzzy\" times (For example, a blood glucose measurement taken \"after breakfast\") use the [Timing](http://hl7.org/fhir/R4/datatypes.html#timing) datatype which allow the measurement to be tied to regular life events.",
        "requirements" : "Knowing when an observation was deemed true is important to its relevance as well as determining trends.",
        "alias" : ["Occurrence"],
        "min" : 0,
        "max" : "1",
        "base" : {
          "path" : "Observation.effective[x]",
          "min" : 0,
          "max" : "1"
        },
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                "valueBoolean" : true
              }
            ],
            "code" : "dateTime"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                "valueBoolean" : true
              }
            ],
            "code" : "Period"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                "valueBoolean" : true
              }
            ],
            "code" : "Timing"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                "valueBoolean" : true
              }
            ],
            "code" : "instant"
          }
        ],
        "isModifier" : false,
        "isSummary" : true
      },
      {
        "id" : "Observation.performer",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Observation.performer",
        "short" : "(QI) Who is responsible for the observation",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-practitioner",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-organization",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-practitionerrole",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-careteam",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-relatedperson"
            ]
          }
        ]
      },
      {
        "id" : "Observation.value[x]",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Observation.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "(QI) Actual result",
        "definition" : "The information determined as a result of making the observation, if the information has a simple value.",
        "comment" : "An observation may have; 1)  a single value here, 2)  both a value and a set of related or component values,  or 3)  only a set of related or component values. If a value is present, the datatype for this element should be determined by Observation.code.  A CodeableConcept with just a text would be used instead of a string if the field was usually coded, or if the type associated with the Observation.code defines a coded value.  For additional guidance, see the [Notes section](http://hl7.org/fhir/R4/observation.html#notes) below.",
        "requirements" : "An observation exists to have a value, though it might not if it is in error, or if it represents a group of observations.",
        "min" : 0,
        "max" : "1",
        "base" : {
          "path" : "Observation.value[x]",
          "min" : 0,
          "max" : "1"
        },
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                "valueBoolean" : true
              }
            ],
            "code" : "Quantity"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                "valueBoolean" : true
              }
            ],
            "code" : "CodeableConcept"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                "valueBoolean" : true
              }
            ],
            "code" : "string"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                "valueBoolean" : true
              }
            ],
            "code" : "boolean"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                "valueBoolean" : true
              }
            ],
            "code" : "integer"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                "valueBoolean" : true
              }
            ],
            "code" : "Range"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                "valueBoolean" : true
              }
            ],
            "code" : "Ratio"
          },
          {
            "code" : "SampledData"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                "valueBoolean" : true
              }
            ],
            "code" : "time"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                "valueBoolean" : true
              }
            ],
            "code" : "dateTime"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                "valueBoolean" : true
              }
            ],
            "code" : "Period"
          }
        ],
        "isModifier" : false,
        "isSummary" : true
      },
      {
        "id" : "Observation.interpretation",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Observation.interpretation",
        "short" : "(QI) High, low, normal, etc.",
        "definition" : "A categorical assessment of an observation value.  For example, high, low, normal.",
        "comment" : "Historically used for laboratory results (known as 'abnormal flag' ),  its use extends to other use cases where coded interpretations  are relevant.  Often reported as one or more simple compact codes this element is often placed adjacent to the result value in reports and flow sheets to signal the meaning/normalcy status of the result.",
        "requirements" : "For some results, particularly numeric results, an interpretation is necessary to fully understand the significance of a result.",
        "alias" : ["Abnormal Flag"],
        "min" : 0,
        "max" : "*",
        "base" : {
          "path" : "Observation.interpretation",
          "min" : 0,
          "max" : "*"
        },
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "isModifier" : false,
        "isSummary" : false,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ObservationInterpretation"
            }
          ],
          "strength" : "extensible",
          "description" : "Codes identifying interpretations of observations.",
          "valueSet" : "http://hl7.org/fhir/ValueSet/observation-interpretation"
        }
      },
      {
        "id" : "Observation.derivedFrom",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Observation.derivedFrom",
        "short" : "(QI) US Core Profiles or other resource the observation is made from",
        "definition" : "US Core Observations, DocumentReference, QuestionnaireResponse or other resource from which this observation value is derived.",
        "comment" : "All the reference choices that are listed in this element can represent clinical observations and other measurements that may be the source for a derived value.  The most common reference will be another Observation.  For a discussion on the ways Observations can assembled in groups together, see [Notes](http://hl7.org/fhir/R4/observation.html#obsgrouping) below.",
        "min" : 0,
        "max" : "*",
        "base" : {
          "path" : "Observation.derivedFrom",
          "min" : 0,
          "max" : "*"
        },
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-simple-observation",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-questionnaireresponse",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-imagingstudy",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-documentreference",
              "http://hl7.org/fhir/StructureDefinition/Media",
              "http://hl7.org/fhir/StructureDefinition/MolecularSequence"
            ]
          }
        ],
        "mustSupport" : false,
        "isModifier" : false,
        "isSummary" : true
      }
    ]
  }
}

```
