# QICore ServiceRequest - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **QICore ServiceRequest**

## Resource Profile: QICore ServiceRequest 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-servicerequest | *Version*:7.0.2 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 4 | *Computable Name*:QICoreServiceRequest |

 
Profile of ServiceRequest for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. 

"Must Have", "QI Elements" and "primary code path" are defined in the
[QI-Core Must Support section](index.md#mustsupport-flag).

**Must Have:**
* status: (QI) draft | active | on-hold | revoked | completed | entered-in-error | unknown
* intent: (QI) proposal | plan | directive | order | original-order | reflex-order | filler-order | instance-order | option
* code: (QI) What is being requested/ordered
* subject: (QI) Individual or Entity the service is ordered for

**QI Elements:**
* code.extension(codeOptions): (QI) Url of a value set of candidate services
* reasonCode: (QI) Explanation/Justification for procedure or service
* occurrence[x]: (QI) When service should occur
* authoredOn: (QI) Date request signed
* doNotPerform: (QI) True if service/procedure should not be performed
* reasonReference: (QI) Explanation/Justification for service or service

**Primary code path:**code

(PCPath) This element is the primary code path for this resource
[CQL Retrieve](https://cql.hl7.org/02-authorsguide.html#retrieve)

### Guidance

 Reference Guidance for use of the Service Request profile can be found[here.](http://hl7.org/fhir/us/core/STU7/StructureDefinition-us-core-servicerequest.html#mandatory-and-must-support-data-elements)
* See the [Social Determinants of Health (SDOH)](https://hl7.org/fhir/us/core/sdoh.html) Guidance Page for more information when exchanging Social Determinants of Health (SDOH) Service Requests.
* The `ServiceRequest.category` binding must support at a minimum the [US Core ServiceRequest Category Codes](http://hl7.org/fhir/us/core/STU7/ValueSet-us-core-servicerequest-category.html). However, this valueset can be treated as [extensible](http://hl7.org/fhir/R4/terminologies.html#extensible) and other category codes can be used instead.
* The `ServiceRequest.code` valueset is broad to accommodate a wide variety of use cases and should be constrained to a subset for a particular use case or domain. (for example, LOINC for laboratory orders.)
* The `ServiceRequest.subject` is Must Support with Must Support reference to QI-Core Patient
 

**Usage**
The ServiceRequest profile defines the conformance expectations for a ServiceRequest, regardless of whether it is a positive or negative statement. The ServiceRequested and ServiceNotRequested profiles represent the positive and negative statements for a service request. 

To create an expression indicating the existence of a service request, use the profile [QICoreServiceRequested](StructureDefinition-qicore-servicerequested.md); to specifically request information that a ServiceRequest intentionally did not occur for a medical, patient or system reason, use the profile [QICoreServiceProhibited](StructureDefinition-qicore-serviceprohibited.md).

The following example illustrates the use of the ServiceRequest profile:

```
define "Intermittent Pneumatic Compression Devices Ordered":
  ["ServiceRequest": "Application of intermittent pneumatic compression devices (IPC)"] DeviceOrdered
    where DeviceOrdered.status in { 'active', 'completed', 'on-hold' }
      and DeviceOrdered.intent = 'order'
      and DeviceOrdered.doNotPerform is not true
```

 See the[patterns](patterns.md)page for implementation and usage patterns. 

### Examples

 

| |
| :--- |
| [Request for Appendectomy Example](ServiceRequest-example.md) |
| [Request for Myringotomy Procedure Example](ServiceRequest-myringotomy-example.md) |

 

**Usages:**

* Derived from this Profile: [QICore Service Prohibited](StructureDefinition-qicore-serviceprohibited.md) and [QICore ServiceRequested](StructureDefinition-qicore-servicerequested.md)
* Refer to this Profile: [QICore Claim](StructureDefinition-qicore-claim.md), [QICore DiagnosticReport Profile for Laboratory Results Reporting](StructureDefinition-qicore-diagnosticreport-lab.md), [QICore ImagingStudy](StructureDefinition-qicore-imagingstudy.md) and [QICore Procedure](StructureDefinition-qicore-procedure.md)
* Examples for this Profile: [ServiceRequest/example](ServiceRequest-example.md) and [ServiceRequest/myringotomy-example](ServiceRequest-myringotomy-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.qicore|current/StructureDefinition/qicore-servicerequest)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-qicore-servicerequest.csv), [Excel](StructureDefinition-qicore-servicerequest.xlsx), [Schematron](StructureDefinition-qicore-servicerequest.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "qicore-servicerequest",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-primaryCodePath",
      "valueString" : "code"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isIncluded",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isRetrievable",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-label",
      "valueString" : "ServiceRequest"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-servicerequest",
  "version" : "7.0.2",
  "name" : "QICoreServiceRequest",
  "title" : "QICore ServiceRequest",
  "status" : "active",
  "experimental" : false,
  "date" : "2018-08-22",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Profile of ServiceRequest for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "quick",
      "uri" : "http://siframework.org/cqf",
      "name" : "Quality Improvement and Clinical Knowledge (QUICK)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "ServiceRequest",
  "baseDefinition" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-servicerequest",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ServiceRequest",
        "path" : "ServiceRequest",
        "constraint" : [
          {
            "key" : "srq-1",
            "severity" : "error",
            "human" : "To indicate what service, either at least one coding in the code or a codeOptions extension shall be provided",
            "expression" : "code.extension('http://hl7.org/fhir/StructureDefinition/codeOptions').exists() xor code.coding.exists()"
          }
        ]
      },
      {
        "id" : "ServiceRequest.status",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "ServiceRequest.status",
        "short" : "(QI) draft | active | on-hold | revoked | completed | entered-in-error | unknown"
      },
      {
        "id" : "ServiceRequest.intent",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "ServiceRequest.intent",
        "short" : "(QI) proposal | plan | directive | order | original-order | reflex-order | filler-order | instance-order | option"
      },
      {
        "id" : "ServiceRequest.doNotPerform",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "ServiceRequest.doNotPerform",
        "short" : "(QI) True if service/procedure should not be performed",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "boolean"
          }
        ]
      },
      {
        "id" : "ServiceRequest.code",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "ServiceRequest.code",
        "short" : "(QI) What is being requested/ordered",
        "condition" : ["srq-1"]
      },
      {
        "id" : "ServiceRequest.code.extension:codeOptions",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "ServiceRequest.code.extension",
        "sliceName" : "codeOptions",
        "short" : "(QI) Url of a value set of candidate services",
        "definition" : "A logical reference (e.g. a reference to ValueSet.url) to a value set/version that identifies a set of possible coded values representing the service.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/codeOptions|7.0.2"]
          }
        ],
        "condition" : ["srq-1"]
      },
      {
        "id" : "ServiceRequest.subject",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "ServiceRequest.subject",
        "short" : "(QI) Individual or Entity the service is ordered for",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient"
            ]
          }
        ]
      },
      {
        "id" : "ServiceRequest.encounter",
        "path" : "ServiceRequest.encounter",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-encounter"
            ]
          }
        ]
      },
      {
        "id" : "ServiceRequest.occurrence[x]",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "ServiceRequest.occurrence[x]",
        "short" : "(QI) When service should occur",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                "valueBoolean" : true
              }
            ],
            "code" : "dateTime"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                "valueBoolean" : true
              }
            ],
            "code" : "Period"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                "valueBoolean" : true
              }
            ],
            "code" : "Timing"
          }
        ]
      },
      {
        "id" : "ServiceRequest.authoredOn",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "ServiceRequest.authoredOn",
        "short" : "(QI) Date request signed",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ServiceRequest.requester",
        "path" : "ServiceRequest.requester",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-practitioner",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-practitionerrole",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-organization",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-relatedperson",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-device",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-implantable-device"
            ],
            "_targetProfile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                    "valueBoolean" : false
                  }
                ]
              },
              null
            ]
          }
        ]
      },
      {
        "id" : "ServiceRequest.reasonCode",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "ServiceRequest.reasonCode",
        "short" : "(QI) Explanation/Justification for procedure or service"
      },
      {
        "id" : "ServiceRequest.reasonReference",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "ServiceRequest.reasonReference",
        "short" : "(QI) Explanation/Justification for service or service",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-condition-encounter-diagnosis",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-condition-problems-health-concerns",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-diagnosticreport-note",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-documentreference",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-simple-observation"
            ],
            "_targetProfile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                    "valueBoolean" : true
                  }
                ]
              },
              null,
              null,
              null
            ]
          }
        ]
      }
    ]
  }
}

```
