# QICore Procedure - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **QICore Procedure**

## Resource Profile: QICore Procedure 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-procedure | *Version*:7.0.2 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 4 | *Computable Name*:QICoreProcedure |

 
Profile of Procedure for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. 

"Must Have", "QI Elements" and "primary code path" are defined in the
[QI-Core Must Support section](index.md#mustsupport-flag).

**Must Have:**
* subject: (QI) Who the procedure was performed on
* code: (QI) What procedure
* status: (QI) preparation | in-progress | not-done | on-hold | stopped | completed | entered-in-error | unknown

**QI Elements:**
* performed[x]: (QI) When the procedure was performed
* reasonCode: (QI) Coded reason procedure performed
* reasonReference: (QI) The justification that the procedure was performed
* basedOn: (QI) A request for this procedure
* code.extension(codeOptions): (QI) Url of a value set of candidate procedures
* extension(recorded): (QI) When the procedure was first captured in the subject's record

**Primary code path:**code

(PCPath) This element is the primary code path for this resource
[CQL Retrieve](https://cql.hl7.org/02-authorsguide.html#retrieve)

**Usage**
The Procedure profile defines the conformance expectations for a Procedure, regardless of whether it is a positive or negative statement. The ProcedureDone and ProcedureNotDone profiles represent the positive and negative statements for a procedure.

To create an expression indicating existence of a procedure, use the profile [QICoreProcedureDone](StructureDefinition-qicore-proceduredone.md); to specifically request information that a procedure intentionally did not occur for a medical, patient or system reason, use the profile [QICoreProcedureNotDone](StructureDefinition-qicore-procedurenotdone.md).

The following example illustrates the use of the Procedure profile:

```
define "Application of Intermittent Pneumatic Compression Devices":
  ["Procedure": "Application of Intermittent Pneumatic Compression Devices (IPC)"] DeviceApplied
    where DeviceApplied.status = 'completed'
```

 See the[patterns](patterns.md)page for implementation and usage patterns. 

### Examples

 

| |
| :--- |
| [Appendectomy Example](Procedure-example.md) |

 

**Usages:**

* Derived from this Profile: [QICore Procedure Done](StructureDefinition-qicore-proceduredone.md) and [QICore Procedure Not Done](StructureDefinition-qicore-procedurenotdone.md)
* Refer to this Profile: [QICore AdverseEvent](StructureDefinition-qicore-adverseevent.md), [QICore Claim](StructureDefinition-qicore-claim.md), [QICore Encounter](StructureDefinition-qicore-encounter.md) and [QICore ImagingStudy](StructureDefinition-qicore-imagingstudy.md)
* Examples for this Profile: [Procedure/example](Procedure-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.qicore|current/StructureDefinition/qicore-procedure)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-qicore-procedure.csv), [Excel](StructureDefinition-qicore-procedure.xlsx), [Schematron](StructureDefinition-qicore-procedure.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "qicore-procedure",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-primaryCodePath",
      "valueString" : "code"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isIncluded",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isRetrievable",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-label",
      "valueString" : "Procedure"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-procedure",
  "version" : "7.0.2",
  "name" : "QICoreProcedure",
  "title" : "QICore Procedure",
  "status" : "active",
  "experimental" : false,
  "date" : "2018-08-22",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Profile of Procedure for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Procedure",
  "baseDefinition" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-procedure",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Procedure",
        "path" : "Procedure",
        "constraint" : [
          {
            "key" : "prc-1",
            "severity" : "error",
            "human" : "to indicate what procedure, either at least one coding in the code or a codeOptions extension shall be provided",
            "expression" : "code.extension('http://hl7.org/fhir/StructureDefinition/codeOptions').exists() xor code.coding.exists()"
          }
        ],
        "mustSupport" : false
      },
      {
        "id" : "Procedure.implicitRules",
        "path" : "Procedure.implicitRules",
        "short" : "A set of rules under which this content was created"
      },
      {
        "id" : "Procedure.extension:recorded",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Procedure.extension",
        "sliceName" : "recorded",
        "short" : "(QI) When the procedure was first captured in the subject's record",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/5.0/StructureDefinition/extension-Procedure.recorded"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.basedOn",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Procedure.basedOn",
        "short" : "(QI) A request for this procedure",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-careplan",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-servicerequest"
            ]
          }
        ],
        "mustSupport" : false
      },
      {
        "id" : "Procedure.status",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Procedure.status",
        "short" : "(QI) preparation | in-progress | not-done | on-hold | stopped | completed | entered-in-error | unknown"
      },
      {
        "id" : "Procedure.code",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Procedure.code",
        "short" : "(QI) What procedure",
        "condition" : ["prc-1"]
      },
      {
        "id" : "Procedure.code.extension:codeOptions",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Procedure.code.extension",
        "sliceName" : "codeOptions",
        "short" : "(QI) Url of a value set of candidate procedures",
        "definition" : "A logical reference (e.g. a reference to ValueSet.url) to a value set/version that identifies a set of possible coded values representing the procedure.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/codeOptions|7.0.2"]
          }
        ],
        "condition" : ["prc-1"]
      },
      {
        "id" : "Procedure.subject",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Procedure.subject",
        "short" : "(QI) Who the procedure was performed on",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.performed[x]",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Procedure.performed[x]",
        "short" : "(QI) When the procedure was performed"
      },
      {
        "id" : "Procedure.performer.actor",
        "path" : "Procedure.performer.actor",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-practitioner",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-organization",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-relatedperson"
            ]
          }
        ],
        "mustSupport" : false
      },
      {
        "id" : "Procedure.reasonCode",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Procedure.reasonCode",
        "short" : "(QI) Coded reason procedure performed"
      },
      {
        "id" : "Procedure.reasonReference",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Procedure.reasonReference",
        "short" : "(QI) The justification that the procedure was performed",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-condition-encounter-diagnosis",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-condition-problems-health-concerns",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-diagnosticreport-note",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-documentreference"
            ]
          }
        ]
      }
    ]
  }
}

```
