# QICore PractitionerRole - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **QICore PractitionerRole**

## Resource Profile: QICore PractitionerRole 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-practitionerrole | *Version*:7.0.2 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 4 | *Computable Name*:QICorePractitionerRole |

 
Profile of PractitionerRole for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. 

"Must Have", "QI Elements" and "primary code path" are defined in the
[QI-Core Must Support section](index.md#mustsupport-flag).

**QI Elements:**
* identifier.use: (QI) usual | official | temp | secondary | old (If known)
* period: (QI) The period during which the practitioner is authorized to perform in these role(s)
* identifier.value: (QI) The value that is unique
* practitioner: (QI) Practitioner that is able to provide the defined services for the organization
* identifier: (QI) Business Identifiers that are specific to a role/location
* telecom: (QI) Contact details that are specific to the role/location/service
* identifier.system: (QI) The namespace for the identifier value
* organization: (QI) Organization where the roles are available
* location: (QI) The location(s) at which this practitioner provides care
* code: (QI) Roles which this practitioner may perform
* active: (QI) Whether this practitioner role record is in active use
* specialty: (QI) Specific specialty of the practitioner
* endpoint: (QI) Technical endpoints providing access to services operated for the practitioner with this role

**Primary code path:**code

(PCPath) This element is the primary code path for this resource
[CQL Retrieve](https://cql.hl7.org/02-authorsguide.html#retrieve)

**Usage**
 See the[patterns](patterns.md)page for implementation and usage patterns. 

### Examples

 

| |
| :--- |
| [PractitionerRole Example](PractitionerRole-example.md) |

 

**Usages:**

* Refer to this Profile: [QICore AdverseEvent](StructureDefinition-qicore-adverseevent.md), [QICore CareTeam](StructureDefinition-qicore-careteam.md), [QICore Claim](StructureDefinition-qicore-claim.md), [QICore ClaimResponse](StructureDefinition-qicore-claimresponse.md)...Show 9 more,[QICore DiagnosticReport Profile for Laboratory Results Reporting](StructureDefinition-qicore-diagnosticreport-lab.md),[QICore Encounter](StructureDefinition-qicore-encounter.md),[QICore ImagingStudy](StructureDefinition-qicore-imagingstudy.md),[QICore MedicationRequest](StructureDefinition-qicore-medicationrequest.md),[QICore NonPatient Observation](StructureDefinition-qicore-nonpatient-observation.md),[QICore Observation Screening Assessment](StructureDefinition-qicore-observation-screening-assessment.md),[QICore QuestionnaireResponse](StructureDefinition-qicore-questionnaireresponse.md),[QICore ServiceRequest](StructureDefinition-qicore-servicerequest.md)and[QICore Simple Observation](StructureDefinition-qicore-simple-observation.md)
* Examples for this Profile: [PractitionerRole/example](PractitionerRole-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.qicore|current/StructureDefinition/qicore-practitionerrole)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-qicore-practitionerrole.csv), [Excel](StructureDefinition-qicore-practitionerrole.xlsx), [Schematron](StructureDefinition-qicore-practitionerrole.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "qicore-practitionerrole",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-primaryCodePath",
      "valueString" : "code"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isIncluded",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isRetrievable",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-label",
      "valueString" : "PractitionerRole"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-practitionerrole",
  "version" : "7.0.2",
  "name" : "QICorePractitionerRole",
  "title" : "QICore PractitionerRole",
  "status" : "active",
  "experimental" : false,
  "date" : "2018-08-22",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Profile of PractitionerRole for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "PractitionerRole",
  "baseDefinition" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitionerrole",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "PractitionerRole",
        "path" : "PractitionerRole"
      },
      {
        "id" : "PractitionerRole.identifier",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "PractitionerRole.identifier",
        "short" : "(QI) Business Identifiers that are specific to a role/location",
        "min" : 1,
        "max" : "*"
      },
      {
        "id" : "PractitionerRole.identifier.use",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "PractitionerRole.identifier.use",
        "short" : "(QI) usual | official | temp | secondary | old (If known)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ]
      },
      {
        "id" : "PractitionerRole.identifier.system",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "PractitionerRole.identifier.system",
        "short" : "(QI) The namespace for the identifier value",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "uri"
          }
        ]
      },
      {
        "id" : "PractitionerRole.identifier.value",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "PractitionerRole.identifier.value",
        "short" : "(QI) The value that is unique",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "PractitionerRole.active",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "PractitionerRole.active",
        "short" : "(QI) Whether this practitioner role record is in active use",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "PractitionerRole.period",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "PractitionerRole.period",
        "short" : "(QI) The period during which the practitioner is authorized to perform in these role(s)",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "PractitionerRole.practitioner",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "PractitionerRole.practitioner",
        "short" : "(QI) Practitioner that is able to provide the defined services for the organization",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-practitioner"
            ]
          }
        ]
      },
      {
        "id" : "PractitionerRole.organization",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "PractitionerRole.organization",
        "short" : "(QI) Organization where the roles are available",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-organization"
            ]
          }
        ]
      },
      {
        "id" : "PractitionerRole.code",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "PractitionerRole.code",
        "short" : "(QI) Roles which this practitioner may perform",
        "binding" : {
          "strength" : "extensible",
          "description" : "Indicates specific responsibility of an individual within the care team, such as Primary physician, Team coordinator, Caregiver, etc.",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1099.30"
        }
      },
      {
        "id" : "PractitionerRole.specialty",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "PractitionerRole.specialty",
        "short" : "(QI) Specific specialty of the practitioner",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.114222.4.11.1066"
        }
      },
      {
        "id" : "PractitionerRole.location",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "PractitionerRole.location",
        "short" : "(QI) The location(s) at which this practitioner provides care",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-location"
            ]
          }
        ]
      },
      {
        "id" : "PractitionerRole.healthcareService",
        "path" : "PractitionerRole.healthcareService",
        "condition" : ["us-core-13"]
      },
      {
        "id" : "PractitionerRole.telecom",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "PractitionerRole.telecom",
        "short" : "(QI) Contact details that are specific to the role/location/service",
        "condition" : ["pd-1"]
      },
      {
        "id" : "PractitionerRole.telecom.system",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "PractitionerRole.telecom.system",
        "short" : "(QI) phone | fax | email | pager | url | sms | other",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ]
      },
      {
        "id" : "PractitionerRole.telecom.value",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "PractitionerRole.telecom.value",
        "short" : "(QI) The actual contact point details",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "PractitionerRole.endpoint",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "PractitionerRole.endpoint",
        "short" : "(QI) Technical endpoints providing access to services operated for the practitioner with this role",
        "condition" : ["pd-1"]
      }
    ]
  }
}

```
