# QICore Practitioner - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **QICore Practitioner**

## Resource Profile: QICore Practitioner 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-practitioner | *Version*:7.0.2 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 4 | *Computable Name*:QICorePractitioner |

 
Profile of Practitioner for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. 

"Must Have", "QI Elements" and "primary code path" are defined in the
[QI-Core Must Support section](index.md#mustsupport-flag).

**Must Have:**
* name: The name(s) associated with the practitioner
* identifier: (QI) An identifier for the person as this agent

**QI Elements:**
* identifier.use: (QI) usual | official | temp | secondary | old (If known)
* identifier(NPI): (QI) An identifier for the person as this agent
* identifier.value: (QI) The value that is unique
* identifier(ein): (QI) There is not a general Tax Identifier Numer (TIN) OID. There is an SSN, a PTIN, and an ITIN, but no TIN generally. So the only slice specified here is EIN, if consumers determine a need for an SSN, submit a comment to that effect.
* identifier.system: (QI) The namespace for the identifier value

**Usage**
 See the[patterns](patterns.md)page for implementation and usage patterns. 

### Examples

 

| |
| :--- |
| [Referring Practitioner Example](Practitioner-example.md) |

 

**Usages:**

* Refer to this Profile: [QICore AdverseEvent](StructureDefinition-qicore-adverseevent.md), [QICore CareTeam](StructureDefinition-qicore-careteam.md), [QICore Claim](StructureDefinition-qicore-claim.md), [QICore ClaimResponse](StructureDefinition-qicore-claimresponse.md)...Show 16 more,[QICore Communication](StructureDefinition-qicore-communication.md),[QICore CommunicationRequest](StructureDefinition-qicore-communicationrequest.md),[QICore DiagnosticReport Profile for Laboratory Results Reporting](StructureDefinition-qicore-diagnosticreport-lab.md),[QICore DiagnosticReport Profile for Report and Note Exchange](StructureDefinition-qicore-diagnosticreport-note.md),[QICore Encounter](StructureDefinition-qicore-encounter.md),[QICore Flag](StructureDefinition-qicore-flag.md),[QICore ImagingStudy](StructureDefinition-qicore-imagingstudy.md),[QICore MedicationRequest](StructureDefinition-qicore-medicationrequest.md),[QICore MedicationStatement](StructureDefinition-qicore-medicationstatement.md),[QICore NonPatient Observation](StructureDefinition-qicore-nonpatient-observation.md),[QICore Observation Screening Assessment](StructureDefinition-qicore-observation-screening-assessment.md),[QICore PractitionerRole](StructureDefinition-qicore-practitionerrole.md),[QICore Procedure](StructureDefinition-qicore-procedure.md),[QICore QuestionnaireResponse](StructureDefinition-qicore-questionnaireresponse.md),[QICore ServiceRequest](StructureDefinition-qicore-servicerequest.md)and[QICore Simple Observation](StructureDefinition-qicore-simple-observation.md)
* Examples for this Profile: [Practitioner/example](Practitioner-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.qicore|current/StructureDefinition/qicore-practitioner)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-qicore-practitioner.csv), [Excel](StructureDefinition-qicore-practitioner.xlsx), [Schematron](StructureDefinition-qicore-practitioner.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "qicore-practitioner",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isIncluded",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isRetrievable",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-label",
      "valueString" : "Practitioner"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-practitioner",
  "version" : "7.0.2",
  "name" : "QICorePractitioner",
  "title" : "QICore Practitioner",
  "status" : "active",
  "experimental" : false,
  "date" : "2018-08-22",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Profile of Practitioner for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Practitioner",
  "baseDefinition" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Practitioner",
        "path" : "Practitioner"
      },
      {
        "id" : "Practitioner.identifier",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Practitioner.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "short" : "(QI) An identifier for the person as this agent",
        "comment" : "NPI must be supported as the identifier system in the US, Tax id is allowed, Local id is allowed in addition to another identifier supplied by a jurisdictional authority such as a practitioner's *Drug Enforcement Administration (DEA)* number.",
        "min" : 1
      },
      {
        "id" : "Practitioner.identifier.system",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Practitioner.identifier.system",
        "short" : "(QI) The namespace for the identifier value",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "uri"
          }
        ]
      },
      {
        "id" : "Practitioner.identifier.value",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Practitioner.identifier.value",
        "short" : "(QI) The value that is unique",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Practitioner.identifier:NPI",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Practitioner.identifier",
        "sliceName" : "NPI",
        "short" : "(QI) An identifier for the person as this agent",
        "patternIdentifier" : {
          "system" : "http://hl7.org/fhir/sid/us-npi"
        },
        "condition" : ["us-core-16", "us-core-17"]
      },
      {
        "id" : "Practitioner.identifier:ein",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Practitioner.identifier",
        "sliceName" : "ein",
        "short" : "(QI) There is not a general Tax Identifier Numer (TIN) OID. There is an SSN, a PTIN, and an ITIN, but no TIN generally. So the only slice specified here is EIN, if consumers determine a need for an SSN, submit a comment to that effect.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "patternIdentifier" : {
          "system" : "urn:oid:2.16.840.1.113883.4.4"
        }
      },
      {
        "id" : "Practitioner.identifier:ein.use",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Practitioner.identifier.use",
        "short" : "(QI) usual | official | temp | secondary | old (If known)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ]
      },
      {
        "id" : "Practitioner.identifier:ein.value",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Practitioner.identifier.value",
        "short" : "(QI) The value that is unique",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
