# QICore Patient - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **QICore Patient**

## Resource Profile: QICore Patient 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient | *Version*:7.0.2 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 4 | *Computable Name*:QICorePatient |

 
Profile of Patient for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. 

"Must Have", "QI Elements" and "primary code path" are defined in the
[QI-Core Must Support section](index.md#mustsupport-flag).

**Must Have:**
* name: A name associated with the patient
* identifier: An identifier for this patient
* gender: male | female | other | unknown

**QI Elements:**
* deceased[x]: (QI) Indicates if the individual is deceased or not
* extension(race): (QI) US Core Race Extension
* extension(tribalAffiliation): (QI) Tribal Affiliation Extension
* birthDate: (QI) The date of birth for the individual
* extension(ethnicity): (QI) US Core ethnicity Extension
* address: (QI) An address for the individual
* communication: (QI) A language which may be used to communicate with the patient about his or her health
* extension(genderIdentity): (QI) The individual's gender identity
* telecom: (QI) A contact detail for the individual
* extension(sex): (QI) Sex Extension

**Usage**
 See the[patterns](patterns.md)page for implementation and usage patterns. 

### Examples

 

| |
| :--- |
| [Basic Patient Example](Patient-example.md) |
| [65+ Female Patient Example](Patient-example-2.md) |
| [Infant Patient Example](Patient-infant-example.md) |

 

**Usages:**

* Refer to this Profile: [QICore AdverseEvent](StructureDefinition-qicore-adverseevent.md), [QICore AllergyIntolerance](StructureDefinition-qicore-allergyintolerance.md), [QICore BodyStructure](StructureDefinition-qicore-bodystructure.md), [QICore CarePlan](StructureDefinition-qicore-careplan.md)...Show 38 more,[QICore CareTeam](StructureDefinition-qicore-careteam.md),[QICore Claim](StructureDefinition-qicore-claim.md),[QICore ClaimResponse](StructureDefinition-qicore-claimresponse.md),[QICore Communication](StructureDefinition-qicore-communication.md),[QICore CommunicationRequest](StructureDefinition-qicore-communicationrequest.md),[QICore Condition Encounter Diagnosis](StructureDefinition-qicore-condition-encounter-diagnosis.md),[QICore Condition Problems Health Concerns](StructureDefinition-qicore-condition-problems-health-concerns.md),[QICore Coverage](StructureDefinition-qicore-coverage.md),[QICore Device](StructureDefinition-qicore-device.md),[QICore DeviceRequest](StructureDefinition-qicore-devicerequest.md),[QICore DeviceUseStatement](StructureDefinition-qicore-deviceusestatement.md),[QICore DiagnosticReport Profile for Laboratory Results Reporting](StructureDefinition-qicore-diagnosticreport-lab.md),[QICore DiagnosticReport Profile for Report and Note Exchange](StructureDefinition-qicore-diagnosticreport-note.md),[QICore Encounter](StructureDefinition-qicore-encounter.md),[QICore FamilyMemberHistory](StructureDefinition-qicore-familymemberhistory.md),[QICore Flag](StructureDefinition-qicore-flag.md),[QICore Goal](StructureDefinition-qicore-goal.md),[QICore ImagingStudy](StructureDefinition-qicore-imagingstudy.md),[QICore Immunization](StructureDefinition-qicore-immunization.md),[QICore ImmunizationEvaluation](StructureDefinition-qicore-immunizationevaluation.md),[QICore ImmunizationRecommendation](StructureDefinition-qicore-immunizationrecommendation.md),[QICore MedicationAdministration](StructureDefinition-qicore-medicationadministration.md),[QICore MedicationDispense](StructureDefinition-qicore-medicationdispense.md),[QICore MedicationRequest](StructureDefinition-qicore-medicationrequest.md),[QICore MedicationStatement](StructureDefinition-qicore-medicationstatement.md),[QICore NonPatient Observation](StructureDefinition-qicore-nonpatient-observation.md),[QICore NutritionOrder](StructureDefinition-qicore-nutritionorder.md),[QICore Observation Clinical Result](StructureDefinition-qicore-observation-clinical-result.md),[QICore Laboratory Result Observation](StructureDefinition-qicore-observation-lab.md),[QICore Observation Screening Assessment](StructureDefinition-qicore-observation-screening-assessment.md),[QICore Patient](StructureDefinition-qicore-patient.md),[QICore Procedure](StructureDefinition-qicore-procedure.md),[QICore QuestionnaireResponse](StructureDefinition-qicore-questionnaireresponse.md),[QICore RelatedPerson](StructureDefinition-qicore-relatedperson.md),[QICore ServiceRequest](StructureDefinition-qicore-servicerequest.md),[QICore Simple Observation](StructureDefinition-qicore-simple-observation.md),[QICore Task](StructureDefinition-qicore-task.md)and[QICore Task Rejected](StructureDefinition-qicore-taskrejected.md)
* Examples for this Profile: [Patient/example-2](Patient-example-2.md), [Patient/example](Patient-example.md) and [Patient/infant-example](Patient-infant-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.qicore|current/StructureDefinition/qicore-patient)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-qicore-patient.csv), [Excel](StructureDefinition-qicore-patient.xlsx), [Schematron](StructureDefinition-qicore-patient.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "qicore-patient",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isIncluded",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isRetrievable",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-label",
      "valueString" : "Patient"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient",
  "version" : "7.0.2",
  "name" : "QICorePatient",
  "title" : "QICore Patient",
  "status" : "active",
  "experimental" : false,
  "date" : "2018-08-22",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Profile of Patient for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "loinc",
      "uri" : "http://loinc.org",
      "name" : "LOINC code for the element"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Patient",
  "baseDefinition" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Patient",
        "path" : "Patient"
      },
      {
        "id" : "Patient.extension:race",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Patient.extension",
        "sliceName" : "race",
        "short" : "(QI) US Core Race Extension",
        "definition" : "Concepts classifying the person into a named category of humans sharing common history, traits, geographical origin or nationality.  The race codes used to represent these concepts are based upon the [CDC Race and Ethnicity Code Set Version 1.0](http://www.cdc.gov/phin/resources/vocabulary/index.html) which includes over 900 concepts for representing race and ethnicity of which 921 reference race.  The race concepts are grouped by and pre-mapped to the 5 OMB race categories:\n\n   - American Indian or Alaska Native\n   - Asian\n   - Black or African American\n   - Native Hawaiian or Other Pacific Islander\n   - White.",
        "min" : 0,
        "max" : "1",
        "base" : {
          "path" : "DomainResource.extension",
          "min" : 0,
          "max" : "*"
        },
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-race"
            ]
          }
        ],
        "mustSupport" : false,
        "isModifier" : false
      },
      {
        "id" : "Patient.extension:ethnicity",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Patient.extension",
        "sliceName" : "ethnicity",
        "short" : "(QI) US Core ethnicity Extension",
        "definition" : "Concepts classifying the person into a named category of humans sharing common history, traits, geographical origin or nationality.  The ethnicity codes used to represent these concepts are based upon the [CDC ethnicity and Ethnicity Code Set Version 1.0](http://www.cdc.gov/phin/resources/vocabulary/index.html) which includes over 900 concepts for representing race and ethnicity of which 43 reference ethnicity.  The ethnicity concepts are grouped by and pre-mapped to the 2 OMB ethnicity categories: - Hispanic or Latino - Not Hispanic or Latino.",
        "min" : 0,
        "max" : "1",
        "base" : {
          "path" : "DomainResource.extension",
          "min" : 0,
          "max" : "*"
        },
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-ethnicity"
            ]
          }
        ],
        "mustSupport" : false,
        "isModifier" : false
      },
      {
        "id" : "Patient.extension:tribalAffiliation",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Patient.extension",
        "sliceName" : "tribalAffiliation",
        "short" : "(QI) Tribal Affiliation Extension",
        "definition" : "A tribe or band with which a person associates whether or not they are an enrolled member.",
        "min" : 0,
        "max" : "*",
        "base" : {
          "path" : "DomainResource.extension",
          "min" : 0,
          "max" : "*"
        },
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-tribal-affiliation"
            ]
          }
        ],
        "mustSupport" : false,
        "isModifier" : false
      },
      {
        "id" : "Patient.extension:sex",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Patient.extension",
        "sliceName" : "sex",
        "short" : "(QI) Sex Extension",
        "definition" : "The US Core Sex Extension is used to reflect the documentation of a person's sex. It aligns with the C-CDA Sex Observation (LOINC 46098-0).",
        "min" : 0,
        "max" : "1",
        "base" : {
          "path" : "DomainResource.extension",
          "min" : 0,
          "max" : "*"
        },
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-sex"
            ]
          }
        ],
        "mustSupport" : false,
        "isModifier" : false
      },
      {
        "id" : "Patient.extension:genderIdentity",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Patient.extension",
        "sliceName" : "genderIdentity",
        "short" : "(QI) The individual's gender identity",
        "definition" : "An individual's personal sense of being a man, woman, boy, girl, nonbinary, or something else.",
        "comment" : "This represents an individual's identity, ascertained by asking them what that identity is.",
        "min" : 0,
        "max" : "*",
        "base" : {
          "path" : "DomainResource.extension",
          "min" : 0,
          "max" : "*"
        },
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-genderIdentity"
            ]
          }
        ],
        "mustSupport" : false,
        "isModifier" : false
      },
      {
        "id" : "Patient.name",
        "path" : "Patient.name"
      },
      {
        "id" : "Patient.name.use",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Patient.name.use",
        "short" : "(QI) usual | official | temp | nickname | anonymous | old | maiden",
        "definition" : "Identifies the purpose for this name.",
        "comment" : "Applications can assume that a name is current unless it explicitly says that it is temporary or old.",
        "requirements" : "Allows the appropriate name for a particular context of use to be selected from among a set of names.",
        "min" : 0,
        "max" : "1",
        "base" : {
          "path" : "HumanName.use",
          "min" : 0,
          "max" : "1"
        },
        "type" : [
          {
            "code" : "code"
          }
        ],
        "isModifier" : true,
        "isModifierReason" : "This is labeled as \"Is Modifier\" because applications should not mistake a temporary or old name etc.for a current/permanent one",
        "isSummary" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "NameUse"
            }
          ],
          "strength" : "required",
          "description" : "The use of a human name.",
          "valueSet" : "http://hl7.org/fhir/ValueSet/name-use|4.0.1"
        }
      },
      {
        "id" : "Patient.name.suffix",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Patient.name.suffix",
        "short" : "(QI) Parts that come after the name",
        "definition" : "Part of the name that is acquired as a title due to academic, legal, employment or nobility status, etc. and that appears at the end of the name.",
        "min" : 0,
        "max" : "*",
        "base" : {
          "path" : "HumanName.suffix",
          "min" : 0,
          "max" : "*"
        },
        "type" : [
          {
            "code" : "string"
          }
        ],
        "orderMeaning" : "Suffixes appear in the correct order for presenting the name",
        "mustSupport" : false,
        "isModifier" : false,
        "isSummary" : true
      },
      {
        "id" : "Patient.name.period",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Patient.name.period",
        "short" : "(QI) Time period when name was/is in use",
        "definition" : "Indicates the period of time when this name was valid for the named person.",
        "requirements" : "Allows names to be placed in historical context.",
        "min" : 0,
        "max" : "1",
        "base" : {
          "path" : "HumanName.period",
          "min" : 0,
          "max" : "1"
        },
        "type" : [
          {
            "code" : "Period"
          }
        ],
        "mustSupport" : false,
        "isModifier" : false,
        "isSummary" : true
      },
      {
        "id" : "Patient.telecom",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Patient.telecom",
        "short" : "(QI) A contact detail for the individual"
      },
      {
        "id" : "Patient.birthDate",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Patient.birthDate",
        "short" : "(QI) The date of birth for the individual"
      },
      {
        "id" : "Patient.deceased[x]",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Patient.deceased[x]",
        "short" : "(QI) Indicates if the individual is deceased or not",
        "comment" : "The \"Cause of death\" for a patient is typically captured as an Observation."
      },
      {
        "id" : "Patient.address",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Patient.address",
        "short" : "(QI) An address for the individual"
      },
      {
        "id" : "Patient.address.extension:address-preferred",
        "path" : "Patient.address.extension",
        "sliceName" : "address-preferred",
        "comment" : "Make general extension.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/iso21090-preferred|5.2.0-ballot"
            ]
          }
        ],
        "mustSupport" : false,
        "mapping" : [
          {
            "identity" : "qidam",
            "map" : "Not in QIDAM, but CDS could need this for notifications in population health contexts, for example."
          }
        ]
      },
      {
        "id" : "Patient.address.use",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Patient.address.use",
        "short" : "(QI) home | work | temp | old | billing - purpose of this address",
        "definition" : "The purpose of this address.",
        "comment" : "Applications can assume that an address is current unless it explicitly says that it is temporary or old.",
        "requirements" : "Allows an appropriate address to be chosen from a list of many.",
        "min" : 0,
        "max" : "1",
        "base" : {
          "path" : "Address.use",
          "min" : 0,
          "max" : "1"
        },
        "type" : [
          {
            "code" : "code"
          }
        ],
        "example" : [
          {
            "label" : "General",
            "valueCode" : "home"
          }
        ],
        "isModifier" : true,
        "isModifierReason" : "This is labeled as \"Is Modifier\" because applications should not mistake a temporary or old address etc.for a current/permanent one",
        "isSummary" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "AddressUse"
            }
          ],
          "strength" : "required",
          "description" : "The use of an address.",
          "valueSet" : "http://hl7.org/fhir/ValueSet/address-use|4.0.1"
        }
      },
      {
        "id" : "Patient.address.period",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Patient.address.period",
        "short" : "(QI) Time period when address was/is in use",
        "definition" : "Time period when address was/is in use.",
        "requirements" : "Allows addresses to be placed in historical context.",
        "min" : 0,
        "max" : "1",
        "base" : {
          "path" : "Address.period",
          "min" : 0,
          "max" : "1"
        },
        "type" : [
          {
            "code" : "Period"
          }
        ],
        "example" : [
          {
            "label" : "General",
            "valuePeriod" : {
              "start" : "2010-03-23",
              "end" : "2010-07-01"
            }
          }
        ],
        "isModifier" : false,
        "isSummary" : true
      },
      {
        "id" : "Patient.communication",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "Patient.communication",
        "short" : "(QI) A language which may be used to communicate with the patient about his or her health",
        "definition" : "A language which may be used to communicate with the patient about his or her health.",
        "comment" : "If no language is specified, this *implies* that the default local language is spoken.  If you need to convey proficiency for multiple modes, then you need multiple Patient.Communication associations.   For animals, language is not a relevant field, and should be absent from the instance. If the Patient does not speak the default local language, then the Interpreter Required Standard can be used to explicitly declare that an interpreter is required.",
        "requirements" : "If a patient does not speak the local language, interpreters may be required, so languages spoken and proficiency are important things to keep track of both for patient and other persons of interest.",
        "min" : 0,
        "max" : "*",
        "base" : {
          "path" : "Patient.communication",
          "min" : 0,
          "max" : "*"
        },
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : false,
        "isModifier" : false,
        "isSummary" : false
      },
      {
        "id" : "Patient.link",
        "path" : "Patient.link",
        "mustSupport" : false
      },
      {
        "id" : "Patient.link.other",
        "path" : "Patient.link.other",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient"
            ]
          }
        ],
        "mustSupport" : false
      }
    ]
  }
}

```
