# QICore MedicationAdministration Not Done - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **QICore MedicationAdministration Not Done**

## Resource Profile: QICore MedicationAdministration Not Done 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medicationadministrationnotdone | *Version*:7.0.2 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 4 | *Computable Name*:QICoreMedicationAdministrationNotDone |

 
Negation profile of MedicationAdministration for decision support/quality metrics. Indicates that a medication was not administered for a reason. 

"Must Have", "QI Elements" and "primary code path" are defined in the
[QI-Core Must Support section](index.md#mustsupport-flag).

**QI Elements:**
* medication[x]: (QI) What was administered
* dosage: (QI) Details of how medication was taken
* statusReason: (QI) Reason administration not performed
* medication[x].extension(codeOptions): (QI) Url of a value set of candidate medications
* subject: (QI) Who received medication
* request: (QI) Request administration performed against
* effective[x]: (QI) Start and end time of administration
* status: (QI) not-done
* context: (QI) Encounter or Episode of Care administered as part of

**Primary code path:**medication

(PCPath) This element is the primary code path for this resource
[CQL Retrieve](https://cql.hl7.org/02-authorsguide.html#retrieve)

**Usage**
The MedicationAdministration profile defines the conformance expectations for a MedicationAdministration event, regardless of whether it is a positive or negative statement. The MedicationAdministrationDone and MedicationAdministrationNotDone profiles represent the positive and negative statements for a MedicationAdministration event.

To create an expression indicating existence of a MedicationAdministration, use the profile [QICoreMedicationAdministrationDone](StructureDefinition-qicore-medicationadministrationdone.md); to specifically request information that a MedicationAdministration intentionally did not occur for a medical, patient or system reason, use the profile [QICoreMedicationAdministrationNotDone](StructureDefinition-qicore-medicationadministrationnotdone.md).

The following example illustrates an expression to retrieve instances that meet measure intent for exclusion:

```
define "Low Dose Unfractionated Heparin for VTE Prophylaxis Not Administered":
  ["MedicationAdministrationNotDone": "Low Dose Unfractionated Heparin for VTE Prophylaxis"] VTEMedication
    where VTEMedication.category ~ QICoreCommon."Inpatient"
      and (VTEMedication.reasonCode in "Medical Reason" or VTEMedication.reasonCode in "Patient Refusal")
```

For a more complete discussion of representation of negation within QI-Core and quality improvement artifacts, see the [Negation in QI-Core](negation.md) topic.

 See the[patterns](patterns.md)page for implementation and usage patterns. 

### Examples

 

| | |
| :--- | :--- |
| [Negation example using a valueset](MedicationAdministration-negation-example.md) | Medication not administered using a value set to indicate what was not administered; indicates that none of the medications in the given value set were administered |
| [Negation example using a code](MedicationAdministration-negation-with-code-example.md) | Medication not administered using a code to indicate that a particular medication was not administered; indicates that a specific medication, by code, was not administered |

 

**Usages:**

* Examples for this Profile: [MedicationAdministration/negation-example](MedicationAdministration-negation-example.md) and [MedicationAdministration/negation-with-code-example](MedicationAdministration-negation-with-code-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.qicore|current/StructureDefinition/qicore-medicationadministrationnotdone)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-qicore-medicationadministrationnotdone.csv), [Excel](StructureDefinition-qicore-medicationadministrationnotdone.xlsx), [Schematron](StructureDefinition-qicore-medicationadministrationnotdone.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "qicore-medicationadministrationnotdone",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-primaryCodePath",
      "valueString" : "medication"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isIncluded",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isRetrievable",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-label",
      "valueString" : "MedicationAdministrationNotDone"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medicationadministrationnotdone",
  "version" : "7.0.2",
  "name" : "QICoreMedicationAdministrationNotDone",
  "title" : "QICore MedicationAdministration Not Done",
  "status" : "active",
  "experimental" : false,
  "date" : "2018-08-22",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Negation profile of MedicationAdministration for decision support/quality metrics. Indicates that a medication was not administered for a reason.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "w3c.prov",
      "uri" : "http://www.w3.org/ns/prov",
      "name" : "W3C PROV"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MedicationAdministration",
  "baseDefinition" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medicationadministration",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationAdministration",
        "path" : "MedicationAdministration",
        "mustSupport" : false
      },
      {
        "id" : "MedicationAdministration.implicitRules",
        "path" : "MedicationAdministration.implicitRules",
        "short" : "A set of rules under which this content was created",
        "definition" : "A reference to a set of rules that were followed when the resource was constructed, and which must be understood when processing the content. Often, this is a reference to an implementation guide that defines the special rules along with other profiles etc.",
        "comment" : "Asserting this rule set restricts the content to be only understood by a limited set of trading partners. This inherently limits the usefulness of the data in the long term. However, the existing health eco-system is highly fractured, and not yet ready to define, collect, and exchange data in a generally computable sense. Wherever possible, implementers and/or specification writers should avoid using this element. Often, when used, the URL is a reference to an implementation guide that defines these special rules as part of it's narrative along with other profiles, value sets, etc.",
        "min" : 0,
        "max" : "1",
        "base" : {
          "path" : "Resource.implicitRules",
          "min" : 0,
          "max" : "1"
        },
        "type" : [
          {
            "code" : "uri"
          }
        ],
        "isModifier" : true,
        "isModifierReason" : "This element is labeled as a modifier because the implicit rules may provide additional knowledge about the resource that modifies it's meaning or interpretation",
        "isSummary" : true
      },
      {
        "id" : "MedicationAdministration.status",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationAdministration.status",
        "short" : "(QI) not-done",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "fixedCode" : "not-done"
      },
      {
        "id" : "MedicationAdministration.statusReason",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationAdministration.statusReason",
        "short" : "(QI) Reason administration not performed",
        "min" : 1,
        "max" : "1",
        "binding" : {
          "strength" : "extensible",
          "description" : "The reason the event did not occur or was not performed",
          "valueSet" : "http://hl7.org/fhir/us/qicore/ValueSet/qicore-negation-reason"
        }
      }
    ]
  }
}

```
