# QICore Device Prohibited - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **QICore Device Prohibited**

## Resource Profile: QICore Device Prohibited 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-deviceprohibited | *Version*:7.0.2 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 4 | *Computable Name*:QICoreDeviceProhibited |

 
Negation profile of DeviceRequest for decision support/quality metrics. Indicates a proposal, plan, or order not to provide a device. 

"Must Have", "QI Elements" and "primary code path" are defined in the
[QI-Core Must Support section](index.md#mustsupport-flag).

**QI Elements:**
* status: (QI) draft | active | on-hold | revoked | completed | entered-in-error | unknown
* modifierExtension(doNotPerform): (QI) Extension
* authoredOn: (QI) When recorded
* intent: (QI) proposal | plan | directive | order | original-order | reflex-order | filler-order | instance-order | option
* code[x]: (QI) Device requested
* code[x].extension(codeOptions): (QI) Url of a value set of candidate devices
* reasonCode: (QI) Explanation/Justification for procedure or service
* subject: (QI) Focus of request
* modifierExtension.value[x]: (QI) Value of extension
* identifier: (QI) External Request identifier

**Primary code path:**code

(PCPath) This element is the primary code path for this resource
[CQL Retrieve](https://cql.hl7.org/02-authorsguide.html#retrieve)

**Usage**
The DeviceRequest profile defines the conformance expectations for a DeviceRequest, regardless of whether it is a positive or negative statement. The DeviceRequested and DeviceProhibited profiles derive from DeviceRequest and represent the positive and negative statements for a device request. 

The following example illustrates accessing DeviceProhibited data:

```
define "Venous Foot Pumps Prohibited":
  [DeviceProhibited: "Venous Foot Pumps (VFP)"] DeviceProhibited
    where (DeviceProhibited.doNotPerformReason in "Medical Reason"
      or DeviceProhibited.doNotPerformReason in "Patient Refusal"
    )
```

Note that the doNotPerform element indicating the request is a prohibition is implied by the use of the DeviceProhibited profile.

For a more complete discussion of representation of negation within QI-Core and quality improvement artifacts, see the [Negation in QI-Core](negation.md) topic.

 See the[patterns](patterns.md)page for implementation and usage patterns. 

### Examples

 

| | |
| :--- | :--- |
| [Negation Example with valueset](DeviceRequest-negation-example.md) | Device not indicated; indicates that none of the devices in the given `codeOptions` value set were requested. |
| [Negation Example with code](DeviceRequest-negation-with-code-example.md) | Device not indicated; indicates that a specific device, by code, was not requested. |

 

**Usages:**

* Examples for this Profile: [DeviceRequest/negation-example](DeviceRequest-negation-example.md) and [DeviceRequest/negation-with-code-example](DeviceRequest-negation-with-code-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.qicore|current/StructureDefinition/qicore-deviceprohibited)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-qicore-deviceprohibited.csv), [Excel](StructureDefinition-qicore-deviceprohibited.xlsx), [Schematron](StructureDefinition-qicore-deviceprohibited.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "qicore-deviceprohibited",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-primaryCodePath",
      "valueString" : "code"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isIncluded",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isRetrievable",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-label",
      "valueString" : "DeviceProhibited"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-deviceprohibited",
  "version" : "7.0.2",
  "name" : "QICoreDeviceProhibited",
  "title" : "QICore Device Prohibited",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-07-11",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Negation profile of DeviceRequest for decision support/quality metrics. Indicates a proposal, plan, or order not to provide a device.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "quick",
      "uri" : "http://siframework.org/cqf",
      "name" : "Quality Improvement and Clinical Knowledge (QUICK)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "DeviceRequest",
  "baseDefinition" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-devicerequest",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "DeviceRequest",
        "path" : "DeviceRequest",
        "mustSupport" : false
      },
      {
        "id" : "DeviceRequest.modifierExtension:doNotPerform",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "DeviceRequest.modifierExtension",
        "sliceName" : "doNotPerform",
        "short" : "(QI) Extension",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/5.0/StructureDefinition/extension-DeviceRequest.doNotPerform"
            ]
          }
        ],
        "isModifier" : true,
        "isModifierReason" : "The do not perform element changes the meaning of the request from a positive to a negative statement"
      },
      {
        "id" : "DeviceRequest.modifierExtension:doNotPerform.value[x]",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "DeviceRequest.modifierExtension.value[x]",
        "short" : "(QI) Value of extension",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "boolean"
          }
        ],
        "fixedBoolean" : true
      },
      {
        "id" : "DeviceRequest.authoredOn",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "DeviceRequest.authoredOn",
        "short" : "(QI) When recorded",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "DeviceRequest.reasonCode",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "DeviceRequest.reasonCode",
        "short" : "(QI) Explanation/Justification for procedure or service",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/us/qicore/ValueSet/qicore-negation-reason"
        }
      }
    ]
  }
}

```
