# RelatedPerson example - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **RelatedPerson example**

## Example RelatedPerson: RelatedPerson example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [QICore RelatedPerson](StructureDefinition-qicore-relatedperson.md)

**active**: true

**patient**: [Jim Chalmers Male, DoB: 1974-12-25 ( Medical record number (use: usual, period: 2001-05-06 --> (ongoing)))](Patient-example.md)

**relationship**: Emergency Contact

**name**: Peter James Chalmers (Official)

**telecom**: ph: (03) 5555 6473(Work)

**gender**: Male

**address**: 534 Erewhon St PleasantVille UT 84414 (home)

### Photos

| | | |
| :--- | :--- | :--- |
| - | **ContentType** | **Url** |
| * | image/jpeg | [http://example.org/Binary/f012](http://example.org/Binary/f012) |

**period**: 2012-03-11 --> (ongoing)



## Resource Content

```json
{
  "resourceType" : "RelatedPerson",
  "id" : "example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-relatedperson"
    ]
  },
  "active" : true,
  "patient" : {
    "reference" : "Patient/example"
  },
  "relationship" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v2-0131",
          "code" : "C"
        }
      ]
    }
  ],
  "name" : [
    {
      "use" : "official",
      "family" : "Chalmers",
      "given" : ["Peter", "James"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "(03) 5555 6473",
      "use" : "work"
    }
  ],
  "gender" : "male",
  "address" : [
    {
      "use" : "home",
      "line" : ["534 Erewhon St"],
      "city" : "PleasantVille",
      "state" : "UT",
      "postalCode" : "84414"
    }
  ],
  "photo" : [
    {
      "contentType" : "image/jpeg",
      "url" : "http://example.org/Binary/f012"
    }
  ],
  "period" : {
    "start" : "2012-03-11"
  }
}

```
