# Gestation age at birth observation example - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Gestation age at birth observation example**

## Example Observation: Gestation age at birth observation example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [QICore Simple Observation](StructureDefinition-qicore-simple-observation.md)

**status**: Final

**category**: exam

**code**: Gestational age--at birth

**subject**: [Sarah Hugankiss (official) Female, DoB: 1946-09-25 ( Medical record number (use: usual, period: 1995-05-06 --> (ongoing)))](Patient-example-2.md)

**encounter**: [Encounter: status = in-progress; class = inpatient encounter (ActCode#IMP); type = Initial hospital inpatient or observation care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 75 minutes must be met or exceeded.](Encounter-example.md)

**effective**: 2022-04-09

**performer**: [Hendricks Country Hospital](Organization-example1.md)

**value**: 37 week(Details: UCUM codewk = 'wk')



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "example-gestation",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-simple-observation"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "exam",
          "display" : "exam"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "76516-4",
        "display" : "Gestational age--at birth"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/example-2"
  },
  "encounter" : {
    "reference" : "Encounter/example"
  },
  "effectiveDateTime" : "2022-04-09",
  "performer" : [
    {
      "reference" : "Organization/example1",
      "display" : "Hendricks Country Hospital"
    }
  ],
  "valueQuantity" : {
    "value" : 37,
    "unit" : "week",
    "system" : "http://unitsofmeasure.org",
    "code" : "wk"
  }
}

```
