# MedicationDispense negation with value set example - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MedicationDispense negation with value set example**

## Example MedicationDispense: MedicationDispense negation with value set example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [QICore MedicationDispense Declined](StructureDefinition-qicore-medicationdispensedeclined.md)

**Extension Definition for MedicationDispense.recorded for Version 5.0**: 2017-01-17

**status**: Declined

**statusReason**: Drug treatment not indicated (situation)

**medication**: Value Set: Ophthalmic Antihistamines (value set: [Ophthalmic Antihistamines](https://vsac.nlm.nih.gov/valueset/1.3.6.1.4.1.6997.4.1.2.268.13.35211.1.13.1.999.321/expansion))

**subject**: [Jim Chalmers Male, DoB: 1974-12-25 ( Medical record number (use: usual, period: 2001-05-06 --> (ongoing)))](Patient-example.md)

**authorizingPrescription**: [MedicationRequest: status = active; intent = order; medication[x] = ->Medication alemtuzumab 10 MG/ML [Lemtrada]; authoredOn = 2015-03-25 19:32:52-0500](MedicationRequest-example.md)

> **dosageInstruction****timing**: 3 per 1 day**route**:oral administration of treatment

### DoseAndRates

| | | |
| :--- | :--- | :--- |
| - | **Type** | **Dose[x]** |
| * | Ordered | 5 ml(Details: UCUM codeml = 'ml') |




## Resource Content

```json
{
  "resourceType" : "MedicationDispense",
  "id" : "negation-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medicationdispensedeclined"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/5.0/StructureDefinition/extension-MedicationDispense.recorded",
      "valueDateTime" : "2017-01-17"
    }
  ],
  "status" : "declined",
  "statusReasonCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "183966005",
        "display" : "Drug treatment not indicated (situation)"
      }
    ]
  },
  "medicationCodeableConcept" : {
    "extension" : [
      {
        "url" : "http://hl7.org/fhir/StructureDefinition/codeOptions",
        "valueCanonical" : "http://cts.nlm.nih.gov/fhir/ValueSet/1.3.6.1.4.1.6997.4.1.2.268.13.35211.1.13.1.999.321"
      }
    ],
    "text" : "Value Set: Ophthalmic Antihistamines"
  },
  "subject" : {
    "reference" : "Patient/example"
  },
  "authorizingPrescription" : [
    {
      "reference" : "MedicationRequest/example"
    }
  ],
  "dosageInstruction" : [
    {
      "timing" : {
        "repeat" : {
          "frequency" : 3,
          "period" : 1,
          "periodUnit" : "d"
        }
      },
      "route" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "394899003",
            "display" : "oral administration of treatment"
          }
        ]
      },
      "doseAndRate" : [
        {
          "type" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/dose-rate-type",
                "code" : "ordered",
                "display" : "Ordered"
              }
            ]
          },
          "doseQuantity" : {
            "value" : 5,
            "unit" : "ml",
            "system" : "http://unitsofmeasure.org",
            "code" : "ml"
          }
        }
      ]
    }
  ]
}

```
