# Medication example - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Medication example**

## Example Medication: Medication example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |



## Resource Content

```json
{
  "resourceType" : "Medication",
  "id" : "example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medication"
    ]
  },
  "contained" : [
    {
      "resourceType" : "Organization",
      "id" : "org6",
      "meta" : {
        "profile" : [
          "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-organization"
        ]
      },
      "identifier" : [
        {
          "use" : "temp",
          "system" : "http://hl7.org/fhir/sid/us-npi",
          "value" : "8635143786"
        }
      ],
      "active" : true,
      "name" : "Genzyme",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.sanofigenzyme.com/",
          "use" : "work"
        }
      ],
      "address" : [
        {
          "use" : "work",
          "city" : "Cambridge",
          "state" : "MA",
          "country" : "USA"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
        "code" : "1594660",
        "display" : "alemtuzumab 10 MG/ML [Lemtrada]"
      }
    ]
  },
  "manufacturer" : {
    "reference" : "#org6"
  },
  "form" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "385219001",
        "display" : "Conventional release solution for injection (dose form)"
      }
    ]
  },
  "ingredient" : [
    {
      "itemCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "129472003",
            "display" : "Alemtuzumab (substance)"
          }
        ]
      },
      "strength" : {
        "numerator" : {
          "value" : 12,
          "system" : "http://unitsofmeasure.org",
          "code" : "mg"
        },
        "denominator" : {
          "value" : 1.2,
          "system" : "http://unitsofmeasure.org",
          "code" : "mL"
        }
      }
    }
  ],
  "batch" : {
    "lotNumber" : "9494788",
    "expirationDate" : "2017-05-22"
  }
}

```
