# DeviceUseStatement example - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **DeviceUseStatement example**

## Example DeviceUseStatement: DeviceUseStatement example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [QICore DeviceUseStatement](StructureDefinition-qicore-deviceusestatement.md)

**identifier**: `http://example.org/identifiers`/51ebb7a9-4e3a-4360-9a05-0cc2d869086f

**status**: Active

**subject**: [Jim Chalmers Male, DoB: 1974-12-25 ( Medical record number (use: usual, period: 2001-05-06 --> (ongoing)))](Patient-example.md)

**device**: [Device: identifier = http://example.org/devices/id#345675,Serial Number: AMID-342135-8464; status = active; manufacturer = Acme Devices, Inc; lotNumber = 43453424; modelNumber = AB 45-J; type = Electrocardiographic monitor and recorder; contact = ph: ext 4352; note = QA Checked](Device-example.md)



## Resource Content

```json
{
  "resourceType" : "DeviceUseStatement",
  "id" : "example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-deviceusestatement"
    ]
  },
  "identifier" : [
    {
      "system" : "http://example.org/identifiers",
      "value" : "51ebb7a9-4e3a-4360-9a05-0cc2d869086f"
    }
  ],
  "status" : "active",
  "subject" : {
    "reference" : "Patient/example"
  },
  "device" : {
    "reference" : "Device/example"
  }
}

```
