# CommunicationRequest example - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **CommunicationRequest example**

## Example CommunicationRequest: CommunicationRequest example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [QICore CommunicationRequest](StructureDefinition-qicore-communicationrequest.md)

**identifier**: `http://example.org/insurer/123456`/ABC123

**basedOn**: EligibilityRequest

**replaces**: prior CommunicationRequest

**groupIdentifier**: 12345

**status**: Active

**category**: Notification

**priority**: Routine

**medium**: written

**encounter**: [Encounter: status = in-progress; class = inpatient encounter (ActCode#IMP); type = Initial hospital inpatient or observation care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 75 minutes must be met or exceeded.](Encounter-example.md)

### Payloads

| | |
| :--- | :--- |
| - | **Content[x]** |
| * | Please provide the accident report and any associated pictures to support your Claim #DEF5647. |

**occurrence**: 2016-06-10 11:01:10-0800

**authoredOn**: 2016-06-10 11:01:10-0800

**requester**: [Practitioner Adam Careful](Practitioner-example.md)

**recipient**: [Organization Health Level Seven International](Organization-example.md)

**sender**: [Jim Chalmers Male, DoB: 1974-12-25 ( Medical record number (use: usual, period: 2001-05-06 --> (ongoing)))](Patient-example.md)



## Resource Content

```json
{
  "resourceType" : "CommunicationRequest",
  "id" : "example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-communicationrequest"
    ]
  },
  "identifier" : [
    {
      "system" : "http://example.org/insurer/123456",
      "value" : "ABC123"
    }
  ],
  "basedOn" : [
    {
      "display" : "EligibilityRequest"
    }
  ],
  "replaces" : [
    {
      "display" : "prior CommunicationRequest"
    }
  ],
  "groupIdentifier" : {
    "value" : "12345"
  },
  "status" : "active",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/communication-category",
          "code" : "notification"
        }
      ]
    }
  ],
  "priority" : "routine",
  "medium" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationMode",
          "code" : "WRITTEN",
          "display" : "written"
        }
      ],
      "text" : "written"
    }
  ],
  "encounter" : {
    "reference" : "Encounter/example"
  },
  "payload" : [
    {
      "contentString" : "Please provide the accident report and any associated pictures to support your Claim #DEF5647."
    }
  ],
  "occurrenceDateTime" : "2016-06-10T11:01:10-08:00",
  "authoredOn" : "2016-06-10T11:01:10-08:00",
  "requester" : {
    "reference" : "Practitioner/example"
  },
  "recipient" : [
    {
      "reference" : "Organization/example"
    }
  ],
  "sender" : {
    "reference" : "Patient/example"
  }
}

```
