# Communication negation example - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Communication negation example**

## Example Communication: Communication negation example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [QICore Communication Not Done](StructureDefinition-qicore-communicationnotdone.md)

**Event Recorded**: 2014-12-12 18:01:10-0800

**status**: Not Done

**statusReason**: Patient has moved away (finding)

**category**: Alert

**medium**: written

**subject**: [Jim Chalmers Male, DoB: 1974-12-25 ( Medical record number (use: usual, period: 2001-05-06 --> (ongoing)))](Patient-example.md)

**topic**: Progress Update

**encounter**: [Encounter: status = in-progress; class = inpatient encounter (ActCode#IMP); type = Initial hospital inpatient or observation care, per day, for the evaluation and management of a patient, which requires a medically appropriate history and/or examination and high level of medical decision making. When using total time on the date of the encounter for code selection, 75 minutes must be met or exceeded.](Encounter-example.md)

**sent**: 2014-12-12 18:01:10-0800

**received**: 2014-12-12 18:01:11-0800

**recipient**: [Practitioner Adam Careful](Practitioner-example.md)

**sender**: [Device: identifier = http://example.org/devices/id#345675,Serial Number: AMID-342135-8464; status = active; manufacturer = Acme Devices, Inc; lotNumber = 43453424; modelNumber = AB 45-J; type = Electrocardiographic monitor and recorder; contact = ph: ext 4352; note = QA Checked](Device-example.md)

### Payloads

| | |
| :--- | :--- |
| - | **Content[x]** |
| * | Patient example has moved away |



## Resource Content

```json
{
  "resourceType" : "Communication",
  "id" : "negation-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-communicationnotdone"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/event-recorded",
      "valueDateTime" : "2014-12-12T18:01:10-08:00"
    }
  ],
  "status" : "not-done",
  "statusReason" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "184081006",
        "display" : "Patient has moved away (finding)"
      }
    ]
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/communication-category",
          "code" : "alert"
        }
      ],
      "text" : "Alert"
    }
  ],
  "medium" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationMode",
          "code" : "WRITTEN",
          "display" : "written"
        }
      ],
      "text" : "written"
    }
  ],
  "subject" : {
    "reference" : "Patient/example"
  },
  "topic" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/communication-topic",
        "code" : "progress-update",
        "display" : "Progress Update"
      }
    ]
  },
  "encounter" : {
    "reference" : "Encounter/example"
  },
  "sent" : "2014-12-12T18:01:10-08:00",
  "received" : "2014-12-12T18:01:11-08:00",
  "recipient" : [
    {
      "reference" : "Practitioner/example"
    }
  ],
  "sender" : {
    "reference" : "Device/example"
  },
  "payload" : [
    {
      "contentString" : "Patient example has moved away"
    }
  ]
}

```
