# BodyStructure example - QI-Core Implementation Guide v7.0.2

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **BodyStructure example**

## Example BodyStructure: BodyStructure example

| |
| :--- |
| *Page standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) |

Profile: [QICore BodyStructure](StructureDefinition-qicore-bodystructure.md)

**identifier**: `http://example.org/bodystructure/identifiers`/12345

**active**: true

**morphology**: Splenic mass

**location**: Splenic mass

**description**: 7 cm maximum diameter

### Images

| | | |
| :--- | :--- | :--- |
| - | **ContentType** | **Url** |
| * | application/dicom | [http://imaging.acme.com/wado/server?requestType=WADO&amp;wado_details](http://imaging.acme.com/wado/server?requestType=WADO&amp;wado_details) |

**patient**: [Jim Chalmers Male, DoB: 1974-12-25 ( Medical record number (use: usual, period: 2001-05-06 --> (ongoing)))](Patient-example.md)



## Resource Content

```json
{
  "resourceType" : "BodyStructure",
  "id" : "example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-bodystructure"
    ]
  },
  "identifier" : [
    {
      "system" : "http://example.org/bodystructure/identifiers",
      "value" : "12345"
    }
  ],
  "active" : true,
  "morphology" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "4147007",
        "display" : "Mass (morphologic abnormality)"
      }
    ],
    "text" : "Splenic mass"
  },
  "location" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "78961009",
        "display" : "Splenic structure (body structure)"
      }
    ],
    "text" : "Splenic mass"
  },
  "description" : "7 cm maximum diameter",
  "image" : [
    {
      "contentType" : "application/dicom",
      "url" : "http://imaging.acme.com/wado/server?requestType=WADO&amp;wado_details"
    }
  ],
  "patient" : {
    "reference" : "Patient/example"
  }
}

```
