# QI-Core Profiles - QI-Core Implementation Guide v8.0.0-ballot

## QI-Core Profiles

### QI-Core Profiles

The following table lists the QI-Core profiles that are part of the IG, which US Core profile they are derived from, if any, and the underlying FHIR resources:

| | | |
| :--- | :--- | :--- |
| **2.1.1 AdverseEvent** |   |   |
|  [QICore AdverseEvent](StructureDefinition-qicore-adverseevent.md) | — |  [AdverseEvent](http://hl7.org/fhir/R4/adverseevent.html) |
| **2.1.2 AllergyIntolerance** |   |   |
|  [QICore AllergyIntolerance](StructureDefinition-qicore-allergyintolerance.md) | [US Core AllergyIntolerance](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-allergyintolerance.html) |  [AllergyIntolerance](http://hl7.org/fhir/R4/allergyintolerance.html) |
| **2.1.3 BodyStructure** |   |   |
|  [QICore BodyStructure](StructureDefinition-qicore-bodystructure.md) | — |  [BodyStructure](http://hl7.org/fhir/R4/bodystructure.html) |
| **2.1.4 CarePlan** |   |   |
|  [QICore CarePlan](StructureDefinition-qicore-careplan.md) | [US Core CarePlan](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-careplan.html) |  [CarePlan](http://hl7.org/fhir/R4/careplan.html) |
| **2.1.5 CareTeam** |   |   |
|  [QICore CareTeam](StructureDefinition-qicore-careteam.md) | [US Core CareTeam](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-careteam.html) |  [CareTeam](http://hl7.org/fhir/R4/careteam.html) |
| **2.1.6 Claim** |   |   |
|  [QICore Claim](StructureDefinition-qicore-claim.md) | — |  [Claim](http://hl7.org/fhir/R4/claim.html) |
| **2.1.7 ClaimResponse** |   |   |
|  [QICore ClaimResponse](StructureDefinition-qicore-claimresponse.md) | — |  [ClaimResponse](http://hl7.org/fhir/R4/claimresponse.html) |
| **2.1.8 Communication** |   |   |
|  [QICore Communication](StructureDefinition-qicore-communication.md) | — |  [Communication](http://hl7.org/fhir/R4/communication.html) |
|  [QICore Communication Done](StructureDefinition-qicore-communicationdone.md) | — | — |
|  [QICore Communication Not Done](StructureDefinition-qicore-communicationnotdone.md) | — | — |
| **2.1.9 CommunicationRequest** |   |   |
|  [QICore CommunicationRequest](StructureDefinition-qicore-communicationrequest.md) | — |  [CommunicationRequest](http://hl7.org/fhir/R4/communicationrequest.html) |
| **2.1.10 Condition** |   |   |
|  [QICore Condition Encounter Diagnosis](StructureDefinition-qicore-condition-encounter-diagnosis.md) | [US Core Condition Encounter Diagnosis](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-condition-encounter-diagnosis.html) |  [Condition](http://hl7.org/fhir/R4/condition.html) |
|  [QICore Condition Problems Health Concerns](StructureDefinition-qicore-condition-problems-health-concerns.md) | [US Core Condition Problems Health Concerns](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-condition-problems-health-concerns.html) |  [Condition](http://hl7.org/fhir/R4/condition.html) |
| **2.1.11 Coverage** |   |   |
|  [QICore Coverage](StructureDefinition-qicore-coverage.md) | [US Core Coverage](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-coverage.html) |  [Coverage](http://hl7.org/fhir/R4/coverage.html) |
| **2.1.12 Device** |   |   |
|  [QICore Device](StructureDefinition-qicore-device.md) | — |  [Device](http://hl7.org/fhir/R4/device.html) |
| — | [US Core Implantable Device](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-implantable-device.html) |  [Device](http://hl7.org/fhir/R4/device.html) |
| **2.1.13 DeviceRequest** |   |   |
|  [QICore DeviceRequest](StructureDefinition-qicore-devicerequest.md) | — |  [DeviceRequest](http://hl7.org/fhir/R4/devicerequest.html) |
|  [QICore Device Requested](StructureDefinition-qicore-devicerequested.md) | — | — |
|  [QICore Device Prohibited](StructureDefinition-qicore-deviceprohibited.md) | — | — |
| **2.1.14 DeviceUseStatement** |   |   |
|  [QICore DeviceUseStatement](StructureDefinition-qicore-deviceusestatement.md) | — |  [DeviceUseStatement](http://hl7.org/fhir/R4/deviceusestatement.html) |
| **2.1.15 DiagnosticReport** |   |   |
|  [QICore DiagnosticReport Profile for Laboratory Results Reporting](StructureDefinition-qicore-diagnosticreport-lab.md)  | [US Core DiagnosticReport Profile for Laboratory Results Reporting](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-diagnosticreport-lab.html) |  [DiagnosticReport](http://hl7.org/fhir/R4/diagnosticreport.html) |
|  [QICore DiagnosticReport Profile for Report and Note Exchange](StructureDefinition-qicore-diagnosticreport-note.md) | [US Core DiagnosticReport Profile for Report and Note Exchange](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-diagnosticreport-note.html) |  [DiagnosticReport](http://hl7.org/fhir/R4/diagnosticreport.html) |
| **2.1.16 Encounter** |   |   |
|  [QICore Encounter](StructureDefinition-qicore-encounter.md) | [US Core Encounter](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-encounter.html) |  [Encounter](http://hl7.org/fhir/R4/encounter.html) |
| **2.1.17 FamilyMemberHistory** |   |   |
|  [QICore FamilyMemberHistory](StructureDefinition-qicore-familymemberhistory.md) | — |  [FamilyMemberHistory](http://hl7.org/fhir/R4/familymemberhistory.html) |
| **2.1.18 Flag** |   |   |
|  [QICore Flag](StructureDefinition-qicore-flag.md) | — |  [Flag](http://hl7.org/fhir/R4/flag.html) |
| **2.1.19 Goal** |   |   |
|  [QICore Goal](StructureDefinition-qicore-goal.md) | [US Core Goal](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-goal.html) |  [Goal](http://hl7.org/fhir/R4/goal.html) |
| **2.1.20 ImagingStudy** |   |   |
|  [QICore ImagingStudy](StructureDefinition-qicore-imagingstudy.md) | — |  [ImagingStudy](http://hl7.org/fhir/R4/imagingstudy.html) |
| **2.1.21 Immunization** |   |   |
|  [QICore Immunization](StructureDefinition-qicore-immunization.md) | [US Core Immunization](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-immunization.html) |  [Immunization](http://hl7.org/fhir/R4/immunization.html) |
|  [QICore Immunization Done](StructureDefinition-qicore-immunizationdone.md) | — | — |
|  [QICore Immunization Not Done](StructureDefinition-qicore-immunizationnotdone.md) | — | — |
| **2.1.22 ImmunizationEvaluation** |   |   |
|  [QICore ImmunizationEvaluation](StructureDefinition-qicore-immunizationevaluation.md) | — |  [ImmunizationEvaluation](http://hl7.org/fhir/R4/immunizationevaluation.html) |
| **2.1.23 ImmunizationRecommendation** |   |   |
|  [QICore ImmunizationRecommendation](StructureDefinition-qicore-immunizationrecommendation.md) | — |  [ImmunizationRecommendation](http://hl7.org/fhir/R4/immunizationrecommendation.html) |
| **2.1.24 Location** |   |   |
|  [QICore Location](StructureDefinition-qicore-location.md) | [US Core Location](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-location.html) |  [Location](http://hl7.org/fhir/R4/location.html) |
| **2.1.25 Medication** |   |   |
|  [QICore Medication](StructureDefinition-qicore-medication.md) | [US Core Medication](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-medication.html) |  [Medication](http://hl7.org/fhir/R4/medication.html) |
| **2.1.26 MedicationAdministration** |   |   |
|  [QICore MedicationAdministration](StructureDefinition-qicore-medicationadministration.md) | — |  [MedicationAdministration](http://hl7.org/fhir/R4/medicationadministration.html) |
|  [QICore MedicationAdministration Done](StructureDefinition-qicore-medicationadministrationdone.md) | — | — |
|  [QICore MedicationAdministration Not Done](StructureDefinition-qicore-medicationadministrationnotdone.md) | — | — |
| **2.1.27 MedicationDispense** |   |   |
|  [QICore MedicationDispense](StructureDefinition-qicore-medicationdispense.md) | [US Core MedicationDispense](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-medicationdispense.html) |  [MedicationDispense](http://hl7.org/fhir/R4/medicationdispense.html) |
|  [QICore MedicationDispense Done](StructureDefinition-qicore-medicationdispensedone.md) | — | — |
|  [QICore MedicationDispense Declined](StructureDefinition-qicore-medicationdispensedeclined.md) | — | — |
| **2.1.28 MedicationRequest** |   |   |
|  [QICore MedicationRequest](StructureDefinition-qicore-medicationrequest.md) | [US Core MedicationRequest](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-medicationrequest.html) |  [MedicationRequest](http://hl7.org/fhir/R4/medicationrequest.html) |
|  [QICore Medication Requested](StructureDefinition-qicore-medicationrequested.md) | — | — |
|  [QICore Medication Prohibited](StructureDefinition-qicore-medicationprohibited.md) | — | — |
| **2.1.29 MedicationStatement** |   |   |
|  [QICore MedicationStatement](StructureDefinition-qicore-medicationstatement.md) | — |  [MedicationStatement](http://hl7.org/fhir/R4/medicationstatement.html) |
| **2.1.30 NutritionOrder** |   |   |
|  [QICore NutritionOrder](StructureDefinition-qicore-nutritionorder.md) | — |  [NutritionOrder](http://hl7.org/fhir/R4/nutritionorder.html) |
| **2.1.31 Observation** |   |   |
|  [QICore Simple Observation](StructureDefinition-qicore-simple-observation.md) | [US Core Simple Observation](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-simple-observation.html) |  [Observation](http://hl7.org/fhir/R4/observation.html) |
|  [QICore NonPatient Observation](StructureDefinition-qicore-nonpatient-observation.md) | — |  [Observation](http://hl7.org/fhir/R4/observation.html) |
|  [QICore Laboratory Result Observation](StructureDefinition-qicore-observation-lab.md) | [US Core Laboratory Result Observation](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-observation-lab.html) |  [Observation](http://hl7.org/fhir/R4/observation.html) |
|  [QICore Observation Clinical Result](StructureDefinition-qicore-observation-clinical-result.md) | [US Core Observation Clinical Result](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-observation-clinical-result.html) |  [Observation](http://hl7.org/fhir/R4/observation.html) |
|  [QICore Observation Screening Assessment](StructureDefinition-qicore-observation-screening-assessment.md) | [US Core Observation Screening Assessment](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-observation-screening-assessment.html) |  [Observation](http://hl7.org/fhir/R4/observation.html) |
| — | [US Core Vital Signs](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-vital-signs.html) | [Observation](http://hl7.org/fhir/R4/observation.html) |
| — | [US Core Blood Pressure](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-blood-pressure.html) | [Observation](http://hl7.org/fhir/R4/observation.html) |
| — | [US Core BMI](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-bmi.html) | [Observation](http://hl7.org/fhir/R4/observation.html) |
| — | [US Core Body Height](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-body-height.html) | [Observation](http://hl7.org/fhir/R4/observation.html) |
| — | [US Core Body Temperature](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-body-temperature.html) | [Observation](http://hl7.org/fhir/R4/observation.html) |
| — | [US Core Body Weight](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-body-weight.html) | [Observation](http://hl7.org/fhir/R4/observation.html) |
| — | [US Core Head Circumference](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-head-circumference.html) | [Observation](http://hl7.org/fhir/R4/observation.html) |
| — | [US Core Heart Rate](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-heart-rate.html) | [Observation](http://hl7.org/fhir/R4/observation.html) |
| — | [US Core Pediatric BMI for Age Observation](http://hl7.org/fhir/us/core/STU8/StructureDefinition-pediatric-bmi-for-age.html) | [Observation](http://hl7.org/fhir/R4/observation.html) |
| — | [US Core Pediatric Head Occipital-frontal Circumference Percentile](http://hl7.org/fhir/us/core/STU8/StructureDefinition-head-occipital-frontal-circumference-percentile.html) | [Observation](http://hl7.org/fhir/R4/observation.html) |
| — | [US Core Pediatric Weight for Height Observation](http://hl7.org/fhir/us/core/STU8/StructureDefinition-pediatric-weight-for-height.html) | [Observation](http://hl7.org/fhir/R4/observation.html) |
| — | [US Core Pulse Oximetry](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-pulse-oximetry.html) | [Observation](http://hl7.org/fhir/R4/observation.html) |
| — | [US Core Respiratory Rate](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-respiratory-rate.html) | [Observation](http://hl7.org/fhir/R4/observation.html) |
| — | [US Core Smoking Status](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-smokingstatus.html) | [Observation](http://hl7.org/fhir/R4/observation.html) |
| — | [US Core Observation Occupation](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-observation-occupation.html) | [Observation](http://hl7.org/fhir/R4/observation.html) |
| — | [US Core Observation Sexual Orientation](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-observation-sexual-orientation.html) | [Observation](http://hl7.org/fhir/R4/observation.html) |
| — | [US Core Observation Pregnancy Intent](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-observation-pregnancyintent.html) | [Observation](http://hl7.org/fhir/R4/observation.html) |
| — | [US Core Observation Pregnancy Status](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-observation-pregnancystatus.html) | [Observation](http://hl7.org/fhir/R4/observation.html) |
| — | [US Core Average Blood Pressure](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-average-blood-pressure.html) | [Observation](http://hl7.org/fhir/R4/observation.html) |
| — | [US Core Care Experience Preference](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-care-experience-preference.html) | [Observation](http://hl7.org/fhir/R4/observation.html) |
| — | [US Core Treatment Intervention Preference](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-treatment-intervention-preference.html) | [Observation](http://hl7.org/fhir/R4/observation.html) |
| **2.1.32 Organization** |   |   |
|  [QICore Organization](StructureDefinition-qicore-organization.md) | [US Core Organization](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-organization.html) |  [Organization](http://hl7.org/fhir/R4/organization.html) |
| **2.1.33 Patient** |   |   |
|  [QICore Patient](StructureDefinition-qicore-patient.md) | [US Core Patient](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-patient.html) |  [Patient](http://hl7.org/fhir/R4/patient.html) |
| **2.1.34 Practitioner** |   |   |
|  [QICore Practitioner](StructureDefinition-qicore-practitioner.md) | [US Core Practitioner](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-practitioner.html) |  [Practitioner](http://hl7.org/fhir/R4/practitioner.html) |
| **2.1.35 PractitionerRole** |   |   |
|  [QICore PractitionerRole](StructureDefinition-qicore-practitionerrole.md) | [US Core PractitionerRole](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-practitionerrole.html) |  [PractitionerRole](http://hl7.org/fhir/R4/practitionerrole.html) |
| **2.1.36 Procedure** |   |   |
|  [QICore Procedure](StructureDefinition-qicore-procedure.md) | [US Core Procedure](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-procedure.html) |  [Procedure](http://hl7.org/fhir/R4/procedure.html) |
|  [QICore Procedure Done](StructureDefinition-qicore-proceduredone.md) | — | — |
|  [QICore Procedure Not Done](StructureDefinition-qicore-procedurenotdone.md) | — | — |
| **2.1.37 QuestionnaireResponse** |   |   |
|  [QICore QuestionnaireResponse](StructureDefinition-qicore-questionnaireresponse.md) | [US Core QuestionnaireResponse](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-questionnaireresponse.html) |  [QuestionnaireResponse](http://hl7.org/fhir/R4/questionnaireresponse.html) |
| **2.1.38 RelatedPerson** |   |   |
|  [QICore RelatedPerson](StructureDefinition-qicore-relatedperson.md) |  [US Core RelatedPerson](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-relatedperson.html) |  [RelatedPerson](http://hl7.org/fhir/R4/relatedperson.html) |
| **2.1.39 ServiceRequest** |   |   |
|  [QICore ServiceRequest](StructureDefinition-qicore-servicerequest.md) |  [US Core ServiceRequest](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-servicerequest.html) |  [ServiceRequest](http://hl7.org/fhir/R4/servicerequest.html) |
|  [QICore Service Requested](StructureDefinition-qicore-servicerequested.md) | — | — |
|  [QICore Service Prohibited](StructureDefinition-qicore-serviceprohibited.md) | — | — |
| **2.1.40 Specimen** |   |   |
| — | [US Core Specimen](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-specimen.html) |  [Specimen](http://hl7.org/fhir/R4/specimen.html) |
| **2.1.41 Substance** |   |   |
|  [QICore Substance](StructureDefinition-qicore-substance.md) | — |  [Substance](http://hl7.org/fhir/R4/substance.html) |
| **2.1.42 Task** |   |   |
|  [QICore Task](StructureDefinition-qicore-task.md) | — |  [Task](http://hl7.org/fhir/R4/task.html) |
|  [QICore Task Done](StructureDefinition-qicore-taskdone.md) | — | — |
|  [QICore Task Rejected](StructureDefinition-qicore-taskrejected.md) | — | — |

### Referencing QI-Core Profiles

There are a number of QI-Core profiles inherited directly from US Core profiles, if any, or other FHIR resources (i.e. US Core Implantable Device Profile, FHIR Vital Signs, US Core Smoking Status etc.) and the underlying Reference elements can address the US Core or FHIR profiles for the items referenced. For any other references to base FHIR resources or not formally defined in a QI-Core Profile, the referenced resource **SHALL** be a QI-Core Profile if a QI-Core Profile exists for the resource type. For example, US Core Smoking Status references US Core Patient profile, the reference to Patient **SHALL** be a valid QI-Core Patient.

Note to Implementers: QI-Core profiles have been developed with the principle that if the profiles only need to provide references to QI-Core Profiles, that is insufficient to require individual QI-Core profiles for all US Core profiles. There are edge cases using this approach where the FHIR validator would not validate an assumption made by the measure author, such as that an encounter traced through an observation is a QI-Core Encounter. We think that general validation of all the resources provided to the context of a measure evaluation can address that risk without the need for deriving specific profiles that only constraint reference types. We seek feedback on this point.

This change will strengthen the requirement to use a QI-Core profile when using a base FHIR or US Core profile not formally defined in QI-Core and to use QI-Core profiles as referenced resources if a QI-Core Profile exists for that resource.

