# QI-Core Examples - QI-Core Implementation Guide v8.0.0-ballot

## QI-Core Examples

**QICoreAdverseEvent**

* [Mild Rash Example](AdverseEvent-example.md)

**QICoreAllergyIntolerance**

* [Typical Food Allergy](AllergyIntolerance-example.md)
* [Refuted Food Allergy](AllergyIntolerance-example-refuted.md)

**QICoreBodyStructure**

* [BodyStructure example identifying a specific tumor or lesion](BodyStructure-example.md)

**QICoreCarePlan**

* [Assessment and care plan for a pregnancy](CarePlan-example.md)

**QICoreCareTeam**

* [Example of a CareTeam involved in the delivery of care for a pregnancy](CareTeam-example.md)

**QICoreClaim**

* [Simple Vision Claim](Claim-example.md)

**QICoreClaimResponse**

* [Simple Vision ClaimResponse](ClaimResponse-example.md)

**QICoreCommunication**

* [Written Alert Example](Communication-example.md)

**QICoreCommunicationNotDone**

* [Negation Example](Communication-negation-example.md)

**QICoreCommunicationRequest**

* [CommunicationRequest Example](CommunicationRequest-example.md)

**QICoreConditionEncounterDiagnosis**

* [Severe Burn Example](Condition-example.md)
* [Appendicitis Example](Condition-appendicitis-example.md)

**QICoreConditionProblemsHealthConcerns**

* [Patient with concerns of becoming fat](Condition-health-concern-example.md)

**QICoreCoverage**

* [General Person Primary Coverage Example](Coverage-example.md)
* [General Subscriber ID Coverage Example](Coverage-example-new.md)

**QICoreDevice**

* [General Device Example](Device-example.md)

**QICoreDeviceNotRequested**

* [Negation Example with valueset](DeviceRequest-negation-example.md)
* [Negation Example with code](DeviceRequest-negation-with-code-example.md)

**QICoreDeviceRequest**

* [General DeviceRequest Example](DeviceRequest-example.md)

**QICoreDeviceUseStatement**

* [The provision of a wheelchair to a patient example](DeviceUseStatement-example.md)

**QICoreDiagnosticReportLab**

* [Blood Panel Example](DiagnosticReport-example.md)

**QICoreDiagnosticReportNote**

* [Radiology Diagnostic Report Example](DiagnosticReport-note-example.md)

**QICoreEncounter**

* [Inpatient Admission for Appendicitis](Encounter-example.md)

**QICoreFamilyMemberHistory**

* [Father Died of Heart Attack Example](FamilyMemberHistory-example.md)

**QICoreFlag**

* [Large Dog Warning Example](Flag-example.md)

**QICoreGoal**

* [Weight Loss Example](Goal-example.md)

**QICoreImagingStudy**

* [Chest CT](ImagingStudy-example.md)

**QICoreImmunization**

* [Example of Influenza immunization shot](Immunization-example.md)

**QICoreImmunizationNotDone**

* [Negation Example using valueset reference](Immunization-negation-example.md)
* [Negation Example using coding](Immunization-negation-example-code.md)

**QICoreImmunizationEvaluation**

* [Example of immunization evaluation](ImmunizationEvaluation-example.md)

**QICoreImmunizationRecommendation**

* [Example of immunizationrecommendation using a vaccine code](ImmunizationRecommendation-example.md)

**QICoreMedication**

* [Example of an IV medication - Alemtuzumab](Medication-example.md)

**QICoreMedicationAdministration**

* [Inhalant Example](MedicationAdministration-example.md)
* [Cumulative Duration Example](MedicationAdministration-cmd-example.md)

**QICoreMedicationAdministrationNotDone**

* [Medication not administered using a value set to indicate what was not administered](MedicationAdministration-negation-example.md)
* [Medication not administered using a code to indicate that a particular medication was not administered](MedicationAdministration-negation-with-code-example.md)

**QICoreMedicationDispense**

* [Penicillin MedicationDispense Example](MedicationDispense-example.md)
* [Cumulative Medication Dispense Example](MedicationDispense-cmd-example.md)

**QICoreMedicationDispenseDeclined**

* [Negation Example with valueset](MedicationDispense-negation-example.md)
* [Negation Example with code](MedicationDispense-negation-with-code-example.md)

**QICoreMedicationNotRequested**

* [Negation Example using Valueset](MedicationRequest-negation-example.md)
* [Negation Example using code](MedicationRequest-negation-example-code.md)

**QICoreMedicationRequest**

* [Penicillin MedicationRequest Example](MedicationRequest-example.md)
* [Cumulative Medication Duration Example](MedicationRequest-cmd-example.md)
* [Patient Reported MedicationRequest Example](MedicationRequest-patient-reported-example.md)
* [Patient Requested MedicationRequest Example](MedicationRequest-patient-requester-example.md)
* [Practitioner Ordered MedicationRequest Example](MedicationRequest-practitioner-ordered-example.md)

**QICoreMedicationStatement**

* [Penicillin MedicationStatement Example](MedicationStatement-example.md)

**QICoreNutritionOrder**

* [Diabetic diet example](NutritionOrder-example.md)

**QICoreSimpleObservation**

* [Frailty Observation Example](Observation-example-frailty.md)
* [Gestational Age at Birth Example](Observation-example-gestation.md)
* [Date and Time of Obstetric Delivery Example](Observation-example-obstetric-delivery.md)
* [Delivery Date Estimated Example](Observation-example-delivery-date-estimate.md)
* [Number of Preterm Births Example](Observation-example-preterm-births.md)
* [Number of Term Births Example](Observation-example-births.md)
* [Number of Parity Example](Observation-example-parity.md)
* [Number of Pregnancies Example](Observation-example-pregnancies.md)

**QICoreNonPatientObservation**

* [Hemodialysis Machine Availability](Observation-example-nonpatient-hemodialysis-machine.md)
* [Hospital Bed Availability](Observation-example-nonpatient-hospital-bed.md)
* [Mechanical Ventilator Availability](Observation-example-nonpatient-mechanical-ventilator.md)

**QICoreLaboratoryResultObservation**

* [Glucose Lab Result Observation](Observation-laboratory-result-observation-example-blood-glucose.md)

**QICoreObservationClinicalResult**

* [Heart Rate Rhythm Clinical Result Observation](Observation-clinical-result-heart-rate-rhythm.md)

**QICoreObservationScreeningAssessment**

* [10 minute Apgar Heart Rate Screening Assessment Observation](Observation-example-screening-assessment-10-minute-apgar-heart-rate.md)

**QICoreOrganization**

* [HL7 Organization Example](Organization-example.md)

**QICorePatient**

* [Basic Patient Example](Patient-example.md)
* [Senior Patient Example](Patient-example-2.md)
* [Infant Patient Example](Patient-infant-example.md)

**QICorePractitioner**

* [Referring Practitioner Example](Practitioner-example.md)

**QICorePractitionerRole**

* [PractitionerRole Example](StructureDefinition-qicore-practitionerrole.md)

**QICoreProcedure**

* [Appendectomy Example](Procedure-example.md)

**QICoreProcedureNotDone**

* [Negation Example with valuset](Procedure-negation-example.md)
* [Negation Example with code](Procedure-negation-with-code-example.md)

**QICoreRelatedPerson**

* [Emergency Contact Example](RelatedPerson-example.md)

**QICoreServiceNotRequested**

* [Negation Example with valueset](ServiceRequest-negation-example.md)
* [Negation Example with code](ServiceRequest-negation-example-code.md)

**QICoreServiceRequest**

* [Request for Appendectomy Example](ServiceRequest-example.md)
* [Request for Myringotomy Procedure Example](ServiceRequest-myringotomy-example.md)

**QICoreSubstance**

* [Honey Bee venom (apitoxin) Example](Substance-example.md)

**QICoreTask**

* [Task Example](Task-example.md)

**QICoreTaskRejected**

* [Task rejected using a value set to indicate what was not done](Task-negation-example.md)
* [Task rejected using a code to indicate what was not done](Task-negation-with-code-example.md)

**Additional Examples**

* [ODH Example](Observation-example.md)

