# Positive MedicationRequest Status - QI-Core Implementation Guide v8.0.0-ballot

## ValueSet: Positive MedicationRequest Status 

 
This value set defines the set of codes that indicate a positive medication request status (i.e. codes that a medication is proposed, planned, or ordered) 

 **References** 

* [QICore Medication Prohibited](StructureDefinition-qicore-medicationprohibited.md)
* [QICore MedicationRequested](StructureDefinition-qicore-medicationrequested.md)

### Logical Definition (CLD)

 

### Expansion

-------

 [Description of the above table(s)](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#terminology). 



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "qicore-positive-medicationrequest-status",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/ValueSet/qicore-positive-medicationrequest-status",
  "version" : "8.0.0-ballot",
  "name" : "PositiveMedicationRequestStatus",
  "title" : "Positive MedicationRequest Status",
  "status" : "active",
  "experimental" : false,
  "date" : "2018-12-05T00:00:00+00:00",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "This value set defines the set of codes that indicate a positive medication request status (i.e. codes that a medication is proposed, planned, or ordered)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "purpose" : "This value set was defined to support the set of medication request statuses in FHIR that indicate a positive status (i.e. all the codes from the http://terminology.hl7.org/CodeSystem/medicationrequest-status code system that indicate a medication is proposed, planned, or ordered).",
  "compose" : {
    "include" : [
      {
        "system" : "http://hl7.org/fhir/CodeSystem/medicationrequest-status",
        "concept" : [
          {
            "code" : "active",
            "display" : "Active"
          },
          {
            "code" : "on-hold",
            "display" : "On Hold"
          },
          {
            "code" : "cancelled",
            "display" : "Cancelled"
          },
          {
            "code" : "completed",
            "display" : "Completed"
          },
          {
            "code" : "stopped",
            "display" : "Stopped"
          },
          {
            "code" : "draft",
            "display" : "Draft"
          }
        ]
      }
    ]
  }
}

```
