# QICore Negation Reason Codes - QI-Core Implementation Guide v8.0.0-ballot

## ValueSet: QICore Negation Reason Codes 

 
This value set defines the set of codes that can be used to indicate the reason an action was not taken 

 **References** 

* [QICore Communication Not Done](StructureDefinition-qicore-communicationnotdone.md)
* [QICore Device Prohibited](StructureDefinition-qicore-deviceprohibited.md)
* [QICore Immunization Not Done](StructureDefinition-qicore-immunizationnotdone.md)
* [QICore MedicationAdministration Not Done](StructureDefinition-qicore-medicationadministrationnotdone.md)
* [QICore MedicationDispense Declined](StructureDefinition-qicore-medicationdispensedeclined.md)
* [QICore Medication Prohibited](StructureDefinition-qicore-medicationprohibited.md)
* [QICore Procedure Not Done](StructureDefinition-qicore-procedurenotdone.md)
* [QICore Task Rejected](StructureDefinition-qicore-taskrejected.md)

### Logical Definition (CLD)

 

### Expansion

-------

 [Description of the above table(s)](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#terminology). 



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "qicore-negation-reason",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/ValueSet/qicore-negation-reason",
  "version" : "8.0.0-ballot",
  "name" : "NegationReasonCodes",
  "title" : "QICore Negation Reason Codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2018-12-05",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "This value set defines the set of codes that can be used to indicate the reason an action was not taken",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "purpose" : "This value set was defined to support identifying any of the possible negation reason codes as part of QICore profiles. The value set is composed of the codes from [Medical Reason Not Done SCT](http://cts.nlm.nih.gov/fhir/2.16.840.1.113883.3.526.3.1007), [Patient Reason Not Done SCT](http://cts.nlm.nih.gov/fhir/2.16.840.1.113883.3.526.3.1008), and concepts that are similar to [System Reason](http://cts.nlm.nih.gov/fhir/2.16.840.1.113883.3.526.3.1009) as defined and available in the Value Set Authority Center. This value set was defined to support identifying any of the possible negation reason codes as part of QICore profiles. The value set exists to support measure developers need to reference medical, patient, and system reasons for processes not performed and it is a grouping of VSAC value sets.  Therefore, retain binding to the QI-Core value set in the profiles that use the extension.  It only exists to support bindings to capture a reason for negative.",
  "copyright" : "This value set includes content from SNOMED CT, which is copyright © 2002+ International Health Terminology Standards Development Organisation (IHTSDO), and distributed by agreement between IHTSDO and HL7. Implementer use of SNOMED CT is not covered by this agreement",
  "compose" : {
    "include" : [
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.526.3.1007"
        ]
      },
      {
        "valueSet" : [
          "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113883.3.526.3.1008"
        ]
      },
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "107724000",
            "display" : "Patient transfer (procedure)"
          },
          {
            "code" : "182856006",
            "display" : "Drug not available - out of stock (finding)"
          },
          {
            "code" : "182857002",
            "display" : "Drug not available-off market (finding)"
          },
          {
            "code" : "185335007",
            "display" : "Appointment canceled by hospital (finding)"
          },
          {
            "code" : "224194003",
            "display" : "Not entitled to benefits (finding)"
          },
          {
            "code" : "224198000",
            "display" : "Loss of benefits (finding)"
          },
          {
            "code" : "242990004",
            "display" : "Drug not available for administration (event)"
          },
          {
            "code" : "266756008",
            "display" : "Medical care unavailable (situation)"
          },
          {
            "code" : "270459005",
            "display" : "Patient on waiting list (finding)"
          },
          {
            "code" : "309017000",
            "display" : "Referred to doctor (finding)"
          },
          {
            "code" : "419808006",
            "display" : "Finding related to health insurance issues (finding)"
          },
          {
            "code" : "424553001",
            "display" : "Uninsured medical expenses (finding)"
          }
        ]
      }
    ]
  }
}

```
