# QICore ServiceRequested - QI-Core Implementation Guide v8.0.0-ballot

## Resource Profile: QICore ServiceRequested 

 
Positive profile of ServiceRequest for decision support/quality metrics. Indicates that a service is proposed, planned, or ordered. 

"Must Have", "QI Elements" and "primary code path" are defined in the
[QI-Core Must Support section](index.md#mustsupport-flag).

**Must Have:**
* intent: (QI) proposal | plan | directive | order | original-order | reflex-order | filler-order | instance-order | option
* code: (QI) What is being requested/ordered
* subject: (QI) Individual or Entity the service is ordered for
* status: (QI) draft | active | on-hold | completed

**QI Elements:**
* code.extension(codeOptions): (QI) Url of a value set of candidate services
* reasonCode: (QI) Explanation/Justification for procedure or service
* occurrence[x]: (QI) When service should occur
* authoredOn: (QI) Date request signed
* doNotPerform: (QI) True if service/procedure should not be performed
* reasonReference: (QI) Explanation/Justification for service or service

**Primary code path:**code

(PCPath) This element is the primary code path for this resource
[CQL Retrieve](https://cql.hl7.org/02-authorsguide.html#retrieve)

### Guidance

 Reference Guidance for use of the Service Request profile can be found[here.](http://hl7.org/fhir/us/core/STU8/StructureDefinition-us-core-servicerequest.html#mandatory-and-must-support-data-elements)
* See the [Social Determinants of Health (SDOH)](https://hl7.org/fhir/us/core/sdoh.html) Guidance Page for more information when exchanging Social Determinants of Health (SDOH) Service Requests.
* The `ServiceRequest.category` binding must support at a minimum the [US Core ServiceRequest Category Codes](http://hl7.org/fhir/us/core/STU8/ValueSet-us-core-servicerequest-category.html). However, this valueset can be treated as [extensible](http://hl7.org/fhir/R4/terminologies.html#extensible) and other category codes can be used instead.
* The `ServiceRequest.code` valueset is broad to accommodate a wide variety of use cases and should be constrained to a subset for a particular use case or domain. (for example, LOINC for laboratory orders.)
* The `ServiceRequest.subject` is Must Support with Must Support reference to QI-Core Patient
 

**Usage**
The ServiceRequest profile defines the conformance expectations for a ServiceRequest, regardless of whether it is a positive or negative statement. The ServiceRequested and ServiceNotRequested profiles represent the positive and negative statements for a service request. 

To create an expression indicating the existence of a service request, use the profile [QICoreServiceRequested](StructureDefinition-qicore-servicerequested.md); to specifically request information that a ServiceRequest intentionally did not occur for a medical, patient or system reason, use the profile [QICoreServiceProhibited](StructureDefinition-qicore-serviceprohibited.md).

The following example illustrates the use of the ServiceRequested profile:

```
define "Intermittent Pneumatic Compression Devices Ordered":
  ["ServiceRequested": "Application of intermittent pneumatic compression devices (IPC)"] DeviceOrdered
    where DeviceOrdered.intent = 'order'
```

Note that the doNotPerform and statuses indicating positive intent are implied by the use of the ServiceRequested profile.

 See the[patterns](patterns.md)page for implementation and usage patterns. 

### Examples

 

| |
| :--- |
| [ServiceRequested for Appendectomy Example](ServiceRequest-servicerequested-example.md) |
| [Request for Graduated compression elastic hosiery (specific code)](ServiceRequest-proposal-example-code.md) |
| [Request for Intermittent pneumatic compression devices (value set)](ServiceRequest-proposal-example.md) |

 

**Usages:**

* Examples for this Profile: [ServiceRequest/proposal-example-code](ServiceRequest-proposal-example-code.md), [ServiceRequest/proposal-example](ServiceRequest-proposal-example.md) and [ServiceRequest/servicerequested-example](ServiceRequest-servicerequested-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.qicore|current/StructureDefinition/qicore-servicerequested)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-qicore-servicerequested.csv), [Excel](../StructureDefinition-qicore-servicerequested.xlsx), [Schematron](../StructureDefinition-qicore-servicerequested.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "qicore-servicerequested",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-primaryCodePath",
      "valueString" : "code"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isIncluded",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isRetrievable",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-label",
      "valueString" : "ServiceRequested"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-servicerequested",
  "version" : "8.0.0-ballot",
  "name" : "QICoreServiceRequested",
  "title" : "QICore ServiceRequested",
  "status" : "active",
  "experimental" : false,
  "date" : "2018-08-22",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Positive profile of ServiceRequest for decision support/quality metrics. Indicates that a service is proposed, planned, or ordered.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "quick",
      "uri" : "http://siframework.org/cqf",
      "name" : "Quality Improvement and Clinical Knowledge (QUICK)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "ServiceRequest",
  "baseDefinition" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-servicerequest",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ServiceRequest",
        "path" : "ServiceRequest"
      },
      {
        "id" : "ServiceRequest.status",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "ServiceRequest.status",
        "short" : "(QI) draft | active | on-hold | completed",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/qicore/ValueSet/qicore-positive-request-status"
        }
      },
      {
        "id" : "ServiceRequest.doNotPerform",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "ServiceRequest.doNotPerform",
        "short" : "(QI) True if service/procedure should not be performed",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "boolean"
          }
        ],
        "fixedBoolean" : false
      }
    ]
  }
}

```
