# QICore RelatedPerson - QI-Core Implementation Guide v8.0.0-ballot

## Resource Profile: QICore RelatedPerson 

 
Profile of RelatedPerson for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. 

"Must Have", "QI Elements" and "primary code path" are defined in the
[QI-Core Must Support section](index.md#mustsupport-flag).

**Must Have:**
* active: (QI) Whether this related person's record is in active use
* patient: (QI) The patient this person is related to

**QI Elements:**
* name: (QI) A name associated with the person
* telecom: (QI) A contact detail for the person
* relationship: (QI) The nature of the relationship

**Primary code path:**relationship

(PCPath) This element is the primary code path for this resource
[CQL Retrieve](https://cql.hl7.org/02-authorsguide.html#retrieve)

**Usage**
 See the[patterns](patterns.md)page for implementation and usage patterns. 

### Examples

 

| |
| :--- |
| [Emergency Contact Example](RelatedPerson-example.md) |

 

**Usages:**

* Refer to this Profile: [QICore AdverseEvent](StructureDefinition-qicore-adverseevent.md), [QICore CareTeam](StructureDefinition-qicore-careteam.md), [QICore Claim](StructureDefinition-qicore-claim.md), [QICore Communication](StructureDefinition-qicore-communication.md)...Show 12 more,[QICore CommunicationRequest](StructureDefinition-qicore-communicationrequest.md),[QICore Coverage](StructureDefinition-qicore-coverage.md),[QICore Encounter](StructureDefinition-qicore-encounter.md),[QICore ImagingStudy](StructureDefinition-qicore-imagingstudy.md),[QICore MedicationRequest](StructureDefinition-qicore-medicationrequest.md),[QICore MedicationStatement](StructureDefinition-qicore-medicationstatement.md),[QICore NonPatient Observation](StructureDefinition-qicore-nonpatient-observation.md),[QICore Observation Screening Assessment](StructureDefinition-qicore-observation-screening-assessment.md),[QICore Procedure](StructureDefinition-qicore-procedure.md),[QICore QuestionnaireResponse](StructureDefinition-qicore-questionnaireresponse.md),[QICore ServiceRequest](StructureDefinition-qicore-servicerequest.md)and[QICore Simple Observation](StructureDefinition-qicore-simple-observation.md)
* Examples for this Profile: [RelatedPerson/example](RelatedPerson-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.qicore|current/StructureDefinition/qicore-relatedperson)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-qicore-relatedperson.csv), [Excel](../StructureDefinition-qicore-relatedperson.xlsx), [Schematron](../StructureDefinition-qicore-relatedperson.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "qicore-relatedperson",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-primaryCodePath",
      "valueString" : "relationship"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isIncluded",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isRetrievable",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-label",
      "valueString" : "RelatedPerson"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-relatedperson",
  "version" : "8.0.0-ballot",
  "name" : "QICoreRelatedPerson",
  "title" : "QICore RelatedPerson",
  "status" : "active",
  "experimental" : false,
  "date" : "2018-08-22",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Profile of RelatedPerson for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "RelatedPerson",
  "baseDefinition" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-relatedperson",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "RelatedPerson",
        "path" : "RelatedPerson"
      },
      {
        "id" : "RelatedPerson.active",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "RelatedPerson.active",
        "short" : "(QI) Whether this related person's record is in active use",
        "min" : 1
      },
      {
        "id" : "RelatedPerson.patient",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "RelatedPerson.patient",
        "short" : "(QI) The patient this person is related to",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient"
            ]
          }
        ]
      },
      {
        "id" : "RelatedPerson.relationship",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "RelatedPerson.relationship",
        "short" : "(QI) The nature of the relationship",
        "condition" : ["us-core-14"]
      },
      {
        "id" : "RelatedPerson.name",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "RelatedPerson.name",
        "short" : "(QI) A name associated with the person",
        "condition" : ["us-core-14"]
      },
      {
        "id" : "RelatedPerson.telecom",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "RelatedPerson.telecom",
        "short" : "(QI) A contact detail for the person"
      },
      {
        "id" : "RelatedPerson.address",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/core/StructureDefinition/uscdi-requirement",
            "valueBoolean" : true
          }
        ],
        "path" : "RelatedPerson.address",
        "short" : "(QI) Address where the related person can be contacted or visited"
      }
    ]
  }
}

```
