# QICore MedicationRequest - QI-Core Implementation Guide v8.0.0-ballot

## Resource Profile: QICore MedicationRequest 

 
Profile of MedicationRequest for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors. 

"Must Have", "QI Elements" and "primary code path" are defined in the
[QI-Core Must Support section](index.md#mustsupport-flag).

**Must Have:**
* subject: (QI) Who or group medication request is for
* intent: (QI) proposal | plan | order | original-order | reflex-order | filler-order | instance-order | option
* status: (QI) active | on-hold | cancelled | completed | entered-in-error | stopped | draft | unknown
* medication[x]: (QI) Medication to be taken

**QI Elements:**
* reasonCode: (QI) Reason or indication for ordering or not ordering the medication
* authoredOn: (QI) When request was initially authored
* requester: (QI) Who/What requested the Request
* extension(medicationAdherence): (QI) Reported adherence to prescribed medication instructions.
* encounter: (QI) Encounter created as part of encounter/admission/stay
* dispenseRequest: (QI) Medication supply authorization
* reasonReference: (QI) QI-Core Condition or Observation that supports the prescription
* dosageInstruction: (QI) How medication should be taken
* doNotPerform: (QI) True if the order is not to provide the medication
* reported[x]: (QI) Reported rather than primary record

**Primary code path:**medication

(PCPath) This element is the primary code path for this resource
[CQL Retrieve](https://cql.hl7.org/02-authorsguide.html#retrieve)

**Usage**
The MedicationRequest profile defines the conformance expectations for a MedicationRequest, regardless of whether it is a positive or negative statement. The MedicationRequested and MedicationNotRequested profiles represent the positive and negative statements for a medication order.

To create an expression indicating the existence of a medication request, use the profile [QICoreMedicationRequested](StructureDefinition-qicore-medicationrequested.md); to specifically request information that a MedicationRequest intentionally did not occur for a medical, patient or system reason, use the profile [QICoreMedicationProhibited](StructureDefinition-qicore-medicationprohibited.md).

The following example illustrates the use of the MedicationRequest profile:

```
define "Antithrombotic Therapy at Discharge":
  ["MedicationRequest": medication in "Antithrombotic Therapy"] Antithrombotic
    where (Antithrombotic.isCommunity() or Antithrombotic.isDischarge())
      and Antithrombotic.status in { 'active', 'completed' }
      and Antithrombotic.intent = 'order'
      and Antithrombotic.doNotPerform is not true
```

 See the[patterns](patterns.md)page for implementation and usage patterns. 

### Examples

 

| |
| :--- |
| [Penicillin MedicationRequest Example](MedicationRequest-example.md) |
| [Cumulative Medication Duration Example](MedicationRequest-cmd-example.md) |
| [Patient Reported MedicationRequest Example](MedicationRequest-patient-reported-example.md) |
| [Patient Requested MedicationRequest Example](MedicationRequest-patient-requester-example.md) |
| [Practitioner Ordered MedicationRequest Example](MedicationRequest-practitioner-ordered-example.md) |

 

**Usages:**

* Derived from this Profile: [QICore Medication Prohibited](StructureDefinition-qicore-medicationprohibited.md) and [QICore MedicationRequested](StructureDefinition-qicore-medicationrequested.md)
* Refer to this Profile: [QICore Claim](StructureDefinition-qicore-claim.md), [QICore DiagnosticReport Profile for Laboratory Results Reporting](StructureDefinition-qicore-diagnosticreport-lab.md), [QICore MedicationAdministration](StructureDefinition-qicore-medicationadministration.md) and [QICore MedicationDispense](StructureDefinition-qicore-medicationdispense.md)
* Examples for this Profile: [MedicationRequest/example](MedicationRequest-example.md), [MedicationRequest/patient-reported-example](MedicationRequest-patient-reported-example.md), [MedicationRequest/patient-requester-example](MedicationRequest-patient-requester-example.md) and [MedicationRequest/practitioner-ordered-example](MedicationRequest-practitioner-ordered-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.qicore|current/StructureDefinition/qicore-medicationrequest)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-qicore-medicationrequest.csv), [Excel](../StructureDefinition-qicore-medicationrequest.xlsx), [Schematron](../StructureDefinition-qicore-medicationrequest.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "qicore-medicationrequest",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-primaryCodePath",
      "valueString" : "medication"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isIncluded",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isRetrievable",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-label",
      "valueString" : "MedicationRequest"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medicationrequest",
  "version" : "8.0.0-ballot",
  "name" : "QICoreMedicationRequest",
  "title" : "QICore MedicationRequest",
  "status" : "active",
  "experimental" : false,
  "date" : "2018-08-22",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Profile of MedicationRequest for decision support/quality metrics. Defines the core set of elements and extensions for quality rule and measure authors.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "script10.6",
      "uri" : "http://ncpdp.org/SCRIPT10_6",
      "name" : "Mapping to NCPDP SCRIPT 10.6"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MedicationRequest",
  "baseDefinition" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medicationrequest",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationRequest",
        "path" : "MedicationRequest",
        "short" : "Ordering of medication for patient or group",
        "constraint" : [
          {
            "key" : "mrq-1",
            "severity" : "error",
            "human" : "To indicate what medication, either a reference to a Medication, or either at least one coding in the medication or a codeOperations extension shall be provided",
            "expression" : "(medication is Reference).not() implies medication.extension('http://hl7.org/fhir/StructureDefinition/codeOptions').exists() xor medication.coding.exists()",
            "xpath" : "exists(f:extension)"
          }
        ]
      },
      {
        "id" : "MedicationRequest.extension:medicationAdherence",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationRequest.extension",
        "sliceName" : "medicationAdherence",
        "short" : "(QI) Reported adherence to prescribed medication instructions.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medication-adherence"
            ]
          }
        ],
        "mustSupport" : false
      },
      {
        "id" : "MedicationRequest.status",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationRequest.status",
        "short" : "(QI) active | on-hold | cancelled | completed | entered-in-error | stopped | draft | unknown"
      },
      {
        "id" : "MedicationRequest.intent",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationRequest.intent",
        "short" : "(QI) proposal | plan | order | original-order | reflex-order | filler-order | instance-order | option"
      },
      {
        "id" : "MedicationRequest.doNotPerform",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationRequest.doNotPerform",
        "short" : "(QI) True if the order is not to provide the medication",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "boolean"
          }
        ]
      },
      {
        "id" : "MedicationRequest.reported[x]",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationRequest.reported[x]",
        "short" : "(QI) Reported rather than primary record",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                "valueBoolean" : true
              }
            ],
            "code" : "boolean"
          },
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-practitioner",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-practitionerrole",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-relatedperson"
            ],
            "_targetProfile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                    "valueBoolean" : true
                  }
                ]
              }
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationRequest.medication[x]",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationRequest.medication[x]",
        "short" : "(QI) Medication to be taken",
        "condition" : ["mrq-1"],
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://cts.nlm.nih.gov/fhir/ValueSet/2.16.840.1.113762.1.4.1010.4"
        }
      },
      {
        "id" : "MedicationRequest.medication[x].extension:codeOptions",
        "path" : "MedicationRequest.medication[x].extension",
        "sliceName" : "codeOptions",
        "short" : "(QI) Url of a value set of candidate medications",
        "definition" : "A logical reference (e.g. a reference to ValueSet.url) to a value set/version that identifies a set of possible coded values representing the medication.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/codeOptions|8.0.0-ballot"
            ]
          }
        ],
        "condition" : ["mrq-1"]
      },
      {
        "id" : "MedicationRequest.subject",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationRequest.subject",
        "short" : "(QI) Who or group medication request is for",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient"
            ]
          }
        ]
      },
      {
        "id" : "MedicationRequest.encounter",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationRequest.encounter",
        "short" : "(QI) Encounter created as part of encounter/admission/stay",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-encounter"
            ]
          }
        ]
      },
      {
        "id" : "MedicationRequest.authoredOn",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationRequest.authoredOn",
        "short" : "(QI) When request was initially authored",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "MedicationRequest.requester",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationRequest.requester",
        "short" : "(QI) Who/What requested the Request",
        "comment" : "Should include QICoreDevice but the base profile excludes device references.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-practitioner",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-practitionerrole",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-patient"
            ],
            "_targetProfile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
                    "valueBoolean" : false
                  }
                ]
              }
            ]
          }
        ]
      },
      {
        "id" : "MedicationRequest.reasonCode",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationRequest.reasonCode",
        "short" : "(QI) Reason or indication for ordering or not ordering the medication"
      },
      {
        "id" : "MedicationRequest.reasonReference",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationRequest.reasonReference",
        "short" : "(QI) QI-Core Condition or Observation that supports the prescription",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-condition-encounter-diagnosis",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-condition-problems-health-concerns",
              "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-simple-observation"
            ]
          }
        ]
      },
      {
        "id" : "MedicationRequest.dosageInstruction",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationRequest.dosageInstruction",
        "short" : "(QI) How medication should be taken"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationRequest.dosageInstruction.timing",
        "short" : "(QI) When medication should be administered"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationRequest.dosageInstruction.timing.repeat",
        "short" : "(QI) When the event is to occur"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.bounds[x]",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.bounds[x]",
        "short" : "(QI) Length/Range of lengths, or (Start and/or end) limits"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.frequency",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.frequency",
        "short" : "(QI) Event occurs frequency times per period"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.frequencyMax",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.frequencyMax",
        "short" : "(QI) Event occurs frequencyMax times per period"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.period",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.period",
        "short" : "(QI) Event occurs frequency times per period"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.periodMax",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.periodMax",
        "short" : "(QI) Upper limit of period (3-4 hours)"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.periodUnit",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.periodUnit",
        "short" : "(QI) s | min | h | d | wk | mo | a - unit of time (UCUM)"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.asNeeded[x]",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationRequest.dosageInstruction.asNeeded[x]",
        "short" : "(QI) Take \"as needed\" (for x)"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.doseAndRate",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationRequest.dosageInstruction.doseAndRate",
        "short" : "(QI) Amount of medication administered"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.doseAndRate.dose[x]",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationRequest.dosageInstruction.doseAndRate.dose[x]",
        "short" : "(QI) Amount of medication per dose"
      },
      {
        "id" : "MedicationRequest.dispenseRequest",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationRequest.dispenseRequest",
        "short" : "(QI) Medication supply authorization"
      },
      {
        "id" : "MedicationRequest.dispenseRequest.initialFill",
        "path" : "MedicationRequest.dispenseRequest.initialFill",
        "min" : 0,
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.dispenseRequest.dispenseInterval",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationRequest.dispenseRequest.dispenseInterval",
        "short" : "(QI) Minimum period of time between dispenses"
      },
      {
        "id" : "MedicationRequest.dispenseRequest.validityPeriod",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationRequest.dispenseRequest.validityPeriod",
        "short" : "(QI) Time period supply is authorized for"
      },
      {
        "id" : "MedicationRequest.dispenseRequest.numberOfRepeatsAllowed",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationRequest.dispenseRequest.numberOfRepeatsAllowed",
        "short" : "(QI) Number of refills authorized"
      },
      {
        "id" : "MedicationRequest.dispenseRequest.quantity",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationRequest.dispenseRequest.quantity",
        "short" : "(QI) Amount of medication to supply per dispense"
      },
      {
        "id" : "MedicationRequest.dispenseRequest.expectedSupplyDuration",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationRequest.dispenseRequest.expectedSupplyDuration",
        "short" : "(QI) Number of days supply per dispense"
      }
    ]
  }
}

```
