# QICore Medication Prohibited - QI-Core Implementation Guide v8.0.0-ballot

## Resource Profile: QICore Medication Prohibited 

 
Negation profile of MedicationRequest for decision support/quality metrics. Indicates a proposal, plan, or order not to provide a medication. 

"Must Have", "QI Elements" and "primary code path" are defined in the
[QI-Core Must Support section](index.md#mustsupport-flag).

**Must Have:**
* subject: (QI) Who or group medication request is for
* authoredOn: (QI) When request was initially authored
* status: (QI) active | on-hold | cancelled | completed | stopped | draft
* intent: (QI) proposal | plan | order | original-order | reflex-order | filler-order | instance-order | option
* medication[x]: (QI) Medication to be taken

**QI Elements:**
* doNotPerform: (QI) True if medication was not requested
* requester: (QI) Who/What requested the Request
* extension(medicationAdherence): (QI) Reported adherence to prescribed medication instructions.
* reasonCode: (QI) Reason or indication for not ordering the medication
* encounter: (QI) Encounter created as part of encounter/admission/stay
* dispenseRequest: (QI) Medication supply authorization
* reasonReference: (QI) QI-Core Condition or Observation that supports the prescription
* dosageInstruction: (QI) How medication should be taken
* reported[x]: (QI) Reported rather than primary record

**Primary code path:**medication

(PCPath) This element is the primary code path for this resource
[CQL Retrieve](https://cql.hl7.org/02-authorsguide.html#retrieve)

**Usage**
The MedicationRequest profile defines the conformance expectations for a MedicationRequest, regardless of whether it is a positive or negative statement. The MedicationRequested and MedicationNotRequested profiles represent the positive and negative statements for a medication order.

To create an expression indicating the existence of a medication request, use the profile [QICoreMedicationRequested](StructureDefinition-qicore-medicationrequested.md); to specifically request information that a MedicationRequest intentionally did not occur for a medical, patient or system reason, use the profile [QICoreMedicationProhibited](StructureDefinition-qicore-medicationprohibited.md).

The following expression retrieves instances meet measure intent for exclusion:

```
define "Reason for Not Ordering Antithrombotic":
  ["MedicationProhibited": "Antithrombotic Therapy"] NoAntithromboticDischarge
    where (NoAntithromboticDischarge.reasonCode in "Medical Reason"
      or NoAntithromboticDischarge.reasonCode in "Patient Refusal")
      and (NoAntithromboticDischarge.isCommunity() or NoAntithromboticDischarge.isDischarge())
      and NoAntithromboticDischarge.intent = 'order'
```

For a more complete discussion of representation of negation within QI-Core and quality improvement artifacts, see the [Negation in QI-Core](negation.md) topic.

 See the[patterns](patterns.md)page for implementation and usage patterns. 

### Examples

 

| | |
| :--- | :--- |
| [Negation Example using Valueset](MedicationRequest-negation-example.md) | Medication not indicated; indicates that none of the medications in the given `codeOptions` value set were requested. |
| [Negation Example using code](MedicationRequest-negation-example-code.md) | Medication not indicated; indicates that the medication specified by code was not requested. |

 

**Usages:**

* Examples for this Profile: [MedicationRequest/negation-example-code](MedicationRequest-negation-example-code.md) and [MedicationRequest/negation-example](MedicationRequest-negation-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.qicore|current/StructureDefinition/qicore-medicationprohibited)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-qicore-medicationprohibited.csv), [Excel](../StructureDefinition-qicore-medicationprohibited.xlsx), [Schematron](../StructureDefinition-qicore-medicationprohibited.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "qicore-medicationprohibited",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-primaryCodePath",
      "valueString" : "medication"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isIncluded",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-isRetrievable",
      "valueBoolean" : true
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/cqf-modelInfo-label",
      "valueString" : "MedicationProhibited"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "cqi"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 4,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/qicore/ImplementationGuide/us-qicore"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medicationprohibited",
  "version" : "8.0.0-ballot",
  "name" : "QICoreMedicationProhibited",
  "title" : "QICore Medication Prohibited",
  "status" : "active",
  "experimental" : false,
  "date" : "2018-08-22",
  "publisher" : "HL7 International / Clinical Quality Information",
  "contact" : [
    {
      "name" : "Clinical Quality Information WG",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/cqi"
        }
      ]
    }
  ],
  "description" : "Negation profile of MedicationRequest for decision support/quality metrics. Indicates a proposal, plan, or order not to provide a medication.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "script10.6",
      "uri" : "http://ncpdp.org/SCRIPT10_6",
      "name" : "Mapping to NCPDP SCRIPT 10.6"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MedicationRequest",
  "baseDefinition" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-medicationrequest",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationRequest",
        "path" : "MedicationRequest",
        "mustSupport" : false
      },
      {
        "id" : "MedicationRequest.status",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationRequest.status",
        "short" : "(QI) active | on-hold | cancelled | completed | stopped | draft",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/us/qicore/ValueSet/qicore-positive-medicationrequest-status"
        }
      },
      {
        "id" : "MedicationRequest.doNotPerform",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationRequest.doNotPerform",
        "short" : "(QI) True if medication was not requested",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "boolean"
          }
        ],
        "fixedBoolean" : true
      },
      {
        "id" : "MedicationRequest.authoredOn",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationRequest.authoredOn",
        "short" : "(QI) When request was initially authored",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "MedicationRequest.reasonCode",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/qicore/StructureDefinition/qicore-keyelement",
            "valueBoolean" : true
          }
        ],
        "path" : "MedicationRequest.reasonCode",
        "short" : "(QI) Reason or indication for not ordering the medication",
        "min" : 1,
        "max" : "1",
        "binding" : {
          "strength" : "extensible",
          "description" : "The reason the medication was prohibited",
          "valueSet" : "http://hl7.org/fhir/us/qicore/ValueSet/qicore-negation-reason"
        }
      }
    ]
  }
}

```
